/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.Event;
import de.matthiasmann.twl.GUI;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import de.matthiasmann.twl.renderer.AnimationState;
import de.matthiasmann.twl.renderer.Image;
import net.sf.hale.AreaListener;
import net.sf.hale.Game;
import net.sf.hale.ability.Targeter;
import net.sf.hale.area.Area;
import net.sf.hale.area.Transition;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.PC;
import net.sf.hale.interfacelock.InterfaceLock;
import net.sf.hale.tileset.AreaTileGrid;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import net.sf.hale.widgets.EntityMouseover;
import net.sf.hale.widgets.OverHeadFadeAway;
import org.lwjgl.opengl.GL11;

public class AreaViewer
extends Widget
implements AreaTileGrid.AreaRenderer {
    public static final AnimationState.StateKey STATE_ACTIVE = AnimationState.StateKey.get((String)"active");
    private Image hexAnim;
    private Image hexFilledBlack;
    private Image hexFilledGrey;
    private Image hexWhite;
    private Image hexRed;
    private Image hexBlue;
    private Image hexGreen;
    private Image hexGrey;
    public Point mouseHoverTile = new Point();
    public boolean mouseHoverValid = true;
    private Area area;
    private final Point scroll = new Point(0, 0);
    private final Point maxScroll = new Point(0, 0);
    private final Point minScroll = new Point(0, 0);
    private AreaListener areaListener;
    private DelayedScroll delayedScroll;
    private ScreenShake screenShake;
    private long fadeInTime;

    public AreaViewer(Area area) {
        this.area = area;
        this.fadeInTime = System.currentTimeMillis();
    }

    public void setArea(Area area) {
        this.area = area;
        this.scroll.x = 0;
        this.scroll.y = 0;
        this.invalidateLayout();
        this.setMaxScroll();
        this.scroll(0, 0);
        Game.curCampaign.getTileset(area.getTileset()).loadTiles();
        area.getTileGrid().cacheSprites();
        this.fadeInTime = System.currentTimeMillis();
        Game.timer.resetTime();
    }

    public void fadeIn() {
        this.fadeInTime = System.currentTimeMillis();
    }

    @Override
    public Area getArea() {
        return this.area;
    }

    public void setListener(AreaListener areaListener) {
        this.areaListener = areaListener;
    }

    @Override
    public void drawInterface(de.matthiasmann.twl.AnimationState animationState) {
        Creature creature;
        Object object;
        if (!Game.interfaceLocker.locked()) {
            object = this.areaListener.getCombatRunner().getActiveCreature();
            if (Game.isInTurnMode() && !((Entity)object).isPlayerFaction()) {
                this.drawBlueHex(this.areaListener.getCombatRunner().getActiveCreature().getLocation().toPoint(), animationState);
            } else {
                this.drawBlueHex(Game.curCampaign.party.getSelected().getLocation().toPoint(), animationState);
            }
        }
        if ((object = this.areaListener.getTargeterManager().getCurrentTargeter()) != null) {
            ((Targeter)object).draw(animationState);
        }
        if (this.mouseHoverValid) {
            this.drawWhiteHex(this.mouseHoverTile, animationState);
        } else {
            this.drawRedHex(this.mouseHoverTile, animationState);
        }
        if (Game.isInTurnMode() && !this.areaListener.getTargeterManager().isInTargetMode() && (creature = this.areaListener.getCombatRunner().getActiveCreature()) != null && !Game.interfaceLocker.locked()) {
            this.drawAnimHex(creature.getLocation().toPoint(), animationState);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void paintWidget(GUI gUI) {
        de.matthiasmann.twl.AnimationState animationState = this.getAnimationState();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(-this.scroll.x + this.getX()), (float)(-this.scroll.y + this.getY()), (float)0.0f);
        GL11.glEnable((int)3553);
        Point point = AreaUtil.convertScreenToGrid(this.scroll.x - this.getX(), this.scroll.y - this.getY());
        Point point2 = AreaUtil.convertScreenToGrid(this.scroll.x - this.getX() + this.getWidth(), this.scroll.y - this.getY() + this.getHeight());
        point.x = Math.max(0, point.x - 2);
        point.y = Math.max(0, point.y - 2);
        if (point.x % 2 == 1) {
            --point.x;
        }
        point2.x = Math.min(this.area.getWidth() - 1, point2.x + 2);
        point2.y = Math.min(this.area.getHeight() - 1, point2.y + 2);
        this.area.getTileGrid().draw(this, animationState, point, point2);
        Entity entity = Game.mainViewer.getMouseOver().getSelectedEntity();
        if (!Game.isInTurnMode() || !(entity instanceof PC)) {
            this.drawVisibility(this.area.getVisibility(), animationState, point, point2);
        } else {
            this.drawCreatureVisibility((Creature)entity, animationState, point, point2);
        }
        GL11.glDisable((int)3553);
        GL11.glPopMatrix();
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glBegin((int)9);
        GL11.glVertex2i((int)((this.area.getWidth() - 2) * 54 + this.getX()), (int)0);
        GL11.glVertex2i((int)Game.config.getResolutionX(), (int)0);
        GL11.glVertex2i((int)Game.config.getResolutionX(), (int)Game.config.getResolutionY());
        GL11.glVertex2i((int)((this.area.getWidth() - 2) * 54 + this.getX()), (int)Game.config.getResolutionY());
        GL11.glEnd();
        GL11.glBegin((int)9);
        GL11.glVertex2i((int)0, (int)((this.area.getHeight() - 1) * 72 - 36));
        GL11.glVertex2i((int)Game.config.getResolutionX(), (int)((this.area.getHeight() - 1) * 72 - 36));
        GL11.glVertex2i((int)Game.config.getResolutionX(), (int)Game.config.getResolutionY());
        GL11.glVertex2i((int)0, (int)Game.config.getResolutionY());
        GL11.glEnd();
        if (this.fadeInTime != 0L) {
            long l = System.currentTimeMillis();
            float f = Math.min(1.0f, 1.3f - (float)(l - this.fadeInTime) / 1500.0f);
            if (f > 0.0f) {
                GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)f);
                GL11.glBegin((int)7);
                GL11.glVertex2i((int)this.getX(), (int)this.getY());
                GL11.glVertex2i((int)this.getX(), (int)this.getBottom());
                GL11.glVertex2i((int)this.getRight(), (int)this.getBottom());
                GL11.glVertex2i((int)this.getRight(), (int)this.getY());
                GL11.glEnd();
            } else {
                this.fadeInTime = 0L;
            }
        }
        GL11.glEnable((int)3553);
    }

    public void update(long l) {
        this.performDelayedScrolling(l);
        this.performScreenShake(l);
    }

    private void performScreenShake(long l) {
        if (this.screenShake == null) {
            return;
        }
        if (l > this.screenShake.endTime) {
            this.scroll(-this.screenShake.lastShakeX, -this.screenShake.lastShakeY, true);
            this.screenShake = null;
        } else if (l > this.screenShake.lastTime + 110L) {
            this.screenShake.lastTime = l;
            int n = -1 * (int)Math.signum(this.screenShake.lastShakeX) * Game.dice.rand(20, 35);
            int n2 = Game.dice.rand(-2, 2);
            this.scroll(n - this.screenShake.lastShakeX, n2 - this.screenShake.lastShakeY, true);
            this.screenShake.lastShakeX = n;
            this.screenShake.lastShakeY = n2;
        }
    }

    public void addScreenShake() {
        ScreenShake screenShake = new ScreenShake();
        long l = System.currentTimeMillis();
        screenShake.endTime = l + 600L;
        screenShake.lastTime = l;
        screenShake.lastShakeX = 1;
        this.screenShake = screenShake;
        Game.interfaceLocker.add(new InterfaceLock(Game.curCampaign.party.getSelected(), 600L));
    }

    private void performDelayedScrolling(long l) {
        if (this.delayedScroll == null) {
            return;
        }
        long l2 = l - this.delayedScroll.startTime;
        float f = this.delayedScroll.scrollXPerMilli * (float)l2 + (float)this.delayedScroll.startScrollX;
        float f2 = this.delayedScroll.scrollYPerMilli * (float)l2 + (float)this.delayedScroll.startScrollY;
        this.scroll((int)(f - (float)this.scroll.x), (int)(f2 - (float)this.scroll.y), true);
        if (this.delayedScroll.endTime < l) {
            this.delayedScroll = null;
        }
    }

    public void addDelayedScrollToScreenPoint(Point point) {
        this.delayedScroll = new DelayedScroll();
        int n = point.x - this.getInnerWidth() / 2;
        int n2 = point.y - this.getInnerHeight() / 2;
        this.delayedScroll.startScrollX = this.scroll.x;
        this.delayedScroll.startScrollY = this.scroll.y;
        float f = n - this.scroll.x;
        float f2 = n2 - this.scroll.y;
        int n3 = Game.config.getCombatDelay() * 2;
        this.delayedScroll.scrollXPerMilli = f / (float)n3;
        this.delayedScroll.scrollYPerMilli = f2 / (float)n3;
        this.delayedScroll.startTime = System.currentTimeMillis();
        this.delayedScroll.endTime = this.delayedScroll.startTime + (long)n3;
    }

    public void addDelayedScrollToCreature(Entity entity) {
        this.addDelayedScrollToScreenPoint(entity.getLocation().getCenteredScreenPoint());
    }

    public void scrollToCreature(Entity entity) {
        Point point = entity.getLocation().getCenteredScreenPoint();
        int n = point.x - this.getInnerWidth() / 2;
        int n2 = point.y - this.getInnerHeight() / 2;
        this.delayedScroll = null;
        this.scroll(n - this.scroll.x, n2 - this.scroll.y);
    }

    protected void layout() {
        super.layout();
        this.setMaxScroll();
        this.scroll(0, 0);
    }

    protected void setMaxScroll() {
        this.minScroll.x = 72;
        this.minScroll.y = 72;
        this.maxScroll.x = (this.area.getWidth() - 1) * 54 - this.getInnerWidth();
        this.maxScroll.y = this.area.getHeight() * 72 - 36 - this.getInnerHeight();
        if (this.maxScroll.x < this.minScroll.x) {
            this.maxScroll.x = this.minScroll.x;
        }
        if (this.maxScroll.y < this.minScroll.y) {
            this.maxScroll.y = this.minScroll.y;
        }
    }

    protected Point getMaxScroll() {
        return this.maxScroll;
    }

    protected Point getMinScroll() {
        return this.minScroll;
    }

    public int getScrollX() {
        return this.scroll.x;
    }

    public int getScrollY() {
        return this.scroll.y;
    }

    public Point scroll(int n, int n2) {
        return this.scroll(n, n2, false);
    }

    private Point scroll(int n, int n2, boolean bl) {
        if (!bl && this.delayedScroll != null) {
            return new Point();
        }
        int n3 = Math.min(this.maxScroll.x - this.scroll.x, n);
        n3 = Math.max(this.minScroll.x - this.scroll.x, n3);
        int n4 = Math.min(this.maxScroll.y - this.scroll.y, n2);
        n4 = Math.max(this.minScroll.y - this.scroll.y, n4);
        this.scroll.x += n3;
        this.scroll.y += n4;
        if (Game.mainViewer != null) {
            EntityMouseover entityMouseover = Game.mainViewer.getMouseOver();
            int n5 = entityMouseover.getX();
            int n6 = entityMouseover.getY();
            entityMouseover.setPosition(n5 - n3, n6 - n4);
            for (OverHeadFadeAway overHeadFadeAway : Game.mainViewer.getFadeAways()) {
                overHeadFadeAway.scroll(n3, n4);
            }
        }
        return new Point(n3, n4);
    }

    private void drawVisibility(boolean[][] blArray, de.matthiasmann.twl.AnimationState animationState, Point point, Point point2) {
        boolean[][] blArray2 = this.area.getExplored();
        for (int i = point.x; i <= point2.x; ++i) {
            for (int j = point.y; j <= point2.y; ++j) {
                Point point3 = AreaUtil.convertGridToScreen(i, j);
                if (!blArray2[i][j]) {
                    this.hexFilledBlack.draw((AnimationState)animationState, point3.x, point3.y);
                    continue;
                }
                if (blArray[i][j]) continue;
                this.hexFilledGrey.draw((AnimationState)animationState, point3.x, point3.y);
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawCreatureVisibility(Creature creature, de.matthiasmann.twl.AnimationState animationState, Point point, Point point2) {
        boolean[][] blArray = this.area.getExplored();
        for (int i = point.x; i <= point2.x; ++i) {
            for (int j = point.y; j <= point2.y; ++j) {
                Point point3 = AreaUtil.convertGridToScreen(i, j);
                if (!blArray[i][j]) {
                    this.hexFilledBlack.draw((AnimationState)animationState, point3.x, point3.y);
                    continue;
                }
                if (creature.hasVisibilityInCurrentArea(i, j)) continue;
                this.hexFilledGrey.draw((AnimationState)animationState, point3.x, point3.y);
            }
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void drawTransitions() {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        for (String string : this.area.getTransitions()) {
            Transition transition = Game.curCampaign.getAreaTransition(string);
            if (!transition.isActivated()) continue;
            Transition.EndPoint endPoint = transition.getEndPointInArea(this.area);
            Point point = AreaUtil.convertGridToScreen(endPoint.getX(), endPoint.getY());
            transition.getIcon().draw(point.x, point.y);
        }
    }

    public final void drawRedHex(Point point, de.matthiasmann.twl.AnimationState animationState) {
        Point point2 = AreaUtil.convertGridToScreen(point);
        this.hexRed.draw((AnimationState)animationState, point2.x, point2.y);
    }

    public final void drawWhiteHex(Point point, de.matthiasmann.twl.AnimationState animationState) {
        Point point2 = AreaUtil.convertGridToScreen(point);
        this.hexWhite.draw((AnimationState)animationState, point2.x, point2.y);
    }

    public final void drawGreenHex(Point point, de.matthiasmann.twl.AnimationState animationState) {
        Point point2 = AreaUtil.convertGridToScreen(point);
        this.hexGreen.draw((AnimationState)animationState, point2.x, point2.y);
    }

    public final void drawBlueHex(Point point, de.matthiasmann.twl.AnimationState animationState) {
        Point point2 = AreaUtil.convertGridToScreen(point);
        this.hexBlue.draw((AnimationState)animationState, point2.x, point2.y);
    }

    public final void drawGreyHex(Point point, de.matthiasmann.twl.AnimationState animationState) {
        Point point2 = AreaUtil.convertGridToScreen(point);
        this.hexGrey.draw((AnimationState)animationState, point2.x, point2.y);
    }

    public final void drawAnimHex(int n, int n2, de.matthiasmann.twl.AnimationState animationState) {
        Point point = AreaUtil.convertGridToScreen(n, n2);
        this.hexAnim.draw((AnimationState)animationState, point.x, point.y);
    }

    public final void drawAnimHex(Point point, de.matthiasmann.twl.AnimationState animationState) {
        this.drawAnimHex(point.x, point.y, animationState);
    }

    protected boolean handleEvent(Event event) {
        if (super.handleEvent(event)) {
            return true;
        }
        return this.areaListener.handleEvent(event);
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.areaListener.setThemeInfo(themeInfo);
        this.hexFilledBlack = themeInfo.getImage("hexfilledblack");
        this.hexFilledGrey = themeInfo.getImage("hexfilledgrey");
        this.hexWhite = themeInfo.getImage("hexwhite");
        this.hexRed = themeInfo.getImage("hexred");
        this.hexBlue = themeInfo.getImage("hexblue");
        this.hexGreen = themeInfo.getImage("hexgreen");
        this.hexGrey = themeInfo.getImage("hexgrey");
        this.hexAnim = themeInfo.getImage("hexanim");
        this.getAnimationState().setAnimationState(STATE_ACTIVE, true);
    }

    private class ScreenShake {
        private long endTime;
        private long lastTime;
        private int lastShakeX;
        private int lastShakeY;

        private ScreenShake() {
        }
    }

    private class DelayedScroll {
        private int startScrollX;
        private int startScrollY;
        private float scrollXPerMilli;
        private float scrollYPerMilli;
        private long startTime;
        private long endTime;

        private DelayedScroll() {
        }
    }
}

