/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.view;

import de.matthiasmann.twl.ScrollPane;
import de.matthiasmann.twl.ThemeInfo;
import de.matthiasmann.twl.Widget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.ability.AbilitySelectionList;
import net.sf.hale.ability.CreatureAbilitySet;
import net.sf.hale.characterbuilder.AbilitySelectionListPane;
import net.sf.hale.characterbuilder.AbilitySelectorButton;
import net.sf.hale.entity.PC;

public class AbilitiesSheet
extends ScrollPane
implements CreatureAbilitySet.Listener,
AbilitySelectorButton.HoverHolder {
    private boolean abilitySetModified;
    private PC parent;
    private int viewerGap;
    private Content content = new Content();
    private List<AbilitySelectionListPane> listPanes;
    private Widget hoverTop;
    private Widget hoverBottom;

    public AbilitiesSheet() {
        this.setContent(this.content);
        this.listPanes = new ArrayList<AbilitySelectionListPane>();
    }

    @Override
    public void abilitySetModified() {
        this.abilitySetModified = true;
    }

    public void updateContent(PC pC) {
        if (!this.abilitySetModified && pC == this.parent) {
            return;
        }
        if (pC != this.parent) {
            if (this.parent != null) {
                pC.abilities.removeListener(this);
            }
            this.parent = pC;
            pC.abilities.addListener(this);
        }
        if (this.abilitySetModified) {
            this.abilitySetModified = false;
        }
        this.rebuildAbilityLists();
    }

    private void rebuildAbilityLists() {
        Object object;
        for (AbilitySelectionListPane object22 : this.listPanes) {
            this.content.removeChild(object22);
        }
        this.listPanes.clear();
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        for (String string : this.parent.roles.getRoleIDs()) {
            object = Game.ruleset.getRole(string);
            linkedHashSet.addAll(object.getAllReferencedAbilitySelectionLists());
        }
        linkedHashSet.addAll(this.parent.getTemplate().getRace().getAllReferencedAbilitySelectionLists());
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            AbilitySelectionList abilitySelectionList = (AbilitySelectionList)iterator.next();
            object = new AbilitySelectionListPane(abilitySelectionList, this.parent, this, false);
            this.listPanes.add((AbilitySelectionListPane)((Object)object));
            this.content.add((Widget)object);
        }
    }

    protected void applyTheme(ThemeInfo themeInfo) {
        super.applyTheme(themeInfo);
        this.viewerGap = themeInfo.getParameter("viewerGap", 5);
    }

    @Override
    public void removeHoverWidgets(Widget widget, Widget widget2) {
        if (this.hoverTop != null && this.hoverTop == widget) {
            this.content.removeChild(this.hoverTop);
            this.hoverTop = null;
        }
        if (this.hoverBottom != null && this.hoverBottom == widget2) {
            this.content.removeChild(this.hoverBottom);
            this.hoverBottom = null;
        }
    }

    @Override
    public void setHoverWidgets(Widget widget, Widget widget2) {
        if (this.hoverTop != null) {
            this.content.removeChild(this.hoverTop);
        }
        if (this.hoverBottom != null) {
            this.content.removeChild(this.hoverBottom);
        }
        this.hoverTop = widget;
        this.hoverBottom = widget2;
        if (widget != null) {
            this.content.add(widget);
        }
        if (widget2 != null) {
            this.content.add(widget2);
        }
    }

    private class Content
    extends Widget {
        private Content() {
        }

        public void layout() {
            super.layout();
            int n = this.getInnerY();
            for (AbilitySelectionListPane abilitySelectionListPane : AbilitiesSheet.this.listPanes) {
                abilitySelectionListPane.setSize(abilitySelectionListPane.getPreferredWidth(), abilitySelectionListPane.getPreferredHeight());
                abilitySelectionListPane.setPosition(this.getInnerX(), n);
                n = abilitySelectionListPane.getBottom() + AbilitiesSheet.this.viewerGap;
            }
        }

        public int getPreferredInnerWidth() {
            int n = 0;
            for (AbilitySelectionListPane abilitySelectionListPane : AbilitiesSheet.this.listPanes) {
                n = Math.max(n, abilitySelectionListPane.getPreferredWidth());
            }
            return n;
        }

        public int getPreferredInnerHeight() {
            int n = 0;
            for (AbilitySelectionListPane abilitySelectionListPane : AbilitiesSheet.this.listPanes) {
                n += abilitySelectionListPane.getPreferredHeight() + AbilitiesSheet.this.viewerGap;
            }
            return n;
        }
    }
}

