/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONObject;

public class SimpleJSONParser {
    private SimpleJSONObject result;

    public SimpleJSONParser(String string, ResourceType resourceType) {
        this.initialize(ResourceManager.getReader(string + resourceType.getExtension()), string);
    }

    public SimpleJSONParser(String string) {
        this.initialize(ResourceManager.getReader(string), string);
    }

    public SimpleJSONParser(String string, InputStream inputStream) {
        this.initialize(new InputStreamReader(inputStream), string);
    }

    public SimpleJSONParser(File file) {
        try {
            this.initialize(new FileReader(file), file.getPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Logger.appendToErrorLog("Unable to find file " + file.getPath() + " to parse.");
        }
    }

    public SimpleJSONParser(Reader reader, String string) {
        this.initialize(reader, string);
    }

    private void initialize(Reader reader, String string) {
        JSONParser jSONParser = new JSONParser(-1);
        try {
            this.result = new SimpleJSONObject((JSONObject)jSONParser.parse(reader), string);
            reader.close();
        }
        catch (ParseException parseException) {
            Logger.appendToErrorLog("JSON Parsing error in " + string, parseException);
            return;
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("I/O Error in " + string, iOException);
        }
    }

    public void setWarnOnMissingKeys(boolean bl) {
        this.result.setWarnOnMissingKeys(bl);
    }

    public void warnOnUnusedKeys() {
        this.result.warnOnUnusedKeys();
    }

    public boolean isString(String string) {
        return this.result.isString(string);
    }

    public boolean isInteger(String string) {
        return this.result.isInteger(string);
    }

    public boolean isFloat(String string) {
        return this.result.isFloat(string);
    }

    public boolean isBoolean(String string) {
        return this.result.isBoolean(string);
    }

    public int get(String string, int n) {
        return this.result.get(string, n);
    }

    public String get(String string, String string2) {
        return this.result.get(string, string2);
    }

    public boolean get(String string, boolean bl) {
        return this.result.get(string, bl);
    }

    public float get(String string, float f) {
        return this.result.get(string, f);
    }

    public SimpleJSONArray getArray(String string) {
        return this.result.getArray(string);
    }

    public SimpleJSONObject getObject(String string) {
        return this.result.getObject(string);
    }

    public boolean containsKey(String string) {
        return this.result.containsKey(string);
    }

    public Set<String> keySet() {
        return this.result.keySet();
    }

    public SimpleJSONObject getObject() {
        return this.result;
    }
}

