/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArray;

public class SimpleJSONObject {
    private static SimpleJSONArray emptyArray = new SimpleJSONArray();
    private boolean warnOnMissingKeys;
    private String objectID;
    private JSONObject object;
    private Set<String> usedKeys;
    private List<SimpleJSONObject> subObjects;
    private List<SimpleJSONArray> subArrays;

    public SimpleJSONObject(JSONObject jSONObject, String string) {
        this.object = jSONObject;
        this.objectID = string;
        this.warnOnMissingKeys = false;
        this.subObjects = new ArrayList<SimpleJSONObject>(1);
        this.subArrays = new ArrayList<SimpleJSONArray>(1);
        this.usedKeys = new HashSet<String>();
    }

    public String getObjectID() {
        return this.objectID;
    }

    public void setWarnOnMissingKeys(boolean bl) {
        this.warnOnMissingKeys = bl;
        for (SimpleJSONObject object : this.subObjects) {
            object.setWarnOnMissingKeys(bl);
        }
        for (SimpleJSONArray simpleJSONArray : this.subArrays) {
            simpleJSONArray.setWarnOnMissingKeys(bl);
        }
    }

    protected void warnOnUnusedKeys() {
        for (String object : this.object.keySet()) {
            if (this.usedKeys.contains(object) || object.equals("comment")) continue;
            Logger.appendToWarningLog("In " + this.objectID + " unused key \"" + object + "\"");
        }
        for (SimpleJSONObject simpleJSONObject : this.subObjects) {
            simpleJSONObject.warnOnUnusedKeys();
        }
        for (SimpleJSONArray simpleJSONArray : this.subArrays) {
            simpleJSONArray.warnOnUnusedKeys();
        }
    }

    public boolean isString(String string) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return false;
        }
        return object instanceof String;
    }

    public boolean isInteger(String string) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return false;
        }
        return object instanceof Integer;
    }

    public boolean isFloat(String string) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return false;
        }
        return object instanceof Double;
    }

    public boolean isBoolean(String string) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return false;
        }
        return object instanceof Boolean;
    }

    public String get(String string, String string2) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return string2;
        }
        if (object instanceof String) {
            this.usedKeys.add(string);
            return (String)this.object.get((Object)string);
        }
        Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is not a String.");
        return string2;
    }

    public int get(String string, int n) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return n;
        }
        if (object instanceof Integer) {
            this.usedKeys.add(string);
            return (Integer)object;
        }
        Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is not an int.");
        return n;
    }

    public boolean get(String string, boolean bl) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return bl;
        }
        if (object instanceof Boolean) {
            this.usedKeys.add(string);
            return (Boolean)object;
        }
        Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is not a boolean.");
        return bl;
    }

    public float get(String string, float f) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return f;
        }
        if (object instanceof Double) {
            this.usedKeys.add(string);
            return ((Double)object).floatValue();
        }
        if (object instanceof BigDecimal) {
            this.usedKeys.add(string);
            return ((BigDecimal)object).floatValue();
        }
        Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is not a float, is " + object.getClass().getCanonicalName());
        return f;
    }

    public SimpleJSONArray getArray(String string) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return emptyArray;
        }
        if (object instanceof JSONArray) {
            this.usedKeys.add(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.objectID);
            stringBuilder.append(" -> ");
            stringBuilder.append(string);
            SimpleJSONArray simpleJSONArray = new SimpleJSONArray((JSONArray)object, stringBuilder.toString());
            if (this.warnOnMissingKeys) {
                simpleJSONArray.setWarnOnMissingKeys(this.warnOnMissingKeys);
            }
            this.subArrays.add(simpleJSONArray);
            return simpleJSONArray;
        }
        Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is not an array.");
        return emptyArray;
    }

    public SimpleJSONObject getObject(String string) {
        Object object = this.object.get((Object)string);
        if (object == null) {
            if (this.warnOnMissingKeys) {
                Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is missing");
            }
            return null;
        }
        if (object instanceof JSONObject) {
            this.usedKeys.add(string);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.objectID);
            stringBuilder.append(" -> ");
            stringBuilder.append(string);
            SimpleJSONObject simpleJSONObject = new SimpleJSONObject((JSONObject)object, stringBuilder.toString());
            if (this.warnOnMissingKeys) {
                simpleJSONObject.setWarnOnMissingKeys(this.warnOnMissingKeys);
            }
            this.subObjects.add(simpleJSONObject);
            return simpleJSONObject;
        }
        Logger.appendToWarningLog("In resource " + this.objectID + ": \"" + string + "\" is not an object.");
        return null;
    }

    public boolean containsKey(String string) {
        return this.object.containsKey((Object)string);
    }

    public Set<String> keySet() {
        Set set = this.object.keySet();
        set.remove("comment");
        return set;
    }
}

