/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONObject;

public class SimpleJSONArrayEntry {
    private String id;
    private Object data;
    private boolean warnOnMissingKeys;
    private boolean entryRead;
    private SimpleJSONObject objData;
    private SimpleJSONArray arrayData;

    public SimpleJSONArrayEntry(Object object, String string) {
        this.id = string;
        this.data = object;
        this.entryRead = false;
    }

    public String getID() {
        return this.id;
    }

    protected void setWarnOnMissingKeys(boolean bl) {
        this.warnOnMissingKeys = bl;
        if (this.objData != null) {
            this.objData.setWarnOnMissingKeys(bl);
        }
        if (this.arrayData != null) {
            this.arrayData.setWarnOnMissingKeys(bl);
        }
    }

    protected void warnOnUnusedKeys() {
        if (!this.entryRead) {
            Logger.appendToWarningLog(this.id + " is an unused key.");
        } else if (this.objData != null) {
            this.objData.warnOnUnusedKeys();
        } else if (this.arrayData != null) {
            this.arrayData.warnOnUnusedKeys();
        }
    }

    public boolean isBoolean() {
        return this.data instanceof Boolean;
    }

    public boolean isInteger() {
        return this.data instanceof Integer;
    }

    public boolean isFloat() {
        return this.data instanceof Double;
    }

    public boolean isObject() {
        return this.data instanceof JSONObject;
    }

    public boolean isArray() {
        return this.data instanceof JSONArray;
    }

    public boolean isString() {
        return this.data instanceof String;
    }

    public String getString() {
        if (this.data instanceof String) {
            this.entryRead = true;
            return (String)this.data;
        }
        Logger.appendToWarningLog("Array Entry \"" + this.id + "\" is not a string.");
        return null;
    }

    public SimpleJSONArray getArray() {
        if (this.data instanceof JSONArray) {
            this.entryRead = true;
            this.arrayData = new SimpleJSONArray((JSONArray)this.data, this.id);
            if (this.warnOnMissingKeys) {
                this.arrayData.setWarnOnMissingKeys(this.warnOnMissingKeys);
            }
            return this.arrayData;
        }
        Logger.appendToWarningLog("Array Entry \"" + this.id + "\" is not an array.");
        return null;
    }

    public SimpleJSONObject getObject() {
        if (this.data instanceof JSONObject) {
            this.entryRead = true;
            this.objData = new SimpleJSONObject((JSONObject)this.data, this.id);
            if (this.warnOnMissingKeys) {
                this.objData.setWarnOnMissingKeys(this.warnOnMissingKeys);
            }
            return this.objData;
        }
        Logger.appendToWarningLog("Array Entry \"" + this.id + "\" is not an object.");
        return null;
    }

    public int getInt(int n) {
        if (this.data instanceof Integer) {
            this.entryRead = true;
            return (Integer)this.data;
        }
        Logger.appendToWarningLog("Array entry \"" + this.id + "\" is not an int.");
        return n;
    }

    public boolean getBoolean(boolean bl) {
        if (this.data instanceof Boolean) {
            this.entryRead = true;
            return (Boolean)this.data;
        }
        Logger.appendToWarningLog("Array entry \"" + this.id + "\" is not a boolean.");
        return bl;
    }

    public float getFloat(float f) {
        if (this.data instanceof Double) {
            this.entryRead = true;
            return ((Double)this.data).floatValue();
        }
        Logger.appendToWarningLog("Array entry \"" + this.id + "\" is not a float.");
        return f;
    }
}

