/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.SaveWriter;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SaveFileHeader;
import net.sf.hale.util.SimpleJSONObject;

public class SaveGameUtil {
    public static String getRef(Object object) {
        return object.getClass().getName() + '@' + Integer.toHexString(object.hashCode());
    }

    public static Object loadObject(SimpleJSONObject simpleJSONObject) throws LoadGameException {
        try {
            Class<?> clazz = Class.forName(simpleJSONObject.get("class", null));
            Method method = clazz.getMethod("load", SimpleJSONObject.class);
            return method.invoke(null, simpleJSONObject);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new LoadGameException("Error loading object, class " + simpleJSONObject.get("class", null) + " not found.");
        }
        catch (SecurityException securityException) {
            throw new LoadGameException("Error loading object, method load is not accessible.");
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new LoadGameException("Error loading object for class " + simpleJSONObject.get("class", null) + ", method load not found.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new LoadGameException("Error loading object, invalid load arguments");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new LoadGameException("Error loading object, method load is not accessible.");
        }
        catch (InvocationTargetException invocationTargetException) {
            Logger.appendToErrorLog("Error loading object.", invocationTargetException.getCause());
            throw new LoadGameException("Error loading object, method load constructor error");
        }
    }

    private static void sortFilesByTimeModified(File[] fileArray) {
        Arrays.sort(fileArray, new Comparator<File>(){

            @Override
            public int compare(File file, File file2) {
                return Long.valueOf(file2.lastModified()).compareTo(file.lastModified());
            }
        });
    }

    public static List<String> getSaveGames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(Game.getSaveBaseDirectory());
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        SaveGameUtil.sortFilesByTimeModified(fileArray);
        for (File file2 : fileArray) {
            String string = file2.getName();
            if (!string.startsWith(Game.curCampaign.getID() + "-") || !string.endsWith(ResourceType.SaveGame.getExtension())) continue;
            String string2 = string.substring(Game.curCampaign.getID().length() + 1, string.length() - ResourceType.SaveGame.getLength());
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static boolean isQuickSave(String string) {
        return string.startsWith("quicksave");
    }

    public static File getNextQuickSaveFile() {
        File[] fileArray = new File(Game.getSaveBaseDirectory()).listFiles();
        if (fileArray == null) {
            return SaveGameUtil.getSaveFile("quicksave1");
        }
        SaveGameUtil.sortFilesByTimeModified(fileArray);
        for (File file : fileArray) {
            String string;
            String string2 = file.getName();
            if (!string2.startsWith(Game.curCampaign.getID()) || !(string = string2.substring(Game.curCampaign.getID().length() + 1, string2.length() - ResourceType.SaveGame.getLength())).startsWith("quicksave")) continue;
            int n = 0;
            try {
                n = Integer.parseInt(Character.toString(string.charAt(string.length() - 1)));
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error finding most recently created quicksave.  Reverting to index 1.", exception);
            }
            if (++n > 9) {
                n = 1;
            }
            return SaveGameUtil.getSaveFile("quicksave" + n);
        }
        return SaveGameUtil.getSaveFile("quicksave1");
    }

    public static File getSaveFile(String string) {
        File file = new File(Game.getSaveBaseDirectory());
        if (!file.exists() || !file.isDirectory()) {
            file.mkdirs();
        }
        return new File(Game.getSaveBaseDirectory() + Game.curCampaign.getID() + "-" + string + ResourceType.SaveGame.getExtension());
    }

    public static void saveGame(File file) throws IOException {
        JSONOrderedObject jSONOrderedObject = Game.curCampaign.getSaveGameData();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(fileOutputStream);
        SaveFileHeader saveFileHeader = new SaveFileHeader(Game.curCampaign);
        SaveFileHeader.write(saveFileHeader, gZIPOutputStream);
        PrintWriter printWriter = new PrintWriter(gZIPOutputStream);
        SaveWriter.writeJSON(jSONOrderedObject, printWriter);
        printWriter.close();
    }
}

