/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.sf.hale.Game;
import net.sf.hale.entity.Creature;
import net.sf.hale.rules.Campaign;

public class SaveFileHeader {
    private List<String> characterNames;
    private String areaName;
    private int level;
    private String versionID;

    private SaveFileHeader() {
    }

    public SaveFileHeader(Campaign campaign) {
        int n = 0;
        this.characterNames = new ArrayList<String>(campaign.party.size());
        for (Creature creature : campaign.party) {
            if (creature.isSummoned()) continue;
            this.characterNames.add(creature.getTemplate().getName());
            n = Math.max(n, creature.stats.getCreatureLevel());
        }
        this.level = n;
        this.areaName = campaign.curArea.getName();
        this.versionID = Game.config.getVersionID();
    }

    public String getVersionID() {
        return this.versionID;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public int getPartyLevel() {
        return this.level;
    }

    public List<String> getPartyNames() {
        return Collections.unmodifiableList(this.characterNames);
    }

    public String getPartyNamesString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.characterNames.size() - 1; ++i) {
            stringBuilder.append(this.characterNames.get(i));
            stringBuilder.append(", ");
        }
        stringBuilder.append(this.characterNames.get(this.characterNames.size() - 1));
        return stringBuilder.toString();
    }

    public static void write(SaveFileHeader saveFileHeader, GZIPOutputStream gZIPOutputStream) throws IOException {
        PrintStream printStream = new PrintStream(gZIPOutputStream);
        printStream.print("HEADER\n");
        printStream.print("BuildID ");
        printStream.print(saveFileHeader.versionID);
        printStream.print("\n");
        printStream.print(saveFileHeader.areaName);
        printStream.print("\n");
        printStream.print("Level ");
        printStream.print(saveFileHeader.level);
        printStream.print("\n");
        for (String string : saveFileHeader.characterNames) {
            printStream.print(string);
            printStream.print("\n");
        }
        printStream.print("END HEADER\n");
    }

    private static String nextLine(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read()) != -1) {
            switch (n) {
                case 10: {
                    return stringBuilder.toString();
                }
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    private static String nextToken(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        while ((n = inputStream.read()) != -1) {
            switch (n) {
                case 10: 
                case 32: {
                    return stringBuilder.toString();
                }
            }
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    public static SaveFileHeader read(GZIPInputStream gZIPInputStream) throws IOException {
        String string;
        SaveFileHeader saveFileHeader = new SaveFileHeader();
        SaveFileHeader.nextToken(gZIPInputStream);
        SaveFileHeader.nextToken(gZIPInputStream);
        saveFileHeader.versionID = SaveFileHeader.nextToken(gZIPInputStream);
        saveFileHeader.areaName = SaveFileHeader.nextLine(gZIPInputStream);
        SaveFileHeader.nextToken(gZIPInputStream);
        saveFileHeader.level = Integer.parseInt(SaveFileHeader.nextToken(gZIPInputStream));
        saveFileHeader.characterNames = new ArrayList<String>();
        while (!"END HEADER".equals(string = SaveFileHeader.nextLine(gZIPInputStream))) {
            saveFileHeader.characterNames.add(string);
        }
        return saveFileHeader;
    }
}

