/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import net.sf.hale.util.AreaUtil;

public class Point {
    public int x;
    public int y;

    public Point(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public Point() {
        this.x = 0;
        this.y = 0;
    }

    public Point(Point point) {
        this.x = point.x;
        this.y = point.y;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Point)) {
            return false;
        }
        return ((Point)object).x == this.x && ((Point)object).y == this.y;
    }

    public double angleTo(Point point) {
        Point point2 = AreaUtil.convertGridToScreen(this);
        Point point3 = AreaUtil.convertGridToScreen(point);
        int n = point3.x - point2.x;
        int n2 = point3.y - point2.y;
        if (n == 0) {
            return (double)Math.signum(n2) * Math.PI / 2.0;
        }
        if (n > 0) {
            return Math.atan((double)n2 / (double)n);
        }
        return Math.atan((double)n2 / (double)n) + Math.PI;
    }

    public double screenDistance(Point point) {
        Point point2 = AreaUtil.convertGridToScreen(this);
        Point point3 = AreaUtil.convertGridToScreen(point);
        int n = AreaUtil.euclideanDistance2(point2.x, point2.y, point3.x, point3.y);
        return Math.sqrt(n);
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

