/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.area.Area;
import net.sf.hale.area.AreaEntityList;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Path;
import net.sf.hale.entity.Trap;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class PathFinder {
    public static Path findPathIgnoreCreatures(Creature creature, Point point, Data data) {
        return PathFinder.findPath(creature, point, Collections.singletonList(point), data, EndPointStatus.IgnoreCreatures);
    }

    public static Path findPathIgnorePartyMembers(Creature creature, Point point, Data data) {
        return PathFinder.findPath(creature, point, Collections.singletonList(point), data, EndPointStatus.IgnoreParty);
    }

    public static Path findPath(Creature creature, Point point, List<Point> list, Data data) {
        return PathFinder.findPath(creature, point, list, data, EndPointStatus.Normal);
    }

    private static Path findPath(Creature creature, Point point, List<Point> list, Data data, EndPointStatus endPointStatus) {
        int n;
        List<Creature> list2 = PathFinder.computeThreateningCreatures(creature, data);
        Point point2 = creature.getLocation().toPoint();
        Point point3 = new Point();
        for (Point point4 : list) {
            if (!point4.equals(point2)) continue;
            return new Path(data.area);
        }
        for (n = 0; n < data.width; ++n) {
            for (int i = 0; i < data.height; ++i) {
                ((Data)data).closed[n][i] = !data.pass[n][i] || !data.entityPass[n][i];
                ((Data)data).open[n][i] = false;
            }
        }
        data.openSet.clear();
        data.openSet.add(new Point(point2.x, point2.y));
        ((Data)data).open[point2.x][point2.y] = true;
        ((Data)data).gScore[point2.x][point2.y] = 0;
        ((Data)data).hScore[point2.x][point2.y] = AreaUtil.distance(point2, point);
        ((Data)data).fScore[point2.x][point2.y] = data.hScore[point2.x][point2.y] + data.gScore[point2.x][point2.y];
        while (!data.openSet.isEmpty()) {
            n = PathFinder.findLowestFScore(data.openSet, data.fScore, point3);
            if (PathFinder.isEndPoint(point3, list, data, endPointStatus)) {
                return PathFinder.getFinalPath(data, point2, point3, list2);
            }
            data.openSet.remove(n);
            ((Data)data).open[point3.x][point3.y] = false;
            ((Data)data).closed[point3.x][point3.y] = true;
            byte by = data.area.getElevationGrid().getElevation(point3.x, point3.y);
            Point[] pointArray = AreaUtil.getAdjacentTiles(point3);
            for (int i = 0; i < pointArray.length; ++i) {
                boolean bl;
                if (!PathFinder.checkCoordinates(pointArray[i], data) || data.closed[pointArray[i].x][pointArray[i].y] || data.area.getElevationGrid().getElevation(pointArray[i].x, pointArray[i].y) != by) continue;
                int n2 = data.gScore[point3.x][point3.y] + PathFinder.getCost(creature, data, pointArray[i], list2);
                if (!data.open[pointArray[i].x][pointArray[i].y]) {
                    data.openSet.add(pointArray[i]);
                    ((Data)data).open[pointArray[i].x][pointArray[i].y] = true;
                    bl = true;
                } else {
                    bl = n2 < data.gScore[pointArray[i].x][pointArray[i].y];
                }
                if (!bl) continue;
                ((Data)data).parent[pointArray[i].x][pointArray[i].y].x = point3.x;
                ((Data)data).parent[pointArray[i].x][pointArray[i].y].y = point3.y;
                ((Data)data).gScore[pointArray[i].x][pointArray[i].y] = n2;
                ((Data)data).hScore[pointArray[i].x][pointArray[i].y] = AreaUtil.distance(pointArray[i], point);
                ((Data)data).fScore[pointArray[i].x][pointArray[i].y] = data.gScore[pointArray[i].x][pointArray[i].y] + data.hScore[pointArray[i].x][pointArray[i].y];
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Creature> computeThreateningCreatures(Creature creature, Data data) {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        if (creature.stats.isHidden()) {
            return arrayList;
        }
        if (!Game.isInTurnMode()) {
            return arrayList;
        }
        AreaEntityList areaEntityList = data.area.getEntities();
        synchronized (areaEntityList) {
            for (Entity entity : data.area.getEntities()) {
                Creature creature2;
                if (entity == creature || !(entity instanceof Creature) || !(creature2 = (Creature)entity).canTakeMoveAoOIgnoringLocation(creature)) continue;
                arrayList.add(creature2);
            }
        }
        return arrayList;
    }

    private static final int getCost(Creature creature, Data data, Point point, List<Creature> list) {
        int n = 1;
        Object object = list.iterator();
        while (object.hasNext()) {
            Creature creature2 = object.next();
            if (!creature2.threatensPointInCurrentArea(point.x, point.y)) continue;
            ++n;
        }
        if (creature.isPlayerFaction() && (object = data.area.getTrapAtGridPoint(point)) != null && ((Trap)object).isSpotted() && ((Entity)object).getFaction().isHostile(creature)) {
            n += 2;
        }
        return n;
    }

    private static final boolean isEndPoint(Point point, List<Point> list, Data data, EndPointStatus endPointStatus) {
        for (Point point2 : list) {
            if (point.x != point2.x || point.y != point2.y) continue;
            Creature creature = data.area.getCreatureAtGridPoint(point);
            if (creature == null) {
                return true;
            }
            switch (endPointStatus) {
                case IgnoreCreatures: {
                    return true;
                }
                case IgnoreParty: {
                    for (Creature creature2 : Game.curCampaign.party) {
                        if (creature2 != creature) continue;
                        return true;
                    }
                    break;
                }
            }
            return false;
        }
        return false;
    }

    private static final boolean checkCoordinates(Point point, Data data) {
        return point.x >= 0 && point.x < data.width && point.y >= 0 && point.y < data.height;
    }

    private static final Path getFinalPath(Data data, Point point, Point point2, List<Creature> list) {
        ArrayList<Creature> arrayList = new ArrayList<Creature>();
        ArrayList<Point> arrayList2 = new ArrayList<Point>();
        Point point3 = point2;
        arrayList2.add(point3);
        while (point3.x != point.x || point3.y != point.y) {
            Point point4 = data.parent[point3.x][point3.y];
            arrayList2.add(new Point(point4));
            point3 = point4;
            for (Creature creature : list) {
                if (!creature.threatensPointInCurrentArea(point3.x, point3.y)) continue;
                arrayList.add(creature);
            }
        }
        arrayList2.remove(arrayList2.size() - 1);
        if (arrayList2.size() > Game.ruleset.getValue("MaximumPathLength")) {
            return null;
        }
        return new Path(data.area, arrayList2, arrayList);
    }

    private static final int findLowestFScore(List<Point> list, int[][] nArray, Point point) {
        int n = list.size() - 1;
        point.x = list.get((int)n).x;
        point.y = list.get((int)n).y;
        int n2 = nArray[point.x][point.y];
        int n3 = n;
        for (n = list.size() - 2; n >= 0; --n) {
            int n4 = list.get((int)n).x;
            int n5 = list.get((int)n).y;
            if (nArray[n4][n5] > n2) continue;
            n2 = nArray[n4][n5];
            point.x = n4;
            point.y = n5;
            n3 = n;
        }
        return n3;
    }

    public static class Data {
        private Area area;
        private boolean[][] entityPass;
        private final int width;
        private final int height;
        private final boolean[][] pass;
        private final int[][] gScore;
        private final int[][] hScore;
        private final int[][] fScore;
        private final boolean[][] closed;
        private final boolean[][] open;
        private final Point[][] parent;
        private final List<Point> openSet;

        public Data(Area area) {
            this.area = area;
            boolean[][] blArray = area.getPassability();
            this.width = blArray.length;
            this.height = blArray[0].length;
            this.pass = new boolean[this.width][this.height];
            this.gScore = new int[this.width][this.height];
            this.hScore = new int[this.width][this.height];
            this.fScore = new int[this.width][this.height];
            this.closed = new boolean[this.width][this.height];
            this.open = new boolean[this.width][this.height];
            this.parent = new Point[this.width][this.height];
            this.openSet = new ArrayList<Point>(100);
            for (int i = 0; i < this.width; ++i) {
                for (int j = 0; j < this.height; ++j) {
                    this.pass[i][j] = blArray[i][j];
                    this.closed[i][j] = !this.pass[i][j];
                    this.open[i][j] = false;
                    this.parent[i][j] = new Point();
                }
            }
        }

        public void setEntityPassabilities(boolean[][] blArray) {
            this.entityPass = blArray;
        }
    }

    private static enum EndPointStatus {
        Normal,
        IgnoreParty,
        IgnoreCreatures;

    }
}

