/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import net.sf.hale.Game;

public class Logger {
    private static long lastWarningTimeMillis = 0L;

    public static void appendToWarningLog(String string) {
        if (Game.config == null || Game.config.isWarningModeEnabled()) {
            System.out.println(string);
        }
        PrintWriter printWriter = Logger.getWarningPrintWriter();
        printWriter.println(string);
        printWriter.close();
    }

    public static void appendToErrorLog(String string) {
        if (Game.config == null || Game.config.isDebugModeEnabled()) {
            System.err.println(string);
        }
        PrintWriter printWriter = Logger.getErrorPrintWriter();
        printWriter.print(string);
        printWriter.println();
        printWriter.print("Stack Trace:");
        printWriter.println();
        new Exception().printStackTrace(printWriter);
        printWriter.println();
        printWriter.close();
    }

    public static void appendToErrorLog(String string, Throwable throwable) {
        if (Game.config == null || Game.config.isDebugModeEnabled()) {
            System.err.println(string);
            throwable.printStackTrace();
        }
        PrintWriter printWriter = Logger.getErrorPrintWriter();
        printWriter.print(string);
        printWriter.println();
        throwable.printStackTrace(printWriter);
        printWriter.println();
        Throwable throwable2 = throwable;
        while ((throwable2 = throwable2.getCause()) != null) {
            printWriter.println("Caused by");
            throwable2.printStackTrace(printWriter);
            printWriter.println();
        }
        printWriter.close();
    }

    private static PrintWriter getErrorPrintWriter() {
        PrintWriter printWriter = Logger.getPrintWriter("error");
        printWriter.print("Log entry created " + Calendar.getInstance().getTime().toString());
        printWriter.println();
        return printWriter;
    }

    private static PrintWriter getWarningPrintWriter() {
        PrintWriter printWriter = Logger.getPrintWriter("warning");
        long l = System.currentTimeMillis();
        if (l > lastWarningTimeMillis + 1000L) {
            lastWarningTimeMillis = l;
            printWriter.print("Log entry created " + Calendar.getInstance().getTime().toString());
            printWriter.println();
        }
        return printWriter;
    }

    private static PrintWriter getPrintWriter(String string) {
        try {
            File file = new File(Game.getLogBaseDirectory());
            if (!file.exists() || !file.isDirectory()) {
                file.mkdir();
            }
            File file2 = new File(Game.getLogBaseDirectory() + string + ".log");
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file2, true));
            PrintWriter printWriter = new PrintWriter(bufferedWriter);
            return printWriter;
        }
        catch (Exception exception) {
            System.err.println("Error attempting to get print writer for log: " + string);
            exception.printStackTrace();
            return null;
        }
    }
}

