/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class LOSCone {
    private int startI;
    private int endI;
    private int r;
    private Point startArm;
    private Point endArm;
    public LOSCone next = null;

    public int getStartArmX() {
        return this.startArm.x;
    }

    public int getStartArmY() {
        return this.startArm.y;
    }

    public int getEndArmX() {
        return this.endArm.x;
    }

    public int getEndArmY() {
        return this.endArm.y;
    }

    public int getStartI() {
        return this.startI;
    }

    public int getEndI() {
        return this.endI;
    }

    public int getR() {
        return this.r;
    }

    public LOSCone(int n, Point point, int n2, Point point2) {
        this(n, point, n2, point2, 1);
    }

    public LOSCone(int n, Point point, int n2, Point point2, int n3) {
        this.startI = n;
        this.endI = n2;
        this.startArm = point;
        this.endArm = point2;
        this.r = n3;
    }

    public LOSCone(LOSCone lOSCone) {
        this(lOSCone.startI, new Point(lOSCone.startArm.x, lOSCone.startArm.y), lOSCone.endI, new Point(lOSCone.endArm.x, lOSCone.endArm.y), lOSCone.r);
    }

    public LOSCone split(int n) {
        LOSCone lOSCone = new LOSCone(this);
        this.contractEndArm(n);
        lOSCone.contractStartArm(n);
        return lOSCone;
    }

    public void contractStartArm(int n) {
        Point point = AreaUtil.convertPolarToGridCenter0(this.r, n);
        Point point2 = AreaUtil.convertGridToScreen(point);
        int n2 = (n + 1) % (this.r * 6) / this.r;
        if (n2 == 0) {
            this.startArm.x = point2.x + 72;
            this.startArm.y = point2.y + 36;
        } else if (n2 == 1) {
            this.startArm.x = point2.x + 54;
            this.startArm.y = point2.y + 72;
        } else if (n2 == 2) {
            this.startArm.x = point2.x + 18;
            this.startArm.y = point2.y + 72;
        } else if (n2 == 3) {
            this.startArm.x = point2.x;
            this.startArm.y = point2.y + 36;
        } else if (n2 == 4) {
            this.startArm.x = point2.x + 18;
            this.startArm.y = point2.y;
        } else if (n2 == 5) {
            this.startArm.x = point2.x + 54;
            this.startArm.y = point2.y;
        }
        this.startI = n + 1;
    }

    public void contractEndArm(int n) {
        Point point = AreaUtil.convertPolarToGridCenter0(this.r, n);
        Point point2 = AreaUtil.convertGridToScreen(point);
        int n2 = 0;
        if (n != 6 * this.r) {
            n2 = n / this.r;
        }
        if (n2 == 0) {
            this.endArm.x = point2.x;
            this.endArm.y = point2.y + 36;
        } else if (n2 == 1) {
            this.endArm.x = point2.x + 18;
            this.endArm.y = point2.y;
        } else if (n2 == 2) {
            this.endArm.x = point2.x + 54;
            this.endArm.y = point2.y;
        } else if (n2 == 3) {
            this.endArm.x = point2.x + 72;
            this.endArm.y = point2.y + 36;
        } else if (n2 == 4) {
            this.endArm.x = point2.x + 54;
            this.endArm.y = point2.y + 72;
        } else if (n2 == 5) {
            this.endArm.x = point2.x + 18;
            this.endArm.y = point2.y + 72;
        }
        this.endI = n - 1;
    }

    public void expand() {
        int n;
        Point point;
        Point point2;
        int n2 = this.startI / this.r;
        int n3 = this.startI % this.r;
        int n4 = n2 * (this.r + 1) + n3 - 1;
        if (n4 < 0) {
            n4 = 0;
        }
        boolean bl = false;
        while (n4 < (this.r + 1) * 6) {
            point2 = AreaUtil.convertPolarToGridCenter0(this.r + 1, n4);
            point = AreaUtil.convertGridToScreen(point2);
            bl = AreaUtil.lineIntersectsHex(point.x, point.y, 36, 36, this.startArm.x, this.startArm.y);
            if (bl) break;
            ++n4;
        }
        if ((n = (n2 = this.endI / this.r) * (this.r + 1) + (n3 = this.endI % this.r) + 1) > (this.r + 1) * 6) {
            n = (this.r + 1) * 6;
        }
        while (n > 0) {
            point2 = AreaUtil.convertPolarToGridCenter0(this.r + 1, n);
            point = AreaUtil.convertGridToScreen(point2);
            bl = AreaUtil.lineIntersectsHex(point.x, point.y, 36, 36, this.endArm.x, this.endArm.y);
            if (bl) break;
            --n;
        }
        this.startI = n4;
        this.endI = n;
        ++this.r;
    }
}

