/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JSEngine {
    private boolean inUse;
    private final ScriptEngine engine;

    public JSEngine(ScriptEngineManager scriptEngineManager) {
        this.engine = scriptEngineManager.getEngineByName("JavaScript");
    }

    protected synchronized void setInUse(boolean bl) {
        this.inUse = bl;
    }

    protected synchronized boolean inUse() {
        return this.inUse;
    }

    public void put(String string, Object object) {
        this.engine.put(string, object);
    }

    public Object eval(String string) throws ScriptException {
        if (!this.inUse) {
            throw new IllegalStateException("Script engine was already released.");
        }
        return this.engine.eval(string);
    }

    public Object invokeFunction(String string, Object ... objectArray) throws ScriptException, NoSuchMethodException {
        if (!this.inUse) {
            throw new IllegalStateException("Script engine was already released.");
        }
        return ((Invocable)((Object)this.engine)).invokeFunction(string, objectArray);
    }

    public boolean hasFunction(String string) {
        if (!this.inUse) {
            throw new IllegalStateException("Script engine was already released.");
        }
        Bindings bindings = this.engine.getBindings(100);
        return bindings.containsKey(string);
    }

    public synchronized void release() {
        this.inUse = false;
        this.engine.setBindings(this.engine.createBindings(), 100);
    }

    public String toString() {
        return this.engine.toString() + ": " + this.inUse;
    }
}

