/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sf.hale.util.Logger;

public class FileUtil {
    private static final String HEXES = "0123456789ABCDEF";

    public static void extractZipFile(String string, String string2) throws IOException {
        ZipEntry zipEntry;
        int n = 2048;
        byte[] byArray = new byte[n];
        new File(string).mkdir();
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(string2)));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) {
                File file = new File(string + "/" + zipEntry.getName());
                file.mkdirs();
                continue;
            }
            int n2 = 0;
            String string3 = string + "/" + zipEntry.getName();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(string3), n);
            while ((n2 = zipInputStream.read(byArray, 0, n)) > 0) {
                bufferedOutputStream.write(byArray, 0, n2);
            }
            bufferedOutputStream.flush();
            bufferedOutputStream.close();
        }
        zipInputStream.close();
    }

    public static void saveToZipFile(String string, String string2) throws IOException {
        int n = 2048;
        byte[] byArray = new byte[n];
        File file = new File(string);
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(string2)));
        List<File> list = FileUtil.getFilesAndDirectories(file);
        for (File file2 : list) {
            int n2;
            String string3 = FileUtil.getRelativePath(file, file2);
            if (file2.isDirectory()) {
                zipOutputStream.putNextEntry(new ZipEntry(string3 + "/"));
                zipOutputStream.closeEntry();
                continue;
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
            zipOutputStream.putNextEntry(new ZipEntry(string3));
            while ((n2 = bufferedInputStream.read(byArray)) > 0) {
                zipOutputStream.write(byArray, 0, n2);
            }
            zipOutputStream.flush();
            zipOutputStream.closeEntry();
            bufferedInputStream.close();
        }
        zipOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(String string) throws IOException {
        File file = new File(string);
        if (!file.exists()) {
            return null;
        }
        byte[] byArray = new byte[(int)file.length()];
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(string));
            bufferedInputStream.read(byArray);
        }
        finally {
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {
                    Logger.appendToErrorLog("Error closing file " + string, iOException);
                }
            }
        }
        return new String(byArray);
    }

    public static void writeStringToFile(File file, String string) throws IOException {
        PrintStream printStream = new PrintStream(file);
        printStream.print(string);
        printStream.close();
    }

    public static void copyFile(File file, File file2) throws IOException {
        int n;
        FileReader fileReader = new FileReader(file);
        FileWriter fileWriter = new FileWriter(file2);
        while ((n = fileReader.read()) != -1) {
            fileWriter.write(n);
        }
        fileReader.close();
        fileWriter.close();
    }

    private static List<String> getPathList(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file == null) {
            return arrayList;
        }
        try {
            for (File file2 = file.getCanonicalFile(); file2 != null; file2 = file2.getParentFile()) {
                arrayList.add(file2.getName());
            }
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error computing path for " + file.getName(), exception);
        }
        return arrayList;
    }

    private static String matchPathLists(List<String> list, List<String> list2) {
        int n;
        String string = "";
        int n2 = list.size() - 1;
        for (n = list2.size() - 1; n2 >= 0 && n >= 0 && list.get(n2).equals(list2.get(n)); --n2, --n) {
        }
        while (n2 >= 0) {
            string = string + "../";
            --n2;
        }
        while (n >= 1) {
            string = string + list2.get(n) + "/";
            --n;
        }
        if (n != -1) {
            string = string + list2.get(n);
        }
        return string;
    }

    public static String getRelativePath(File file, File file2) {
        return FileUtil.matchPathLists(FileUtil.getPathList(file), FileUtil.getPathList(file2));
    }

    public static String getRelativePath(String string, String string2) {
        return FileUtil.matchPathLists(FileUtil.getPathList(new File(string)), FileUtil.getPathList(new File(string2)));
    }

    public static String getHalfMD5Sum(File file) {
        String string = FileUtil.getMD5Sum(file);
        if (string.length() == 24) {
            return string.substring(0, 12);
        }
        return string;
    }

    public static String getMD5Sum(File file) {
        byte[] byArray = null;
        try {
            byArray = FileUtil.createSum(file);
        }
        catch (Exception exception) {
            System.err.println("Error creating MD5Sum for versioning.  Exiting.");
            System.exit(1);
        }
        return FileUtil.getHex(byArray);
    }

    private static byte[] createSum(File file) throws IOException, NoSuchAlgorithmException {
        int n;
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[1024];
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        while ((n = fileInputStream.read(byArray)) != -1) {
            messageDigest.update(byArray, 0, n);
        }
        fileInputStream.close();
        return messageDigest.digest();
    }

    private static String getHex(byte[] byArray) {
        if (byArray == null) {
            return "0";
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(HEXES.charAt((by & 0xF0) >> 4));
            stringBuilder.append(HEXES.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public static List<File> getFiles(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().equals(".svn")) continue;
            if (fileArray[i].isFile()) {
                arrayList.add(fileArray[i]);
                continue;
            }
            arrayList.addAll(FileUtil.getFiles(fileArray[i]));
        }
        return arrayList;
    }

    public static List<File> getFilesAndDirectories(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return arrayList;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].getName().equals(".svn")) continue;
            arrayList.add(fileArray[i]);
            if (!fileArray[i].isDirectory()) continue;
            arrayList.addAll(FileUtil.getFilesAndDirectories(fileArray[i]));
        }
        return arrayList;
    }
}

