/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.area.Area;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.PC;
import net.sf.hale.entity.Path;
import net.sf.hale.rules.Faction;
import net.sf.hale.util.LOSCone;
import net.sf.hale.util.PathFinder;
import net.sf.hale.util.Point;

public class AreaUtil {
    private final int width;
    private final int height;
    private boolean[][] transparent;
    private final Area area;
    private PathFinder.Data pathFindData;

    public AreaUtil(Area area) {
        this.area = area;
        boolean[][] blArray = area.getTransparency();
        this.width = blArray.length;
        this.height = blArray[0].length;
        this.transparent = new boolean[this.width][this.height];
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                this.transparent[i][j] = blArray[i][j];
            }
        }
        this.pathFindData = new PathFinder.Data(area);
    }

    public static List<Creature> getVisibleCreatures(Creature creature, Faction.Relationship relationship) {
        Faction faction = creature.getFaction();
        List<Creature> list = creature.getVisibleCreatures();
        Iterator<Creature> iterator = list.iterator();
        while (iterator.hasNext()) {
            Creature creature2 = iterator.next();
            Faction.Relationship relationship2 = faction.getRelationship(creature2.getFaction());
            if (relationship != null && relationship2 != relationship) {
                iterator.remove();
                continue;
            }
            if (!creature2.stats.isHidden()) continue;
            iterator.remove();
        }
        return list;
    }

    public static final void setMatrix(boolean[][] blArray, Point point, boolean bl) {
        AreaUtil.setMatrix(blArray, point.x, point.y, bl);
    }

    public static final void setMatrix(boolean[][] blArray, int n, int n2, boolean bl) {
        if (n < 0 || n >= blArray.length || n2 < 0 || n2 >= blArray[0].length) {
            return;
        }
        blArray[n][n2] = bl;
    }

    private static final void orMatrix(boolean[][] blArray, boolean[][] blArray2) {
        if (blArray.length != blArray2.length || blArray[0].length != blArray2[0].length) {
            return;
        }
        for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < blArray[i].length; ++j) {
                blArray2[i][j] = blArray[i][j] || blArray2[i][j];
            }
        }
    }

    public void updateVisibility() {
        this.updateTransparency(this.area.getTransparency());
        for (Creature creature : Game.curCampaign.party) {
            creature.computeVisibility();
        }
        this.setPartyVisibility();
    }

    public void setPartyVisibility() {
        boolean[][] blArray = this.area.getVisibility();
        boolean[][] blArray2 = this.area.getExplored();
        AreaUtil.setMatrix(blArray, false);
        for (Creature creature : Game.curCampaign.party) {
            if (!(creature instanceof PC)) continue;
            creature.addVisibilityToMatrix(blArray);
        }
        Game.timer.getTemporaryVisibilityAreas(blArray);
        AreaUtil.orMatrix(blArray, blArray2);
    }

    public void updateTransparency(boolean[][] blArray) {
        this.transparent = blArray;
    }

    public void setVisibilityWithRespectToPosition(boolean[][] blArray, Point point) {
        this.setVisibilityWithRespectToPosition(blArray, point.x, point.y);
    }

    public void setVisibilityWithRespectToPosition(boolean[][] blArray, int n, int n2) {
        AreaUtil.setMatrix(blArray, false);
        if (blArray.length != this.width || blArray[0].length != this.height) {
            return;
        }
        this.getVisibility(blArray, n, n2);
    }

    public static void setMatrix(boolean[][] blArray, boolean bl) {
        for (int i = 0; i < blArray.length; ++i) {
            for (int j = 0; j < blArray[0].length; ++j) {
                blArray[i][j] = bl;
            }
        }
    }

    private final boolean isValidCoordinates(Point point) {
        return point.x >= 0 && point.y >= 0 && point.x < this.width && point.y < this.height;
    }

    private boolean[][] getVisibility(boolean[][] blArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n >= blArray.length || n2 >= blArray[0].length) {
            return blArray;
        }
        byte by = this.area.getElevationGrid().getElevation(n, n2);
        blArray[n][n2] = true;
        LOSCone lOSCone = new LOSCone(0, new Point(36, 0), 1, new Point(72, 36));
        lOSCone.next = new LOSCone(2, new Point(72, 36), 3, new Point(36, 72));
        lOSCone.next.next = new LOSCone(3, new Point(36, 72), 4, new Point(0, 36));
        lOSCone.next.next.next = new LOSCone(5, new Point(0, 36), 6, new Point(36, 0));
        for (int i = 1; i <= this.area.getVisibilityRadius(); ++i) {
            LOSCone lOSCone2 = lOSCone;
            LOSCone lOSCone3 = lOSCone;
            boolean bl = false;
            while (lOSCone3 != null) {
                int n3 = 0;
                for (n3 = lOSCone3.getStartI(); n3 <= lOSCone3.getEndI(); ++n3) {
                    Point point = AreaUtil.convertPolarToGrid(n, n2, lOSCone3.getR(), n3);
                    byte by2 = 0;
                    if (this.isValidCoordinates(point)) {
                        blArray[point.x][point.y] = true;
                        by2 = this.area.getElevationGrid().getElevation(point.x, point.y);
                    }
                    if (this.isValidCoordinates(point) && this.transparent[point.x][point.y] && by2 <= by) continue;
                    if (lOSCone3.getStartI() == lOSCone3.getEndI()) {
                        bl = true;
                        continue;
                    }
                    if (lOSCone3.getStartI() == n3) {
                        lOSCone3.contractStartArm(n3);
                        continue;
                    }
                    if (lOSCone3.getEndI() == n3) {
                        lOSCone3.contractEndArm(n3);
                        continue;
                    }
                    LOSCone lOSCone4 = lOSCone3.split(n3);
                    lOSCone4.next = lOSCone3.next;
                    lOSCone3.next = lOSCone4;
                }
                if (bl) {
                    if (lOSCone3 == lOSCone) {
                        lOSCone = lOSCone3.next;
                        lOSCone3 = lOSCone3.next;
                        if (lOSCone3 != null) {
                            lOSCone2 = lOSCone3.next;
                        }
                    } else {
                        lOSCone2.next = lOSCone3.next;
                        lOSCone3 = lOSCone3.next;
                    }
                    bl = false;
                    continue;
                }
                lOSCone2 = lOSCone3;
                lOSCone3 = lOSCone3.next;
            }
            lOSCone3 = lOSCone;
            while (lOSCone3 != null) {
                lOSCone3.expand();
                lOSCone3 = lOSCone3.next;
            }
        }
        return blArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path findShortestPathIgnoreCreatures(Creature creature, Point point) {
        boolean[][] blArray = this.area.getEntities().getDoorPassabilities(creature);
        PathFinder.Data data = this.pathFindData;
        synchronized (data) {
            this.pathFindData.setEntityPassabilities(blArray);
            return PathFinder.findPathIgnoreCreatures(creature, point, this.pathFindData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path findShortestPathIgnoreParty(Creature creature, Point point, boolean[][] blArray) {
        PathFinder.Data data = this.pathFindData;
        synchronized (data) {
            this.pathFindData.setEntityPassabilities(blArray);
            return PathFinder.findPathIgnorePartyMembers(creature, point, this.pathFindData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path findShortestPath(Creature creature, Point point, int n) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        if (n == 0) {
            arrayList.add(point);
        } else {
            for (int i = 0; i < n * 6; ++i) {
                arrayList.add(AreaUtil.convertPolarToGrid(point, n, i));
            }
        }
        boolean[][] blArray = Game.curCampaign.curArea.getEntityPassabilities(creature);
        PathFinder.Data data = this.pathFindData;
        synchronized (data) {
            this.pathFindData.setEntityPassabilities(blArray);
            return PathFinder.findPath(creature, point, arrayList, this.pathFindData);
        }
    }

    public static Point[] getAdjacentTiles(Point point) {
        return AreaUtil.getAdjacentTiles(point.x, point.y);
    }

    public static Point[] getAdjacentTiles(int n, int n2) {
        Point[] pointArray = new Point[6];
        for (int i = 0; i < 6; ++i) {
            pointArray[i] = new Point();
        }
        pointArray[0].x = n;
        pointArray[0].y = n2 - 1;
        pointArray[1].x = n + 1;
        pointArray[1].y = n2 - (n + 1) % 2;
        pointArray[2].x = n + 1;
        pointArray[2].y = n2 + n % 2;
        pointArray[3].x = n;
        pointArray[3].y = n2 + 1;
        pointArray[4].x = n - 1;
        pointArray[4].y = n2 + n % 2;
        pointArray[5].x = n - 1;
        pointArray[5].y = n2 - (n + 1) % 2;
        return pointArray;
    }

    public static final Point convertGridToScreenAndCenter(int n, int n2) {
        Point point = AreaUtil.convertGridToScreen(n, n2);
        point.x += 36;
        point.y += 36;
        return point;
    }

    public static final Point convertGridToScreenAndCenter(Point point) {
        return AreaUtil.convertGridToScreenAndCenter(point.x, point.y);
    }

    public static final Point convertGridToScreen(Point point) {
        return AreaUtil.convertGridToScreen(point.x, point.y);
    }

    public static final Point convertGridToScreen(int n, int n2) {
        int n3 = n * 54;
        int n4 = n2 * 72;
        if (n % 2 == 1 || n % 2 == -1) {
            n4 += 36;
        }
        return new Point(n3, n4);
    }

    public static final Point convertScreenToGrid(Point point) {
        return AreaUtil.convertScreenToGrid(point.x, point.y);
    }

    public static final Point convertScreenToGrid(int n, int n2) {
        int n3 = n / 108 * 2;
        int n4 = n % 108;
        int n5 = n2 / 72;
        int n6 = n2 % 72;
        int n7 = 0;
        int n8 = 0;
        if (n6 < 36) {
            if (n4 * 2 + n6 < 36) {
                n7 = -1;
                n8 = -1;
            } else if (n4 * 2 - n6 < 108) {
                n7 = 0;
                n8 = 0;
            } else {
                n7 = 1;
                n8 = -1;
            }
        } else if (n4 * 2 - (n6 - 36) < 0) {
            n7 = -1;
            n8 = 0;
        } else if (n4 * 2 + (n6 - 36) < 144) {
            n7 = 0;
            n8 = 0;
        } else {
            n7 = 1;
            n8 = 0;
        }
        return new Point(n3 + n7, n5 + n8);
    }

    public static final Point convertPolarToGridCenter0(int n, int n2) {
        if (n == 0) {
            return new Point(0, 0);
        }
        if (n2 >= 6 * n) {
            n2 -= 6 * n;
        }
        int n3 = n2 / n;
        int n4 = n2 % n;
        int n5 = 0;
        int n6 = 0;
        if (n3 == 0) {
            n5 = 0;
            n6 = 0 - n;
            n6 += (n4 + Math.abs(n5 % 2)) / 2;
            n5 += n4;
        } else if (n3 == 1) {
            n5 = 0 + n;
            n6 = 0 - (n + 1) / 2;
            n6 += n4;
            n5 += 0;
        } else if (n3 == 2) {
            n5 = 0 + n;
            n6 = 0 + n / 2;
            n6 += (n4 + Math.abs(n5 % 2)) / 2;
            n5 -= n4;
        } else if (n3 == 3) {
            n5 = 0;
            n6 = 0 + n;
            n6 -= (n4 + 1 - Math.abs(n5 % 2)) / 2;
            n5 -= n4;
        } else if (n3 == 4) {
            n5 = 0 - n;
            n6 = 0 + n / 2;
            n6 -= n4;
            n5 += 0;
        } else if (n3 == 5) {
            n5 = 0 - n;
            n6 = 0 - (n + 1) / 2;
            n6 -= (n4 + 1 - Math.abs(n5 % 2)) / 2;
            n5 += n4;
        }
        return new Point(n5, n6);
    }

    public static final Point convertGridToPolar(Point point, Point point2) {
        return AreaUtil.convertGridToPolar(point.x, point.y, point2.x, point2.y);
    }

    public static final Point convertGridToPolar(int n, int n2, int n3, int n4) {
        int n5 = AreaUtil.distance(n, n2, n3, n4);
        int n6 = 0;
        n6 = n4 > n2 ? 3 * n5 : 0;
        Point point = AreaUtil.convertPolarToGrid(n, n2, n5, n6);
        int n7 = AreaUtil.distance(point.x, point.y, n3, n4);
        n6 = n3 > n ? (n4 > n2 ? (n6 -= n7) : (n6 += n7)) : (n4 > n2 ? (n6 += n7) : (n6 += 6 * n5 - n7));
        return new Point(n5, n6);
    }

    public static final Point convertPolarToGrid(Point point, int n, int n2) {
        return AreaUtil.convertPolarToGrid(point.x, point.y, n, n2);
    }

    public static final Point convertPolarToGrid(int n, int n2, int n3, int n4) {
        if (n3 == 0) {
            return new Point(n, n2);
        }
        if (n4 >= 6 * n3) {
            n4 -= 6 * n3;
        }
        int n5 = n4 / n3;
        int n6 = n4 % n3;
        int n7 = 0;
        int n8 = 0;
        if (n5 == 0) {
            n7 = n;
            n8 = n2 - n3;
            n8 += (n6 + Math.abs(n7 % 2)) / 2;
            n7 += n6;
        } else if (n5 == 1) {
            n7 = n + n3;
            n8 = n2 - (n3 + 1 - n % 2) / 2;
            n8 += n6;
            n7 += 0;
        } else if (n5 == 2) {
            n7 = n + n3;
            n8 = n2 + (n3 + n % 2) / 2;
            n8 += (n6 + Math.abs(n7 % 2)) / 2;
            n7 -= n6;
        } else if (n5 == 3) {
            n7 = n;
            n8 = n2 + n3;
            n8 -= (n6 + 1 - Math.abs(n7 % 2)) / 2;
            n7 -= n6;
        } else if (n5 == 4) {
            n7 = n - n3;
            n8 = n2 + (n3 + n % 2) / 2;
            n8 -= n6;
            n7 += 0;
        } else if (n5 == 5) {
            n7 = n - n3;
            n8 = n2 - (n3 + 1 - n % 2) / 2;
            n8 -= (n6 + 1 - Math.abs(n7 % 2)) / 2;
            n7 += n6;
        }
        return new Point(n7, n8);
    }

    public static ArrayList<Point> findIntersectingHexes(int n, int n2, int n3, int n4) {
        ArrayList<Point> arrayList = new ArrayList<Point>();
        Point point = AreaUtil.convertScreenToGrid(n, n2);
        Point point2 = AreaUtil.convertScreenToGrid(n3, n4);
        Point[] pointArray = AreaUtil.getAdjacentTiles(point2);
        Point point3 = new Point(-1, -1);
        int n5 = -1;
        for (int i = 0; i < 24 && !point3.equals(point2); ++i) {
            Point point4 = AreaUtil.convertGridToScreen(point);
            if ((n5 = AreaUtil.getLineIntersectSide(n5, point4.x, point4.y, n, n2, n3, n4)) == 0) {
                point3.x = point.x;
                point3.y = point.y - 1;
            } else if (n5 == 1) {
                point3.x = point.x + 1;
                point3.y = point.y - (point.x + 1) % 2;
            } else if (n5 == 2) {
                point3.x = point.x + 1;
                point3.y = point.y + point.x % 2;
            } else if (n5 == 3) {
                point3.x = point.x;
                point3.y = point.y + 1;
            } else if (n5 == 4) {
                point3.x = point.x - 1;
                point3.y = point.y + point.x % 2;
            } else if (n5 == 5) {
                point3.x = point.x - 1;
                point3.y = point.y - (point.x + 1) % 2;
            }
            arrayList.add(new Point(point3));
            if (AreaUtil.contains(pointArray, point3)) {
                arrayList.add(point2);
                break;
            }
            point.x = point3.x;
            point.y = point3.y;
        }
        return arrayList;
    }

    private static final boolean contains(Point[] pointArray, Point point) {
        for (Point point2 : pointArray) {
            if (point2.x != point.x || point2.y != point.y) continue;
            return true;
        }
        return false;
    }

    public static final Turn turns(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n3 - n) * (n6 - n2) - (n5 - n) * (n4 - n2);
        return n7 > 0 ? Turn.LEFT : (n7 == 0 ? Turn.STRAIGHT : Turn.RIGHT);
    }

    private static final int getLineIntersectSide(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        int[] nArray = new int[]{n2 + 18, n2 + 54, n2 + 72, n2 + 54, n2 + 18, n2, n2 + 18};
        int[] nArray2 = new int[]{n3, n3, n3 + 36, n3 + 72, n3 + 72, n3 + 36, n3};
        int n8 = (n + 3) % 6;
        if (n == -1) {
            n8 = -1;
        }
        int n9 = -1;
        double d = -100.0;
        for (int i = 0; i < 6; ++i) {
            double d2;
            if (i == n8) continue;
            double d3 = (n6 - n4) * (nArray2[i] - n5) - (n7 - n5) * (nArray[i] - n4);
            double d4 = (nArray[i + 1] - nArray[i]) * (nArray2[i] - n5) - (nArray2[i + 1] - nArray2[i]) * (nArray[i] - n4);
            double d5 = (n7 - n5) * (nArray[i + 1] - nArray[i]) - (n6 - n4) * (nArray2[i + 1] - nArray2[i]);
            double d6 = d3 / d5;
            double d7 = d4 / d5;
            if (!(d6 >= 0.0) || !(d6 < 1.0) || !(d7 >= 0.0) || !(d7 < 1.0) || !((d2 = d6 + d7) > d)) continue;
            n9 = i;
            d = d2;
        }
        return n9;
    }

    public static final boolean lineSegmentIntersectsHex(int n, int n2, int n3, int n4, int n5, int n6) {
        if (AreaUtil.turns(n, n2 + 36, n + 18, n2, n3, n4) == Turn.RIGHT && AreaUtil.turns(n, n2 + 36, n + 18, n2, n5, n6) == Turn.RIGHT) {
            return false;
        }
        if (AreaUtil.turns(n + 54, n2 + 72, n + 72, n2 + 36, n3, n4) == Turn.LEFT && AreaUtil.turns(n + 54, n2 + 72, n + 72, n2 + 36, n5, n6) == Turn.LEFT) {
            return false;
        }
        if (n2 > n4 && n2 > n6) {
            return false;
        }
        if (n2 + 72 < n4 && n2 + 72 < n6) {
            return false;
        }
        if (AreaUtil.turns(n + 18, n2 + 72, n, n2 + 36, n3, n4) == Turn.RIGHT && AreaUtil.turns(n + 18, n2 + 72, n, n2 + 36, n5, n6) == Turn.RIGHT) {
            return false;
        }
        if (AreaUtil.turns(n + 72, n2 + 36, n + 54, n2, n3, n4) == Turn.LEFT && AreaUtil.turns(n + 72, n2 + 36, n + 54, n2, n5, n6) == Turn.LEFT) {
            return false;
        }
        return AreaUtil.lineIntersectsHex(n, n2, n3, n4, n5, n6);
    }

    public static final boolean lineIntersectsHex(int n, int n2, int n3, int n4, int n5, int n6) {
        int[] nArray = new int[]{n + 18, n + 54, n + 72, n + 54, n + 18, n};
        int[] nArray2 = new int[]{n2, n2, n2 + 36, n2 + 72, n2 + 72, n2 + 36};
        Turn turn = AreaUtil.turns(n3, n4, n5, n6, nArray[0], nArray2[0]);
        if (turn == Turn.STRAIGHT) {
            return true;
        }
        for (int i = 1; i < 6; ++i) {
            Turn turn2 = AreaUtil.turns(n3, n4, n5, n6, nArray[i], nArray2[i]);
            if (turn2 != Turn.STRAIGHT && turn2 == turn) continue;
            return true;
        }
        return false;
    }

    public static final int distance(Point point, Point point2) {
        return AreaUtil.distance(point.x, point.y, point2.x, point2.y);
    }

    public static final int distance(int n, int n2, int n3, int n4) {
        int n5 = n2 - AreaUtil.Floor2(-n);
        int n6 = n2 + AreaUtil.Ceil2(-n);
        int n7 = n4 - AreaUtil.Floor2(-n3);
        int n8 = n4 + AreaUtil.Ceil2(-n3);
        int n9 = n7 - n5;
        int n10 = n8 - n6;
        return (Math.abs(n9) + Math.abs(n10) + Math.abs(n9 - n10)) / 2;
    }

    public static final int euclideanDistance2(int n, int n2, int n3, int n4) {
        return (n3 - n) * (n3 - n) + (n4 - n2) * (n4 - n2);
    }

    public static final int Floor2(int n) {
        return n >= 0 ? n >> 1 : (n - 1) / 2;
    }

    public static final int Ceil2(int n) {
        return n >= 0 ? n + 1 >> 1 : n / 2;
    }

    public static final double angle(int n, int n2, int n3, int n4) {
        double d = n3 - n;
        double d2 = n4 - n2;
        if (d2 > 0.0) {
            return Math.atan(d / d2);
        }
        if (d2 == 0.0) {
            if (d > 0.0) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        return Math.PI + Math.atan(d / d2);
    }

    public static enum Turn {
        LEFT,
        RIGHT,
        STRAIGHT;

    }
}

