/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.hale.tileset.BorderList;
import net.sf.hale.tileset.ElevationList;
import net.sf.hale.tileset.FeatureType;
import net.sf.hale.tileset.Layer;
import net.sf.hale.tileset.TerrainType;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Tileset {
    private final String id;
    private final String name;
    private final String directory;
    private final Map<String, Layer> layers;
    private final String entityLayerID;
    private final String interfaceLayerID;
    private final Map<String, TerrainType> terrainTypes;
    private final Map<String, FeatureType> featureTypes;
    private final Map<String, BorderList> borderLists;
    private final int defaultVisibilityRadius;
    private final String defaultTerrainType;
    private final ElevationList elevationList;

    public Tileset(String string, String string2) {
        Object object;
        Object object422;
        this.id = string;
        this.layers = new LinkedHashMap<String, Layer>();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string2);
        simpleJSONParser.setWarnOnMissingKeys(true);
        this.name = simpleJSONParser.get("name", string);
        this.directory = simpleJSONParser.get("directory", null);
        this.entityLayerID = simpleJSONParser.get("entityLayer", null);
        this.interfaceLayerID = simpleJSONParser.get("interfaceLayer", null);
        simpleJSONParser.setWarnOnMissingKeys(false);
        this.defaultVisibilityRadius = simpleJSONParser.get("defaultVisibilityRadius", 10);
        this.defaultTerrainType = simpleJSONParser.get("defaultTerrainType", null);
        SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("elevation");
        this.elevationList = simpleJSONArray != null ? ElevationList.parse(simpleJSONArray) : null;
        simpleJSONParser.setWarnOnMissingKeys(true);
        for (Object object422 : simpleJSONParser.getArray("layers")) {
            SimpleJSONObject object32 = ((SimpleJSONArrayEntry)object422).getObject();
            ArrayList<String> arrayList = new ArrayList<String>();
            String string3 = object32.get("id", null);
            for (Object object2 : object32.getArray("spriteSheets")) {
                String string4 = ((SimpleJSONArrayEntry)object2).getString();
                arrayList.add(string4);
            }
            this.layers.put(string3, new Layer(string3, this.directory, arrayList));
        }
        this.featureTypes = new HashMap<String, FeatureType>();
        SimpleJSONObject simpleJSONObject = simpleJSONParser.getObject("features");
        for (String string5 : simpleJSONObject.keySet()) {
            SimpleJSONObject simpleJSONObject2 = simpleJSONObject.getObject(string5);
            FeatureType featureType = FeatureType.parse(simpleJSONObject2, string5);
            this.featureTypes.put(string5, featureType);
        }
        this.terrainTypes = new HashMap<String, TerrainType>();
        object422 = simpleJSONParser.getObject("terrain");
        for (String string6 : ((SimpleJSONObject)object422).keySet()) {
            SimpleJSONObject simpleJSONObject3 = ((SimpleJSONObject)object422).getObject(string6);
            object = TerrainType.parse(simpleJSONObject3, string6);
            this.terrainTypes.put(string6, (TerrainType)object);
        }
        this.borderLists = new HashMap<String, BorderList>();
        SimpleJSONObject simpleJSONObject4 = simpleJSONParser.getObject("borders");
        for (String string7 : simpleJSONObject4.keySet()) {
            Object object2;
            object = simpleJSONObject4.getArray(string7);
            object2 = BorderList.parse((SimpleJSONArray)object, string7);
            this.borderLists.put(string7, (BorderList)object2);
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    public void loadTiles() {
        for (String string : this.layers.keySet()) {
            this.layers.get(string).loadTiles();
        }
    }

    public void freeTiles() {
        for (String string : this.layers.keySet()) {
            this.layers.get(string).freeTiles();
        }
    }

    public Set<String> getLayerIDs() {
        return Collections.unmodifiableSet(this.layers.keySet());
    }

    public Set<String> getTerrainTypeIDs() {
        return Collections.unmodifiableSet(this.terrainTypes.keySet());
    }

    public Set<String> getFeatureTypeIDs() {
        return Collections.unmodifiableSet(this.featureTypes.keySet());
    }

    public ElevationList getElevationList() {
        return this.elevationList;
    }

    public Set<BorderList> getMatchingBorderLists(TerrainType[][] terrainTypeArray, Point point) {
        Point[] pointArray;
        HashSet<BorderList> hashSet = new HashSet<BorderList>();
        TerrainType terrainType = terrainTypeArray[point.x][point.y];
        if (terrainType == null) {
            return hashSet;
        }
        for (Point point2 : pointArray = AreaUtil.getAdjacentTiles(point)) {
            String string;
            if (point2.x < 0 || point2.x >= terrainTypeArray.length || point2.y < 0 || point2.y >= terrainTypeArray[0].length || terrainTypeArray[point2.x][point2.y] == null || (string = terrainType.getBorderIDWith(terrainTypeArray[point2.x][point2.y])) == null) continue;
            hashSet.add(this.borderLists.get(string));
        }
        return hashSet;
    }

    public FeatureType getFeatureType(String string) {
        return this.featureTypes.get(string);
    }

    public TerrainType getTerrainType(String string) {
        return this.terrainTypes.get(string);
    }

    public Layer getLayer(String string) {
        return this.layers.get(string);
    }

    public String getInterfaceLayerID() {
        return this.interfaceLayerID;
    }

    public String getEntityLayerID() {
        return this.entityLayerID;
    }

    public int getDefaultVisibilityRadius() {
        return this.defaultVisibilityRadius;
    }

    public String getDefaultTerrainType() {
        return this.defaultTerrainType;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }
}

