/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sf.hale.area.Area;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Door;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.Trap;
import net.sf.hale.tileset.AreaTileGrid;
import net.sf.hale.tileset.Tile;
import net.sf.hale.util.Point;
import org.lwjgl.opengl.GL11;

public class TileLayerList {
    private TileList[][] tiles;
    private String layerID;
    private boolean[][] explored;
    private boolean[][] visibility;
    private Area area;

    public TileLayerList(String string, int n, int n2) {
        this.layerID = string;
        this.tiles = new TileList[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.tiles[j][i] = new TileList();
            }
        }
    }

    public void resize(int n, int n2) {
        int n3;
        int n4;
        if (n == this.tiles.length && n2 == this.tiles[0].length) {
            return;
        }
        TileList[][] tileListArray = new TileList[n][n2];
        int n5 = Math.min(tileListArray.length, this.tiles.length);
        int n6 = Math.min(tileListArray[0].length, this.tiles[0].length);
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 < n6; ++n3) {
                tileListArray[n4][n3] = this.tiles[n4][n3];
            }
        }
        for (n4 = 0; n4 < n; ++n4) {
            for (n3 = 0; n3 < n2; ++n3) {
                if (tileListArray[n4][n3] != null) continue;
                tileListArray[n4][n3] = new TileList();
            }
        }
        this.tiles = tileListArray;
    }

    public List<Tile> getTilesAt(int n, int n2) {
        return Collections.unmodifiableList(this.tiles[n][n2]);
    }

    protected void write(BufferedWriter bufferedWriter) throws IOException {
        for (int i = this.tiles[0].length - 1; i >= 0; --i) {
            for (int j = this.tiles.length - 1; j >= 0; --j) {
                this.tiles[j][i].write(bufferedWriter, j, i);
            }
        }
    }

    protected void cacheSprites() {
        for (int i = this.tiles[0].length - 1; i >= 0; --i) {
            for (int j = this.tiles.length - 1; j >= 0; --j) {
                this.tiles[j][i].cacheSprites();
            }
        }
    }

    protected void addTile(String string, String string2, int n, int n2) {
        this.tiles[n][n2].add(new Tile(string, string2));
    }

    protected void addTile(Tile tile, int n, int n2) {
        for (Tile tile2 : this.tiles[n][n2]) {
            if (!tile2.getTileID().equals(tile.getTileID())) continue;
            return;
        }
        this.tiles[n][n2].add(tile);
    }

    protected void removeTilesExceptMatching(Set<String> set, int n, int n2) {
        Iterator iterator = this.tiles[n][n2].iterator();
        while (iterator.hasNext()) {
            if (set.contains(((Tile)iterator.next()).getSpriteID())) continue;
            iterator.remove();
        }
    }

    protected void removeTilesMatching(Set<String> set, int n, int n2) {
        Iterator iterator = this.tiles[n][n2].iterator();
        while (iterator.hasNext()) {
            if (!set.contains(((Tile)iterator.next()).getSpriteID())) continue;
            iterator.remove();
        }
    }

    protected void removeTiles(int n, int n2) {
        this.tiles[n][n2].clear();
    }

    protected void draw(Point[][] pointArray, Point point, Point point2) {
        for (int i = point.y; i <= point2.y; ++i) {
            int n;
            for (n = point.x; n <= point2.x; n += 2) {
                this.draw(n, i, pointArray[n][i].x, pointArray[n][i].y);
            }
            for (n = point.x + 1; n <= point2.x; n += 2) {
                this.draw(n, i, pointArray[n][i].x, pointArray[n][i].y);
            }
        }
    }

    private final void drawEntityTile(int n, int n2, Point point) {
        this.draw(n, n2, point.x, point.y);
        if (!this.explored[n][n2]) {
            return;
        }
        Collection<Entity> collection = this.area.getEntities().getEntitiesSet(n, n2);
        if (collection == null) {
            return;
        }
        for (Entity entity : collection) {
            if (!this.visibility[n][n2] && (entity instanceof Door || !entity.isPlayerFaction() && entity instanceof Creature) || entity instanceof Trap && !((Trap)entity).isSpotted()) continue;
            entity.areaDraw(point.x, point.y);
        }
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected void draw(Point[][] pointArray, AreaTileGrid.AreaRenderer areaRenderer, Point point, Point point2) {
        this.area = areaRenderer.getArea();
        this.visibility = this.area.getVisibility();
        this.explored = this.area.getExplored();
        for (int i = point.y; i <= point2.y; ++i) {
            int n;
            for (n = point.x; n <= point2.x; n += 2) {
                this.drawEntityTile(n, i, pointArray[n][i]);
            }
            for (n = point.x + 1; n <= point2.x; n += 2) {
                this.drawEntityTile(n, i, pointArray[n][i]);
            }
        }
    }

    private final void draw(int n, int n2, int n3, int n4) {
        for (Tile tile : this.tiles[n][n2]) {
            tile.draw(n3, n4);
        }
    }

    private class TileList
    extends ArrayList<Tile> {
        private static final long serialVersionUID = 1L;

        private TileList() {
            super(1);
        }

        private void cacheSprites() {
            for (Tile tile : this) {
                tile.cacheSprite();
            }
        }

        private void write(BufferedWriter bufferedWriter, int n, int n2) throws IOException {
            for (Tile tile : this) {
                bufferedWriter.write("tile ");
                bufferedWriter.write(TileLayerList.this.layerID);
                bufferedWriter.write(" ");
                bufferedWriter.write(Integer.toString(n));
                bufferedWriter.write(" ");
                bufferedWriter.write(Integer.toString(n2));
                bufferedWriter.write(" ");
                bufferedWriter.write(tile.getTileID());
                bufferedWriter.newLine();
            }
        }
    }
}

