/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;

public class Layer {
    private String id;
    private String directory;
    private List<String> spriteSheets;
    private List<String> textureSprites;
    private Set<String> tiles;

    protected Layer(String string, String string2, List<String> list) {
        this.id = string;
        this.directory = string2;
        this.spriteSheets = list;
        this.tiles = new LinkedHashSet<String>();
        this.textureSprites = new ArrayList<String>();
    }

    public String getSpriteID(String string) {
        return this.directory + "/" + string + ResourceType.PNG.getExtension();
    }

    protected void loadTiles() {
        this.tiles.clear();
        for (String string : this.spriteSheets) {
            List<String> list = SpriteManager.readSpriteSheet(this.directory + "/" + string + ResourceType.JSON.getExtension());
            Iterator<String> iterator = list.iterator();
            if (!iterator.hasNext()) continue;
            String string2 = iterator.next();
            String string3 = this.directory + "/" + string2 + ResourceType.PNG.getExtension();
            this.textureSprites.add(string3);
            this.tiles.add(string2);
            while (iterator.hasNext()) {
                string2 = iterator.next();
                this.tiles.add(string2);
            }
        }
    }

    public Set<String> getTiles() {
        return Collections.unmodifiableSet(this.tiles);
    }

    protected void freeTiles() {
        for (String string : this.textureSprites) {
            Sprite sprite = SpriteManager.getImage(string);
            SpriteManager.freeTexture(sprite);
        }
        this.textureSprites.clear();
        this.tiles.clear();
    }

    public String getID() {
        return this.id;
    }
}

