/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.hale.tileset.AbstractTerrainType;
import net.sf.hale.tileset.TerrainTile;
import net.sf.hale.tileset.TerrainType;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class FeatureType
extends AbstractTerrainType {
    private final Set<String> terrainTypeIDs = new HashSet<String>();

    private FeatureType(String string, boolean bl, boolean bl2, TerrainTile terrainTile, List<TerrainTile> list) {
        super(string, bl, bl2, terrainTile, list);
    }

    public boolean canBeAddedTo(TerrainType terrainType) {
        if (terrainType == null) {
            return false;
        }
        return this.terrainTypeIDs.contains(terrainType.getID());
    }

    public static FeatureType parse(SimpleJSONObject simpleJSONObject, String string) {
        List<TerrainTile> list = AbstractTerrainType.parseTiles(simpleJSONObject);
        TerrainTile terrainTile = AbstractTerrainType.parsePreviewTile(simpleJSONObject);
        if (terrainTile == null) {
            terrainTile = list.get(0);
        }
        simpleJSONObject.setWarnOnMissingKeys(false);
        boolean bl = simpleJSONObject.get("passable", false);
        boolean bl2 = simpleJSONObject.get("transparent", true);
        simpleJSONObject.setWarnOnMissingKeys(true);
        FeatureType featureType = new FeatureType(string, bl2, bl, terrainTile, list);
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("terrainTypes")) {
            featureType.terrainTypeIDs.add(simpleJSONArrayEntry.getString());
        }
        return featureType;
    }
}

