/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.hale.tileset.AreaElevationGrid;
import net.sf.hale.tileset.Border;
import net.sf.hale.tileset.DirectionList;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class ElevationList {
    private List<Elevation> elevation;

    private ElevationList() {
    }

    public static ElevationList parse(SimpleJSONArray simpleJSONArray) {
        ElevationList elevationList = new ElevationList();
        ArrayList<Elevation> arrayList = new ArrayList<Elevation>();
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            arrayList.add(new Elevation(simpleJSONObject));
        }
        arrayList.trimToSize();
        elevationList.elevation = Collections.unmodifiableList(arrayList);
        return elevationList;
    }

    public List<Elevation> getElevationRules() {
        return this.elevation;
    }

    public List<Elevation> getMatchingElevationRules(AreaElevationGrid areaElevationGrid, Point point) {
        ArrayList<Elevation> arrayList = new ArrayList<Elevation>();
        for (Elevation elevation : this.elevation) {
            if (!elevation.isMetAtPoint(areaElevationGrid, point)) continue;
            arrayList.add(elevation);
        }
        return arrayList;
    }

    public static class Elevation {
        private final Border border;
        private final DirectionList impassable;

        public DirectionList getImpassable() {
            return this.impassable;
        }

        public Border getBorder() {
            return this.border;
        }

        private Elevation(SimpleJSONObject simpleJSONObject) {
            this.border = Border.parse(simpleJSONObject, "elevation");
            this.impassable = simpleJSONObject.containsKey("impassable") ? DirectionList.parse(simpleJSONObject.get("impassable", null)) : null;
        }

        private boolean isMetAtPoint(AreaElevationGrid areaElevationGrid, Point point) {
            Point point2;
            byte by = areaElevationGrid.getElevation(point.x, point.y);
            int n = areaElevationGrid.getWidth();
            int n2 = areaElevationGrid.getHeight();
            for (DirectionList directionList : this.border.getMustHave()) {
                point2 = directionList.getRelativePoint(point);
                if (point2.x < 0 || point2.x >= n || point2.y < 0 || point2.y >= n2) {
                    return false;
                }
                if (by < areaElevationGrid.getElevation(point2.x, point2.y)) continue;
                return false;
            }
            for (DirectionList directionList : this.border.getMustNotHave()) {
                point2 = directionList.getRelativePoint(point);
                if (point2.x < 0 || point2.x >= n || point2.y < 0 || point2.y >= n2) {
                    return false;
                }
                if (by == areaElevationGrid.getElevation(point2.x, point2.y)) continue;
                return false;
            }
            return true;
        }
    }
}

