/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.tileset.Direction;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;
import net.sf.hale.util.StringParser;

public class DirectionList
implements Iterable<Direction> {
    private List<Direction> directions;

    @Override
    public Iterator<Direction> iterator() {
        return this.directions.iterator();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Direction direction : this.directions) {
            stringBuilder.append(direction.toString());
        }
        return stringBuilder.toString();
    }

    public Point getRelativePoint(Point point) {
        Point point2 = point;
        Point[] pointArray = AreaUtil.getAdjacentTiles(point);
        for (Direction direction : this.directions) {
            switch (direction) {
                case North: {
                    point2 = pointArray[0];
                    break;
                }
                case NorthEast: {
                    point2 = pointArray[1];
                    break;
                }
                case SouthEast: {
                    point2 = pointArray[2];
                    break;
                }
                case South: {
                    point2 = pointArray[3];
                    break;
                }
                case SouthWest: {
                    point2 = pointArray[4];
                    break;
                }
                case NorthWest: {
                    point2 = pointArray[5];
                    break;
                }
            }
            pointArray = AreaUtil.getAdjacentTiles(point2);
        }
        return point2;
    }

    public static DirectionList parse(String string) {
        DirectionList directionList = new DirectionList();
        ArrayList<Direction> arrayList = new ArrayList<Direction>();
        StringParser stringParser = new StringParser(string);
        stringParser.whitespaceChars(45, 45);
        try {
            while (stringParser.hasNext()) {
                arrayList.add(Direction.valueOf(stringParser.next()));
            }
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error parsing direction list from " + string, exception);
        }
        arrayList.trimToSize();
        directionList.directions = Collections.unmodifiableList(arrayList);
        return directionList;
    }
}

