/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.tileset.Border;
import net.sf.hale.tileset.TerrainType;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class BorderList
implements Iterable<Border> {
    private String id;
    private List<Border> borders;

    private BorderList(String string) {
        this.id = string;
    }

    public String getID() {
        return this.id;
    }

    @Override
    public Iterator<Border> iterator() {
        return this.borders.iterator();
    }

    public List<Border> getMatchingBorders(TerrainType[][] terrainTypeArray, Point point) {
        ArrayList<Border> arrayList = new ArrayList<Border>();
        for (Border border : this.borders) {
            if (!border.isMetAtPoint(terrainTypeArray, point)) continue;
            arrayList.add(border);
        }
        return arrayList;
    }

    public static BorderList parse(SimpleJSONArray simpleJSONArray, String string) {
        BorderList borderList = new BorderList(string);
        ArrayList<Border> arrayList = new ArrayList<Border>();
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            arrayList.add(Border.parse(simpleJSONObject, string));
        }
        arrayList.trimToSize();
        borderList.borders = Collections.unmodifiableList(arrayList);
        return borderList;
    }
}

