/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.tileset.BorderTile;
import net.sf.hale.tileset.DirectionList;
import net.sf.hale.tileset.TerrainType;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class Border
implements Iterable<BorderTile> {
    private String borderListID;
    private List<DirectionList> mustHave;
    private List<DirectionList> mustNotHave;
    private List<BorderTile> tiles;

    protected Border(String string, List<DirectionList> list, List<DirectionList> list2, List<BorderTile> list3) {
        this.borderListID = string;
        this.mustHave = list;
        this.mustNotHave = list2;
        this.tiles = list3;
    }

    public List<DirectionList> getMustHave() {
        return this.mustHave;
    }

    public List<DirectionList> getMustNotHave() {
        return this.mustNotHave;
    }

    @Override
    public Iterator<BorderTile> iterator() {
        return this.tiles.iterator();
    }

    protected boolean isMetAtPoint(TerrainType[][] terrainTypeArray, Point point) {
        Point point2;
        TerrainType terrainType = terrainTypeArray[point.x][point.y];
        for (DirectionList directionList : this.mustHave) {
            point2 = directionList.getRelativePoint(point);
            if (point2.x < 0 || point2.x >= terrainTypeArray.length || point2.y < 0 || point2.y >= terrainTypeArray[0].length) {
                return false;
            }
            String string = terrainType.getBorderIDWith(terrainTypeArray[point2.x][point2.y]);
            if (this.borderListID.equals(string)) continue;
            return false;
        }
        for (DirectionList directionList : this.mustNotHave) {
            point2 = directionList.getRelativePoint(point);
            if (point2.x < 0 || point2.x >= terrainTypeArray.length || point2.y < 0 || point2.y >= terrainTypeArray[0].length) {
                return false;
            }
            if (terrainTypeArray[point2.x][point2.y] == terrainType) continue;
            return false;
        }
        return true;
    }

    public static Border parse(SimpleJSONObject simpleJSONObject, String string) {
        Object object2;
        ArrayList<DirectionList> arrayList3;
        ArrayList<BorderTile> arrayList2 = new ArrayList<BorderTile>();
        for (ArrayList<DirectionList> arrayList3 : simpleJSONObject.getArray("tiles")) {
            arrayList2.add(BorderTile.parse(((SimpleJSONArrayEntry)((Object)arrayList3)).getObject()));
        }
        arrayList2.trimToSize();
        simpleJSONObject.setWarnOnMissingKeys(false);
        ArrayList arrayList4 = new ArrayList();
        for (Object object2 : simpleJSONObject.getArray("MustHave")) {
            arrayList4.add(DirectionList.parse(((SimpleJSONArrayEntry)object2).getString()));
        }
        arrayList4.trimToSize();
        arrayList3 = new ArrayList<DirectionList>();
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("MustNotHave")) {
            arrayList3.add(DirectionList.parse(simpleJSONArrayEntry.getString()));
        }
        arrayList3.trimToSize();
        simpleJSONObject.setWarnOnMissingKeys(true);
        object2 = new Border(string, Collections.unmodifiableList(arrayList4), Collections.unmodifiableList(arrayList3), Collections.unmodifiableList(arrayList2));
        return object2;
    }
}

