/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import de.matthiasmann.twl.AnimationState;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.area.Area;
import net.sf.hale.tileset.Tile;
import net.sf.hale.tileset.TileLayerList;
import net.sf.hale.tileset.Tileset;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class AreaTileGrid {
    private Tileset tileset;
    private Map<String, TileLayerList> tiles;
    private Point[][] screenCoordinates;

    public AreaTileGrid(Tileset tileset, int n, int n2) {
        this.tileset = tileset;
        this.tiles = new LinkedHashMap<String, TileLayerList>();
        for (String string : tileset.getLayerIDs()) {
            this.tiles.put(string, new TileLayerList(string, n, n2));
        }
        this.screenCoordinates = new Point[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.screenCoordinates[j][i] = AreaUtil.convertGridToScreen(j, i);
            }
        }
    }

    public void resize(int n, int n2) {
        for (String string : this.tiles.keySet()) {
            this.tiles.get(string).resize(n, n2);
        }
        this.screenCoordinates = new Point[n][n2];
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.screenCoordinates[j][i] = AreaUtil.convertGridToScreen(j, i);
            }
        }
    }

    public void write(BufferedWriter bufferedWriter) throws IOException {
        for (String string : this.tileset.getLayerIDs()) {
            this.tiles.get(string).write(bufferedWriter);
        }
    }

    public TileLayerList getLayer(String string) {
        return this.tiles.get(string);
    }

    public Set<String> getLayerIDs() {
        return Collections.unmodifiableSet(this.tiles.keySet());
    }

    public void cacheSprites() {
        for (String string : this.tileset.getLayerIDs()) {
            this.tiles.get(string).cacheSprites();
        }
    }

    public void removeTilesMatching(Set<String> set, int n, int n2) {
        for (String string : this.tileset.getLayerIDs()) {
            this.tiles.get(string).removeTilesMatching(set, n, n2);
        }
    }

    public void removeTilesExceptMatching(Set<String> set, int n, int n2) {
        for (String string : this.tileset.getLayerIDs()) {
            this.tiles.get(string).removeTilesExceptMatching(set, n, n2);
        }
    }

    public void removeAllTiles(int n, int n2) {
        for (String string : this.tileset.getLayerIDs()) {
            this.tiles.get(string).removeTiles(n, n2);
        }
    }

    public void removeTilesInLayer(String string, int n, int n2) {
        this.tiles.get(string).removeTiles(n, n2);
    }

    public void addTile(String string, String string2, int n, int n2) {
        TileLayerList tileLayerList = this.tiles.get(string2);
        tileLayerList.addTile(string, this.tileset.getLayer(string2).getSpriteID(string), n, n2);
    }

    public void addTile(Tile tile, String string, int n, int n2) {
        TileLayerList tileLayerList = this.tiles.get(string);
        tileLayerList.addTile(tile, n, n2);
    }

    public void draw(AreaRenderer areaRenderer) {
        this.draw(areaRenderer, null, null, null);
    }

    public void draw(AreaRenderer areaRenderer, AnimationState animationState, Point point, Point point2) {
        String string = this.tileset.getEntityLayerID();
        String string2 = this.tileset.getInterfaceLayerID();
        if (point == null) {
            point = new Point(0, 0);
        }
        if (point2 == null) {
            point2 = new Point(this.screenCoordinates.length - 1, this.screenCoordinates[0].length - 1);
        }
        for (String string3 : this.tileset.getLayerIDs()) {
            if (string3.equals(string)) {
                if (Game.particleManager != null) {
                    Game.particleManager.drawBelowEntities();
                }
                areaRenderer.drawTransitions();
                this.tiles.get(string3).draw(this.screenCoordinates, areaRenderer, point, point2);
                if (Game.particleManager == null) continue;
                Game.particleManager.drawAboveEntities();
                continue;
            }
            if (string3.equals(string2)) {
                this.tiles.get(string3).draw(this.screenCoordinates, point, point2);
                areaRenderer.drawInterface(animationState);
                continue;
            }
            this.tiles.get(string3).draw(this.screenCoordinates, point, point2);
        }
    }

    public static interface AreaRenderer {
        public Area getArea();

        public void drawTransitions();

        public void drawInterface(AnimationState var1);
    }
}

