/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.io.BufferedWriter;
import java.io.IOException;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class AreaElevationGrid {
    private static byte MaxElevation = (byte)9;
    private static byte MinElevation = (byte)-9;
    private byte[][] elevation;

    public AreaElevationGrid(int n, int n2) {
        this.elevation = new byte[n][n2];
    }

    public void resize(int n, int n2) {
        byte[][] byArray = new byte[n][n2];
        int n3 = Math.min(n, this.elevation.length);
        int n4 = Math.min(n2, this.elevation[0].length);
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                byArray[i][j] = this.elevation[i][j];
            }
        }
        this.elevation = byArray;
    }

    public int getWidth() {
        return this.elevation.length;
    }

    public int getHeight() {
        return this.elevation[0].length;
    }

    public void modifyElevation(int n, int n2, byte by) {
        if (by == 0) {
            return;
        }
        this.elevation[n][n2] = (byte)(this.elevation[n][n2] + by);
        byte by2 = MinElevation;
        byte by3 = MaxElevation;
        for (Point point : AreaUtil.getAdjacentTiles(n, n2)) {
            if (point.x < 0 || point.y < 0 || point.x >= this.elevation.length || point.y >= this.elevation[0].length) continue;
            byte by4 = this.elevation[point.x][point.y];
            by2 = (byte)Math.max(by2, by4 - 1);
            by3 = (byte)Math.min(by3, by4 + 1);
        }
        if (this.elevation[n][n2] > by3) {
            this.elevation[n][n2] = by3;
        } else if (this.elevation[n][n2] < by2) {
            this.elevation[n][n2] = by2;
        }
    }

    public void setElevation(int n, int n2, byte by) {
        this.elevation[n][n2] = by;
        if (this.elevation[n][n2] > MaxElevation) {
            this.elevation[n][n2] = MaxElevation;
        } else if (this.elevation[n][n2] < MinElevation) {
            this.elevation[n][n2] = MinElevation;
        }
    }

    public byte getElevation(int n, int n2) {
        return this.elevation[n][n2];
    }

    public void write(BufferedWriter bufferedWriter) throws IOException {
        for (int i = 0; i < this.elevation[0].length; ++i) {
            bufferedWriter.write("elevation ");
            bufferedWriter.write(Integer.toString(i));
            bufferedWriter.write(" ");
            for (int j = 0; j < this.elevation.length; ++j) {
                bufferedWriter.write(Byte.toString(this.elevation[j][i]));
                bufferedWriter.write(" ");
            }
            bufferedWriter.newLine();
        }
    }
}

