/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.tileset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.tileset.TerrainTile;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public abstract class AbstractTerrainType
implements Iterable<TerrainTile> {
    private final String id;
    private final boolean transparent;
    private final boolean passable;
    private final List<TerrainTile> tiles;
    private final TerrainTile previewTile;
    private final int totalProbability;

    public AbstractTerrainType(String string, boolean bl, boolean bl2, TerrainTile terrainTile, List<TerrainTile> list) {
        this.id = string;
        this.transparent = bl;
        this.passable = bl2;
        this.previewTile = terrainTile;
        this.tiles = Collections.unmodifiableList(list);
        int n = 0;
        for (TerrainTile terrainTile2 : list) {
            n += terrainTile2.getProbability();
        }
        this.totalProbability = n;
    }

    public String getID() {
        return this.id;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public boolean isPassable() {
        return this.passable;
    }

    public TerrainTile getPreviewTile() {
        return this.previewTile;
    }

    public boolean containsTileWithID(String string) {
        for (TerrainTile terrainTile : this.tiles) {
            if (!terrainTile.getID().equals(string)) continue;
            return true;
        }
        return false;
    }

    public TerrainTile getRandomTerrainTile() {
        int n = Game.dice.rand(1, this.totalProbability);
        int n2 = 0;
        for (TerrainTile terrainTile : this.tiles) {
            if (n > (n2 += terrainTile.getProbability())) continue;
            return terrainTile;
        }
        return null;
    }

    @Override
    public Iterator<TerrainTile> iterator() {
        return this.tiles.iterator();
    }

    public static List<TerrainTile> parseTiles(SimpleJSONObject simpleJSONObject) {
        ArrayList<TerrainTile> arrayList = new ArrayList<TerrainTile>();
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("tiles")) {
            SimpleJSONObject simpleJSONObject2 = simpleJSONArrayEntry.getObject();
            TerrainTile terrainTile = new TerrainTile(simpleJSONObject2.get("id", null), simpleJSONObject2.get("layer", null), simpleJSONObject2.get("probability", 0));
            arrayList.add(terrainTile);
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public static TerrainTile parsePreviewTile(SimpleJSONObject simpleJSONObject) {
        if (!simpleJSONObject.containsKey("previewTile")) {
            return null;
        }
        SimpleJSONObject simpleJSONObject2 = simpleJSONObject.getObject("previewTile");
        return new TerrainTile(simpleJSONObject2.get("id", null), simpleJSONObject2.get("layer", null), 0);
    }
}

