/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import net.sf.hale.Game;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.PC;

public class XP {
    public static int MAX_LEVEL = 100;
    private static int[] pointsForLevel;

    public static void initXPTable() {
        int n = Game.ruleset.getValue("XPLevelMultFactor");
        int n2 = Game.ruleset.getValue("XPLevelExpBaseInv");
        double d = 1.0 + 1.0 / (double)n2;
        pointsForLevel = new int[MAX_LEVEL + 2];
        XP.pointsForLevel[0] = 0;
        XP.pointsForLevel[1] = 0;
        double d2 = 0.0;
        for (int i = 1; i <= MAX_LEVEL; ++i) {
            XP.pointsForLevel[i + 1] = (int)(((d2 += (double)(i * n) * Math.pow(d, i)) + 50.0) / 100.0) * 100;
        }
    }

    public static int getPointsForLevel(int n) {
        return pointsForLevel[n];
    }

    public static void addPartyXP(int n) {
        XP.rewardXP(n);
        Game.mainViewer.addMessage("green", "The party has earned " + n + " experience points.");
    }

    private static void rewardXP(int n) {
        int n2 = 0;
        for (Object object : Game.curCampaign.party) {
            if (((Creature)object).isDead() || ((Creature)object).isSummoned()) continue;
            ++n2;
        }
        int n3 = n / n2;
        for (PC pC : Game.curCampaign.party) {
            if (pC.isDead() || pC.isSummoned()) continue;
            pC.addExperiencePoints(n3);
        }
    }
}

