/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.SimpleJSONObject;

public class WorldMapLocation
implements Saveable {
    private final Map<String, Integer> travelTimesInHours;
    private final int iconX;
    private final int iconY;
    private final String name;
    private final Icon icon;
    private final String startingTransition;
    private boolean revealed;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("name", this.name);
        jSONOrderedObject.put("revealed", this.revealed);
        return jSONOrderedObject;
    }

    public WorldMapLocation(SimpleJSONObject simpleJSONObject) {
        SimpleJSONObject simpleJSONObject2;
        this.name = simpleJSONObject.get("id", null);
        this.startingTransition = simpleJSONObject.containsKey("startingTransition") ? simpleJSONObject.get("startingTransition", null) : null;
        this.icon = simpleJSONObject.containsKey("icon") ? IconFactory.createIcon(simpleJSONObject.getObject("icon")) : IconFactory.emptyIcon;
        if (simpleJSONObject.containsKey("iconPosition")) {
            simpleJSONObject2 = simpleJSONObject.getObject("iconPosition");
            this.iconX = simpleJSONObject2.get("x", 0);
            this.iconY = simpleJSONObject2.get("y", 0);
        } else {
            this.iconX = 0;
            this.iconY = 0;
        }
        if (simpleJSONObject.containsKey("travelTimes")) {
            this.travelTimesInHours = new HashMap<String, Integer>();
            simpleJSONObject2 = simpleJSONObject.getObject("travelTimes");
            for (String string : simpleJSONObject2.keySet()) {
                this.travelTimesInHours.put(string, simpleJSONObject2.get(string, 0));
            }
        } else {
            this.travelTimesInHours = Collections.emptyMap();
        }
        this.revealed = false;
    }

    public void setRevealed(boolean bl) {
        this.revealed = bl;
    }

    public boolean isRevealed() {
        return this.revealed;
    }

    public int getIconPositionX() {
        return this.iconX;
    }

    public int getIconPositionY() {
        return this.iconY;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getStartingTransition() {
        return this.startingTransition;
    }

    public int getTravelTime(WorldMapLocation worldMapLocation) {
        return this.travelTimesInHours.get(worldMapLocation.getName());
    }
}

