/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Creature;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.rules.Skill;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONObject;

public class SkillSet
implements Saveable {
    private final Creature parent;
    private final Map<String, Integer> skills = new LinkedHashMap<String, Integer>();

    @Override
    public JSONOrderedObject save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        for (String string : this.skills.keySet()) {
            int n = this.skills.get(string);
            if (n == 0) continue;
            jSONOrderedObject.put(string, n);
        }
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject) {
        this.clear();
        for (String string : simpleJSONObject.keySet()) {
            int n = simpleJSONObject.get(string, 0);
            this.addRanks(string, n);
        }
    }

    public SkillSet(Creature creature) {
        this.parent = creature;
    }

    public SkillSet(SkillSet skillSet, Creature creature) {
        this(creature);
        for (String string : skillSet.skills.keySet()) {
            this.skills.put(string, skillSet.skills.get(string));
        }
    }

    public boolean equals(SkillSet skillSet) {
        if (skillSet == null) {
            return false;
        }
        for (String string : this.skills.keySet()) {
            if (this.skills.get(string).equals(skillSet.skills.get(string))) continue;
            return false;
        }
        for (String string : skillSet.skills.keySet()) {
            if (skillSet.skills.get(string).equals(this.skills.get(string))) continue;
            return false;
        }
        return true;
    }

    public void addRanksFromList(SkillSet skillSet) {
        if (skillSet == null) {
            return;
        }
        for (String string : skillSet.skills.keySet()) {
            this.addRanks(string, (int)skillSet.skills.get(string));
        }
    }

    public int size() {
        return this.skills.size();
    }

    public void addRanks(String string, int n) {
        if (Game.ruleset.getSkill(string) == null) {
            Logger.appendToErrorLog("Skill ID: " + string + " not found");
        } else {
            int n2 = this.getRanks(string);
            this.skills.put(string, n2 + n);
            this.parent.updateListeners();
        }
    }

    public void addRanks(Skill skill, int n) {
        this.addRanks(skill.getID(), n);
    }

    public boolean hasRanks(Skill skill) {
        return this.hasRanks(skill.getID());
    }

    public boolean hasRanks(String string) {
        Integer n = this.skills.get(string);
        if (n == null) {
            return false;
        }
        return n != 0;
    }

    public int getRanks(String string) {
        Integer n = this.skills.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public int getRanks(Skill skill) {
        return this.getRanks(skill.getID());
    }

    public void clear() {
        this.skills.clear();
    }

    public Set<String> getSkills() {
        return Collections.unmodifiableSet(this.skills.keySet());
    }

    public int getTotalModifier(Skill skill) {
        int n = this.getRanks(skill.getID());
        int n2 = this.parent.stats.getSkillBonus(skill.getID()) + (this.parent.stats.get(skill.getKeyAttribute()) - 10) * 2;
        if (skill.suffersArmorPenalty()) {
            n2 -= this.parent.stats.get(Stat.ArmorPenalty);
        }
        return n + n2;
    }

    public int getTotalModifier(String string) {
        return this.getTotalModifier(Game.ruleset.getSkill(string));
    }

    public boolean performCheck(String string, int n) {
        return this.getCheck(string, n, null) >= n;
    }

    public int getCheck(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.getCheck(string, n, stringBuilder);
        if (n2 != 0) {
            Game.mainViewer.addMessage("orange", stringBuilder.toString());
        }
        return n2;
    }

    private int getCheck(String string, int n, StringBuilder stringBuilder) {
        Skill skill = Game.ruleset.getSkill(string);
        if (!skill.isUsableUntrained() && this.getRanks(skill) < 1) {
            return 0;
        }
        int n2 = this.getTotalModifier(skill);
        int n3 = !Game.isInTurnMode() && skill.alwaysRolls100OutsideOfCombat() ? 100 : Game.dice.d100();
        int n4 = n2 + n3;
        if (stringBuilder != null) {
            stringBuilder.append(skill.getNoun());
            stringBuilder.append(" Check: ");
            stringBuilder.append(n2);
            stringBuilder.append(" + ");
            stringBuilder.append(n3);
            stringBuilder.append(" = ");
            stringBuilder.append(n4);
            stringBuilder.append(" vs ");
            stringBuilder.append(n);
            stringBuilder.append(" : ");
            if (n4 >= n) {
                stringBuilder.append("Success.");
            } else {
                stringBuilder.append("Failure.");
            }
        }
        return n4;
    }
}

