/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import net.sf.hale.Game;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Creature;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.Role;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Skill
implements Comparable<Skill> {
    private final String id;
    private final String noun;
    private final String presentTenseVerb;
    private final String pastTenseVerb;
    private final Icon icon;
    private final String restrictToRole;
    private final boolean isUsableUntrained;
    private final Stat keyAttribute;
    private final boolean suffersArmorPenalty;
    private final boolean isCraft;
    private final boolean alwaysRolls100OutsideOfCombat;

    public Skill(String string) {
        this.id = string;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("skills/" + string + ResourceType.JSON.getExtension());
        SimpleJSONObject simpleJSONObject = simpleJSONParser.getObject("name");
        this.noun = simpleJSONObject.get("noun", null);
        this.presentTenseVerb = simpleJSONObject.get("presentTenseVerb", null);
        this.pastTenseVerb = simpleJSONObject.get("pastTenseVerb", null);
        this.icon = simpleJSONParser.containsKey("icon") ? IconFactory.createIcon(simpleJSONParser.getObject("icon")) : IconFactory.emptyIcon;
        this.isUsableUntrained = simpleJSONParser.get("isUsableUntrained", false);
        this.suffersArmorPenalty = simpleJSONParser.get("suffersArmorPenalty", false);
        this.keyAttribute = Stat.valueOf(simpleJSONParser.get("keyAttribute", null));
        this.isCraft = simpleJSONParser.get("isCraft", false);
        this.restrictToRole = simpleJSONParser.containsKey("restrictToRole") ? simpleJSONParser.get("restrictToRole", null) : null;
        this.alwaysRolls100OutsideOfCombat = simpleJSONParser.containsKey("alwaysRolls100OutsideOfCombat") ? simpleJSONParser.get("alwaysRolls100OutsideOfCombat", false) : false;
        simpleJSONParser.warnOnUnusedKeys();
    }

    public boolean alwaysRolls100OutsideOfCombat() {
        return this.alwaysRolls100OutsideOfCombat;
    }

    public boolean canUse(Role role) {
        if (this.restrictToRole == null) {
            return true;
        }
        return role.getID().equals(this.restrictToRole);
    }

    public boolean canUse(Creature creature) {
        if (this.restrictToRole == null) {
            return true;
        }
        Role role = Game.ruleset.getRole(this.restrictToRole);
        return creature.roles.contains(role);
    }

    public boolean isRestrictedToARole() {
        return this.restrictToRole != null;
    }

    public String getRestrictToRole() {
        return this.restrictToRole;
    }

    public String getDescription() {
        return ResourceManager.getResourceAsString("descriptions/skills/" + this.noun + ResourceType.HTML.getExtension());
    }

    public String getID() {
        return this.id;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getPastTenseVerb() {
        return this.pastTenseVerb;
    }

    public String getPresentTenseVerb() {
        return this.presentTenseVerb;
    }

    public String getNoun() {
        return this.noun;
    }

    public boolean isUsableUntrained() {
        return this.isUsableUntrained;
    }

    public Stat getKeyAttribute() {
        return this.keyAttribute;
    }

    public boolean suffersArmorPenalty() {
        return this.suffersArmorPenalty;
    }

    public boolean isCraft() {
        return this.isCraft;
    }

    @Override
    public int compareTo(Skill skill) {
        return this.id.compareTo(skill.id);
    }
}

