/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.hale.Cutscene;
import net.sf.hale.DifficultyManager;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.AbilitySelectionList;
import net.sf.hale.entity.SavedItemList;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.ArmorType;
import net.sf.hale.rules.BaseWeapon;
import net.sf.hale.rules.DamageType;
import net.sf.hale.rules.Faction;
import net.sf.hale.rules.Quality;
import net.sf.hale.rules.Race;
import net.sf.hale.rules.RacialType;
import net.sf.hale.rules.Role;
import net.sf.hale.rules.Skill;
import net.sf.hale.rules.XP;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Ruleset {
    private final Map<String, Ability> abilities = new HashMap<String, Ability>();
    private final Map<String, Race> races;
    private final Map<String, Role> roles;
    private final Map<String, Skill> skills;
    private final Map<String, Faction> factions;
    private final Map<String, DamageType> damageTypes;
    private final Map<String, BaseWeapon> baseWeapons;
    private final Map<String, ArmorType> armorTypes;
    private final Map<String, SavedItemList> itemLists;
    private final Map<String, AbilitySelectionList> abilitySelectionLists = new HashMap<String, AbilitySelectionList>();
    private final Map<String, RacialType> racialTypes;
    private final Map<String, Quality> itemQualities;
    private final Map<String, Integer> ruleValues;
    private final Map<String, String> ruleStrings;
    private final Map<String, Cutscene> cutscenes;
    private DifficultyManager difficultyManager;

    public Ruleset() {
        this.races = new LinkedHashMap<String, Race>();
        this.roles = new LinkedHashMap<String, Role>();
        this.skills = new LinkedHashMap<String, Skill>();
        this.factions = new HashMap<String, Faction>();
        this.damageTypes = new LinkedHashMap<String, DamageType>();
        this.baseWeapons = new HashMap<String, BaseWeapon>();
        this.armorTypes = new HashMap<String, ArmorType>();
        this.itemLists = new LinkedHashMap<String, SavedItemList>();
        this.racialTypes = new HashMap<String, RacialType>();
        this.ruleValues = new HashMap<String, Integer>();
        this.ruleStrings = new HashMap<String, String>();
        this.itemQualities = new HashMap<String, Quality>();
        this.cutscenes = new HashMap<String, Cutscene>();
    }

    public void readData() {
        this.readRuleValuesAndStrings();
        this.readItemQualities();
        this.readFactions();
        this.readDamageTypes();
        this.readBaseWeapons();
        this.readArmorTypes();
        this.readRacialTypes();
        this.readAbilities();
        this.readAbilitySelectionLists();
        this.readRaces();
        this.readSkills();
        this.readRoles();
        this.readItemLists();
        this.readCutscenes();
        XP.initXPTable();
        this.difficultyManager = new DifficultyManager();
    }

    public DifficultyManager getDifficultyManager() {
        return this.difficultyManager;
    }

    private void readItemLists() {
        this.itemLists.clear();
        Set<String> set = ResourceManager.getResourcesInDirectory("itemLists");
        for (String string : set) {
            String string2 = ResourceManager.getResourceID(string, "itemLists", ResourceType.JSON);
            if (string2 == null) continue;
            SimpleJSONParser simpleJSONParser = new SimpleJSONParser("itemLists/" + string2, ResourceType.JSON);
            this.itemLists.put(string2, new SavedItemList(simpleJSONParser.getObject()));
        }
    }

    private void readCutscenes() {
        this.cutscenes.clear();
        for (String string : ResourceManager.getResourcesInDirectory("cutscenes")) {
            String string2 = ResourceManager.getResourceID(string, "cutscenes", ResourceType.JSON);
            if (string2 == null) continue;
            this.cutscenes.put(string2, new Cutscene(string2, string));
        }
    }

    private void readRaces() {
        this.races.clear();
        Set<String> set = ResourceManager.getResourcesInDirectory("races");
        for (String string : set) {
            String string2 = ResourceManager.getResourceID(string, "races", ResourceType.JSON);
            if (string2 == null) continue;
            try {
                this.races.put(string2, new Race(string2));
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error loading race " + string2, exception);
            }
        }
    }

    private void readRoles() {
        this.roles.clear();
        Set<String> set = ResourceManager.getResourcesInDirectory("roles");
        for (String string : set) {
            String string2 = ResourceManager.getResourceIDNoPath(string, ResourceType.JSON);
            if (string2 == null) continue;
            try {
                this.roles.put(string2, new Role(string2, new SimpleJSONParser(string).getObject()));
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error loading role " + string2, exception);
            }
        }
    }

    private void readSkills() {
        this.skills.clear();
        Set<String> set = ResourceManager.getResourcesInDirectory("skills");
        for (String string : set) {
            String string2 = ResourceManager.getResourceID(string, "skills", ResourceType.JSON);
            if (string2 == null) continue;
            this.skills.put(string2, new Skill(string2));
        }
    }

    private void readAbilities() {
        this.abilities.clear();
        for (String string : ResourceManager.getResourcesInDirectory("abilities")) {
            String string2 = ResourceManager.getResourceIDNoPath(string, ResourceType.JSON);
            if (string2 == null) continue;
            this.abilities.put(string2, Ability.createAbilityFromResource(string2, string));
        }
    }

    private void readItemQualities() {
        this.itemQualities.clear();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("itemQualities", ResourceType.JSON);
        simpleJSONParser.setWarnOnMissingKeys(true);
        SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("qualities");
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            Quality quality = new Quality(simpleJSONObject);
            this.itemQualities.put(quality.getName(), quality);
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    private void readAbilitySelectionLists() {
        Object object;
        this.abilitySelectionLists.clear();
        for (String string : ResourceManager.getResourcesInDirectory("abilitySelectionLists")) {
            object = ResourceManager.getResourceIDNoPath(string, ResourceType.JSON);
            if (object == null) continue;
            try {
                this.abilitySelectionLists.put((String)object, new AbilitySelectionList((String)object, string));
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error reading selection list " + (String)object, exception);
            }
        }
        for (String string : this.abilitySelectionLists.keySet()) {
            object = this.abilitySelectionLists.get(string);
            for (String string2 : ((AbilitySelectionList)object).getSubListIDs()) {
                if (this.abilitySelectionLists.containsKey(string2)) continue;
                Logger.appendToWarningLog("Referenced SubList " + string2 + " in AbilitySelectionList " + string + " does not exist.");
            }
        }
    }

    private void readRuleValuesAndStrings() {
        this.ruleValues.clear();
        this.ruleStrings.clear();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("rules", ResourceType.JSON);
        for (String string : simpleJSONParser.keySet()) {
            if (simpleJSONParser.isInteger(string)) {
                this.ruleValues.put(string, simpleJSONParser.get(string, 0));
                continue;
            }
            if (!simpleJSONParser.isString(string)) continue;
            this.ruleStrings.put(string, simpleJSONParser.get(string, null));
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    private void readDamageTypes() {
        this.damageTypes.clear();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("damageTypes", ResourceType.JSON);
        for (String string : simpleJSONParser.keySet()) {
            String string2 = simpleJSONParser.get(string, "Energy");
            if (string2.equals("Energy")) {
                this.damageTypes.put(string, new DamageType(string, true));
                continue;
            }
            this.damageTypes.put(string, new DamageType(string, false));
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    private void readRacialTypes() {
        this.racialTypes.clear();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("racialTypes", ResourceType.JSON);
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONParser.getArray("racialTypes")) {
            String string = simpleJSONArrayEntry.getString();
            this.racialTypes.put(string, new RacialType(string));
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    private void readFactions() {
        this.factions.clear();
        HashMap<Object, SimpleJSONArray> hashMap = new HashMap<Object, SimpleJSONArray>();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("factions", ResourceType.JSON);
        for (Object object : simpleJSONParser.getArray("factions")) {
            SimpleJSONObject simpleJSONObject = ((SimpleJSONArrayEntry)object).getObject();
            Object object2 = new Faction(simpleJSONObject.get("id", null));
            ((Faction)object2).setRelationship((Faction)object2, Faction.Relationship.Friendly);
            if (simpleJSONObject.containsKey("relationships")) {
                hashMap.put(object2, simpleJSONObject.getArray("relationships"));
            }
            this.factions.put(((Faction)object2).getName(), (Faction)object2);
        }
        for (Object object : hashMap.keySet()) {
            for (Object object2 : (SimpleJSONArray)hashMap.get(object)) {
                SimpleJSONObject simpleJSONObject = ((SimpleJSONArrayEntry)object2).getObject();
                String string = simpleJSONObject.get("id", null);
                String string2 = simpleJSONObject.get("relationship", null);
                Faction.Relationship relationship = Faction.Relationship.valueOf(string2);
                ((Faction)object).setRelationship(string, relationship);
                this.factions.get(string).setRelationship((Faction)object, relationship);
            }
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    private void readArmorTypes() {
        this.armorTypes.clear();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("armorTypes", ResourceType.JSON);
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONParser.getArray("armorTypes")) {
            String string = simpleJSONArrayEntry.getString();
            this.armorTypes.put(string, new ArmorType(string));
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    private void readBaseWeapons() {
        this.baseWeapons.clear();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("baseWeapons", ResourceType.JSON);
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONParser.getArray("baseWeapons")) {
            String string = simpleJSONArrayEntry.getString();
            this.baseWeapons.put(string, new BaseWeapon(string));
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    public int getValue(String string) {
        return this.ruleValues.get(string);
    }

    public String getString(String string) {
        return this.ruleStrings.get(string);
    }

    public Collection<DamageType> getAllDamageTypes() {
        return this.damageTypes.values();
    }

    public Collection<Race> getAllRaces() {
        return this.races.values();
    }

    public Collection<Role> getAllRoles() {
        return this.roles.values();
    }

    public Collection<Skill> getAllSkills() {
        return this.skills.values();
    }

    public Quality getItemQuality(String string) {
        return this.itemQualities.get(string);
    }

    public Cutscene getCutscene(String string) {
        return this.cutscenes.get(string);
    }

    public RacialType getRacialType(String string) {
        return this.racialTypes.get(string);
    }

    public SavedItemList getItemList(String string) {
        return this.itemLists.get(string);
    }

    public BaseWeapon getBaseWeapon(String string) {
        return this.baseWeapons.get(string);
    }

    public ArmorType getArmorType(String string) {
        return this.armorTypes.get(string);
    }

    public DamageType getDamageType(String string) {
        return this.damageTypes.get(string);
    }

    public Faction getFaction(String string) {
        return this.factions.get(string);
    }

    public Race getRace(String string) {
        return this.races.get(string);
    }

    public Role getRole(String string) {
        return this.roles.get(string);
    }

    public Skill getSkill(String string) {
        return this.skills.get(string);
    }

    public Ability getAbility(String string) {
        return this.abilities.get(string);
    }

    public AbilitySelectionList getAbilitySelectionList(String string) {
        return this.abilitySelectionLists.get(string);
    }

    public static enum Gender {
        Female,
        Male;

    }
}

