/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Creature;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.rules.Role;
import net.sf.hale.util.SimpleJSONObject;

public class RoleSet
implements Saveable {
    private String baseRoleID;
    private final Map<String, Integer> roles = new LinkedHashMap<String, Integer>();
    private int casterLevel = 0;
    private int totalLevel = 0;
    private Creature parent;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        if (this.baseRoleID != null) {
            jSONOrderedObject.put("baseRoleID", this.baseRoleID);
            Role role = Game.ruleset.getRole(this.baseRoleID);
            if (!role.isBase()) {
                throw new IllegalArgumentException("Error saving: base role for " + this.parent.getTemplate().getID() + " is invalid.");
            }
        }
        for (String string : this.roles.keySet()) {
            int n = this.roles.get(string);
            if (n == 0) continue;
            jSONOrderedObject.put(string, n);
        }
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject, boolean bl) {
        Object object;
        this.totalLevel = 0;
        this.casterLevel = 0;
        this.baseRoleID = simpleJSONObject.get("baseRoleID", null);
        if (this.baseRoleID != null && !((Role)(object = Game.ruleset.getRole(this.baseRoleID))).isBase()) {
            throw new IllegalArgumentException("Error loading: base role for " + this.parent.getTemplate().getID() + " is invalid.");
        }
        for (String string : simpleJSONObject.keySet()) {
            if (string.equals("baseRoleID")) continue;
            if (this.baseRoleID == null) {
                this.baseRoleID = string;
            }
            Role role = Game.ruleset.getRole(string);
            int n = simpleJSONObject.get(string, 0);
            this.roles.put(string, n);
            this.totalLevel += n;
            for (int i = 1; i <= n; ++i) {
                this.casterLevel += role.getCasterLevelAddedAtLevel(i);
                List<Ability> list = role.getAbilitiesAddedAtLevel(i);
                for (Ability ability : list) {
                    if (bl) {
                        this.parent.abilities.addRoleAbility(ability, i);
                        continue;
                    }
                    this.parent.abilities.loadAbility(ability, i, true, false);
                }
            }
        }
    }

    public RoleSet(Creature creature) {
        this.parent = creature;
    }

    public RoleSet(RoleSet roleSet, Creature creature) {
        this(creature);
        for (String string : roleSet.roles.keySet()) {
            this.roles.put(string, roleSet.roles.get(string));
        }
        this.casterLevel = roleSet.casterLevel;
        this.totalLevel = roleSet.totalLevel;
        this.baseRoleID = roleSet.baseRoleID;
    }

    public void addLevels(RoleSet roleSet) {
        this.addLevels(roleSet.getBaseRole(), (int)roleSet.roles.get(roleSet.baseRoleID));
        for (String string : roleSet.roles.keySet()) {
            if (string.equals(roleSet.baseRoleID)) continue;
            Role role = Game.ruleset.getRole(string);
            this.addLevels(role, (int)roleSet.roles.get(string));
        }
    }

    public void addLevels(String string, int n) {
        this.addLevels(Game.ruleset.getRole(string), n);
    }

    public void addLevels(Role role, int n) {
        Integer n2;
        if (n < 1) {
            throw new IllegalArgumentException("Only a positive number of levels may be added to a RoleSet.");
        }
        if (this.baseRoleID == null) {
            this.baseRoleID = role.getID();
            if (!role.isBase()) {
                throw new IllegalArgumentException("The first role added to a role set must be a base role.");
            }
        }
        int n3 = (n2 = this.roles.get(role.getID())) != null ? n2 : 0;
        int n4 = n3 + n;
        this.roles.put(role.getID(), n4);
        this.totalLevel += n;
        for (int i = n3 + 1; i <= n4; ++i) {
            this.casterLevel += role.getCasterLevelAddedAtLevel(i);
            if (this.parent == null) continue;
            List<Ability> list = role.getAbilitiesAddedAtLevel(i);
            for (Ability ability : list) {
                this.parent.abilities.addRoleAbility(ability, i);
            }
        }
        if (this.parent != null) {
            this.parent.stats.recomputeAllStats();
            this.parent.updateListeners();
        }
    }

    public int getLevel(String string) {
        if (!this.roles.containsKey(string)) {
            return 0;
        }
        return this.roles.get(string);
    }

    public int getLevel(Role role) {
        return this.getLevel(role.getID());
    }

    public int getCasterLevel() {
        return this.casterLevel;
    }

    public int getTotalLevel() {
        return this.totalLevel;
    }

    public boolean contains(Role role) {
        return this.roles.containsKey(role.getID());
    }

    public boolean contains(String string) {
        return this.roles.containsKey(string);
    }

    public Role getBaseRole() {
        if (this.baseRoleID == null) {
            return null;
        }
        return Game.ruleset.getRole(this.baseRoleID);
    }

    public void clear() {
        this.roles.clear();
        this.totalLevel = 0;
        this.casterLevel = 0;
        this.baseRoleID = null;
    }

    public Set<String> getRoleIDs() {
        return Collections.unmodifiableSet(this.roles.keySet());
    }

    public int getVerbalSpellFailure() {
        if (this.parent.stats.has(Bonus.Type.Silence)) {
            return 0xCCCCCCC;
        }
        if (this.parent.getLocation().getArea() != null && this.parent.getLocation().getArea().isSilenced(this.parent.getLocation().getX(), this.parent.getLocation().getY())) {
            return 0xCCCCCCC;
        }
        int n = 0;
        if (this.parent.stats.has(Bonus.Type.Deaf)) {
            n = 30;
        }
        return Math.max(0, n - this.parent.stats.get(Bonus.Type.VerbalSpellFailure));
    }

    public int getSomaticSpellFailure() {
        return Math.max(0, this.parent.stats.get(Stat.ArmorPenalty) - this.parent.stats.get(Bonus.Type.ArmorSpellFailure));
    }

    public int getThreatenedSpellFailure() {
        List<Creature> list = Game.areaListener.getCombatRunner().getThreateningCreatures(this.parent);
        if (list.size() != 0) {
            int n = 0;
            for (Creature creature : list) {
                int n2 = 30;
                int n3 = Game.curCampaign.curArea.getConcealment(creature, this.parent);
                n2 = n2 * (100 - n3) / 100;
                n += Math.max(0, n2);
            }
            return Math.max(0, n - this.parent.stats.get(Bonus.Type.MeleeSpellFailure));
        }
        return 0;
    }
}

