/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.AbilitySelectionList;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Creature;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.PrereqList;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class Role {
    private final String id;
    private final String name;
    private final Icon icon;
    private final int skillPointsPerLevel;
    private final int hpPerLevel;
    private final int hpAtLevelOne;
    private final int attackBonusPerLevel;
    private final int damageBonusPerLevel;
    private final int maximumLevel;
    private final Stat spellCastingAttribute;
    private final int spellFailureBase;
    private final int spellFailureSpellLevelFactor;
    private final int spellFailureAbilityScoreFactor;
    private final int spellFailureCasterLevelFactor;
    private final int maximumSpellLevel;
    private final boolean isPlayer;
    private final boolean isBase;
    private final Map<Stat, Integer> defaultPlayerAttributes;
    private final List<String> defaultPlayerSkillSelections;
    private final PrereqList prereqs;
    private final Map<Integer, LevelUpList> levelUpLists;

    public Role(String string, SimpleJSONObject simpleJSONObject) {
        Iterator<SimpleJSONArrayEntry> iterator;
        Object object;
        Object object2;
        this.id = string;
        this.name = simpleJSONObject.get("name", string);
        this.icon = simpleJSONObject.containsKey("icon") ? IconFactory.createIcon(simpleJSONObject.getObject("icon")) : IconFactory.emptyIcon;
        this.isPlayer = simpleJSONObject.get("isPlayer", false);
        this.isBase = simpleJSONObject.get("isBase", false);
        SimpleJSONObject simpleJSONObject2 = simpleJSONObject.getObject("stats");
        this.damageBonusPerLevel = simpleJSONObject2.get("damageBonusPerLevel", 0);
        this.attackBonusPerLevel = simpleJSONObject2.get("attackBonusPerLevel", 0);
        this.skillPointsPerLevel = simpleJSONObject2.get("skillPointsPerLevel", 0);
        this.hpPerLevel = simpleJSONObject2.get("hpPerLevel", 0);
        this.hpAtLevelOne = simpleJSONObject2.containsKey("hpAtLevelOne") ? simpleJSONObject2.get("hpAtLevelOne", 0) : this.hpPerLevel;
        this.maximumLevel = simpleJSONObject2.containsKey("maximumLevel") ? simpleJSONObject2.get("maximumLevel", 0) : Integer.MAX_VALUE;
        this.maximumSpellLevel = simpleJSONObject2.containsKey("maximumSpellLevel") ? simpleJSONObject2.get("maximumSpellLevel", 0) : 0;
        if (simpleJSONObject2.containsKey("spellCastingAttribute")) {
            this.spellCastingAttribute = Stat.valueOf(simpleJSONObject2.get("spellCastingAttribute", null));
            this.spellFailureBase = simpleJSONObject2.get("spellFailureBase", 0);
            this.spellFailureSpellLevelFactor = simpleJSONObject2.get("spellFailureSpellLevelFactor", 0);
            this.spellFailureAbilityScoreFactor = simpleJSONObject2.get("spellFailureAbilityScoreFactor", 0);
            this.spellFailureCasterLevelFactor = simpleJSONObject2.get("spellFailureCasterLevelFactor", 0);
        } else {
            this.spellCastingAttribute = null;
            this.spellFailureBase = 0;
            this.spellFailureSpellLevelFactor = 0;
            this.spellFailureAbilityScoreFactor = 0;
            this.spellFailureCasterLevelFactor = 0;
        }
        this.defaultPlayerAttributes = new HashMap<Stat, Integer>();
        this.defaultPlayerSkillSelections = new ArrayList<String>(5);
        if (simpleJSONObject.containsKey("defaultSelections")) {
            object2 = simpleJSONObject.getObject("defaultSelections");
            for (String object3 : ((SimpleJSONObject)object2).keySet()) {
                Object object4;
                if (object3.equals("skills")) {
                    object4 = ((SimpleJSONObject)object2).getArray(object3);
                    object = ((SimpleJSONArray)object4).iterator();
                    while (object.hasNext()) {
                        iterator = object.next();
                        this.defaultPlayerSkillSelections.add(((SimpleJSONArrayEntry)((Object)iterator)).getString());
                    }
                    continue;
                }
                object4 = Stat.valueOf(object3);
                int n = ((SimpleJSONObject)object2).get(object3, 0);
                this.defaultPlayerAttributes.put((Stat)((Object)object4), n);
            }
        }
        this.prereqs = simpleJSONObject.containsKey("prereqs") ? new PrereqList(simpleJSONObject.getObject("prereqs")) : new PrereqList();
        this.levelUpLists = new HashMap<Integer, LevelUpList>();
        if (simpleJSONObject.containsKey("casterLevelsAdded")) {
            object2 = simpleJSONObject.getArray("casterLevelsAdded");
            Iterator<Object> iterator2 = ((SimpleJSONArray)object2).iterator();
            while (iterator2.hasNext()) {
                SimpleJSONArrayEntry simpleJSONArrayEntry = (SimpleJSONArrayEntry)iterator2.next();
                int n = simpleJSONArrayEntry.getInt(0);
                object = this.getLevelUpList(n);
                ((LevelUpList)object).casterLevelAdded++;
            }
        }
        if (simpleJSONObject.containsKey("abilitiesAdded")) {
            object2 = simpleJSONObject.getObject("abilitiesAdded");
            for (String string2 : ((SimpleJSONObject)object2).keySet()) {
                int n = ((SimpleJSONObject)object2).get(string2, 0);
                object = Game.ruleset.getAbility(string2);
                if (object == null) {
                    throw new IllegalArgumentException("Ability ID \"" + string2 + "\" not found while reading " + string);
                }
                iterator = this.getLevelUpList(n);
                ((LevelUpList)((Object)iterator)).abilities.add(string2);
            }
        }
        if (simpleJSONObject.containsKey("abilitySelectionsFromList")) {
            object2 = simpleJSONObject.getObject("abilitySelectionsFromList");
            for (String string3 : ((SimpleJSONObject)object2).keySet()) {
                AbilitySelectionList abilitySelectionList = Game.ruleset.getAbilitySelectionList(string3);
                if (abilitySelectionList == null) {
                    throw new IllegalArgumentException("Ability Selection List \"" + string3 + "\" not found while reading " + string);
                }
                object = ((SimpleJSONObject)object2).getArray(string3);
                iterator = ((SimpleJSONArray)object).iterator();
                while (iterator.hasNext()) {
                    SimpleJSONArrayEntry simpleJSONArrayEntry = iterator.next();
                    LevelUpList levelUpList = this.getLevelUpList(simpleJSONArrayEntry.getInt(0));
                    levelUpList.abilitySelectionLists.add(string3);
                }
            }
        }
    }

    private LevelUpList getLevelUpList(int n) {
        LevelUpList levelUpList = this.levelUpLists.get(n);
        if (levelUpList == null) {
            levelUpList = new LevelUpList();
            this.levelUpLists.put(n, levelUpList);
        }
        return levelUpList;
    }

    public List<String> getDefaultPlayerSkillSelections() {
        return Collections.unmodifiableList(this.defaultPlayerSkillSelections);
    }

    public int getDefaultPlayerAttributeSelection(Stat stat) {
        Integer n = this.defaultPlayerAttributes.get((Object)stat);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public int getHPAtLevelOne() {
        return this.hpAtLevelOne;
    }

    public String getDescription() {
        return ResourceManager.getResourceAsString("descriptions/roles/" + this.id + ResourceType.HTML.getExtension());
    }

    public Stat getSpellCastingAttribute() {
        return this.spellCastingAttribute;
    }

    public int getSpellFailureBase() {
        return this.spellFailureBase;
    }

    public int getSpellFailureSpellLevelFactor() {
        return this.spellFailureSpellLevelFactor;
    }

    public int getSpellFailureAbilityScoreFactor() {
        return this.spellFailureAbilityScoreFactor;
    }

    public int getSpellFailureCasterLevelFactor() {
        return this.spellFailureCasterLevelFactor;
    }

    public int getMaximumSpellLevel() {
        return this.maximumSpellLevel;
    }

    public boolean isBase() {
        return this.isBase;
    }

    public boolean isPlayer() {
        return this.isPlayer;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public int getSkillPointsPerLevel() {
        return this.skillPointsPerLevel;
    }

    public int getHPPerLevel() {
        return this.hpPerLevel;
    }

    public int getAttackBonusPerLevel() {
        return this.attackBonusPerLevel;
    }

    public int getDamageBonusPerLevel() {
        return this.damageBonusPerLevel;
    }

    public void appendDescription(StringBuilder stringBuilder, Creature creature) {
        stringBuilder.append("<div style=\"font-family: large-red;\">");
        stringBuilder.append(this.name).append("</div>");
        if (!this.isBase) {
            stringBuilder.append("<div style=\"font-family: medium\">");
            stringBuilder.append("Specialization");
            stringBuilder.append("</div>");
        }
        if (this.maximumLevel != Integer.MAX_VALUE) {
            stringBuilder.append("<div>");
            stringBuilder.append("<span style=\"font-family: red\">");
            stringBuilder.append(this.maximumLevel);
            stringBuilder.append("</span>");
            stringBuilder.append(" Level Maximum");
            stringBuilder.append("</div>");
        }
        this.prereqs.appendDescription(stringBuilder, creature);
        stringBuilder.append("<div style=\"font-family: medium-bold-blue; margin-top: 1em;\">");
        stringBuilder.append("Stats");
        stringBuilder.append("</div>");
        stringBuilder.append("<table>");
        if (this.isBase) {
            stringBuilder.append("<tr><td style=\"text-align:right; width:4ex;\"><span style=\"font-family: blue;\">");
            stringBuilder.append(this.hpAtLevelOne);
            stringBuilder.append("</span></td><td style=\"margin-left: 1ex;\"> Hit Points at first level</td></tr>");
        }
        stringBuilder.append("<tr style=\"margin-bottom: 1em;\">");
        stringBuilder.append("<td style=\"text-align:right; width:4ex;\">+<span style=\"font-family: blue;\">");
        stringBuilder.append(this.hpPerLevel);
        stringBuilder.append("</span></td><td style=\"margin-left: 1ex;\">Hit Points at each level</td></tr>");
        stringBuilder.append("<tr><td style=\"text-align:right; width:4ex;\">+<span style=\"font-family: blue;\">");
        stringBuilder.append(this.attackBonusPerLevel);
        stringBuilder.append("</span></td><td style=\"margin-left: 1ex;\">Attack Bonus per level</td></tr>");
        stringBuilder.append("<tr style=\"margin-bottom: 1em\">");
        stringBuilder.append("<td style=\"text-align:right; width: 4ex;\">+<span style=\"font-family: blue;\">");
        stringBuilder.append(this.damageBonusPerLevel);
        stringBuilder.append("</span></td><td style=\"margin-left: 1 ex;\">Damage Bonus per level</td></tr>");
        stringBuilder.append("<tr><td style=\"text-align:right; width:4ex;\">+<span style=\"font-family: blue;\">");
        stringBuilder.append(this.skillPointsPerLevel);
        stringBuilder.append("</span></td><td style=\"margin-left: 1ex;\"> Skill Points per level (before Intelligence modifier)</td></tr>");
        stringBuilder.append("</table>");
        stringBuilder.append(this.getDescription());
    }

    public boolean creatureCanSelect(Creature creature) {
        if (creature == null) {
            return false;
        }
        if (!this.prereqs.meetsPrereqs(creature)) {
            return false;
        }
        if (this.isBase && creature.roles.getBaseRole() != null && creature.roles.getBaseRole() != this) {
            return false;
        }
        return creature.roles.getLevel(this) < this.maximumLevel;
    }

    public boolean creatureHasRolePrereqs(Creature creature) {
        if (this.isBase) {
            return false;
        }
        return this.prereqs.hasRolePrereqs(creature);
    }

    public int getCasterLevelAddedAtLevel(int n) {
        LevelUpList levelUpList = this.levelUpLists.get(n);
        if (levelUpList == null) {
            return 0;
        }
        return levelUpList.casterLevelAdded;
    }

    public List<Ability> getAbilitiesAddedAtLevel(int n) {
        LevelUpList levelUpList = this.levelUpLists.get(n);
        if (levelUpList == null) {
            return Collections.emptyList();
        }
        List list = levelUpList.abilities;
        ArrayList<Ability> arrayList = new ArrayList<Ability>(list.size());
        for (String string : list) {
            arrayList.add(Game.ruleset.getAbility(string));
        }
        return arrayList;
    }

    public List<AbilitySelectionList> getAbilitySelectionsAddedAtLevel(int n) {
        LevelUpList levelUpList = this.levelUpLists.get(n);
        if (levelUpList == null) {
            return Collections.emptyList();
        }
        List list = levelUpList.abilitySelectionLists;
        ArrayList<AbilitySelectionList> arrayList = new ArrayList<AbilitySelectionList>(list.size());
        for (String string : list) {
            arrayList.add(Game.ruleset.getAbilitySelectionList(string));
        }
        return arrayList;
    }

    public Set<AbilitySelectionList> getAllReferencedAbilitySelectionLists() {
        LinkedHashSet<AbilitySelectionList> linkedHashSet = new LinkedHashSet<AbilitySelectionList>();
        for (LevelUpList levelUpList : this.levelUpLists.values()) {
            for (String string : levelUpList.abilitySelectionLists) {
                AbilitySelectionList abilitySelectionList = Game.ruleset.getAbilitySelectionList(string);
                linkedHashSet.add(abilitySelectionList);
            }
        }
        return linkedHashSet;
    }

    private class LevelUpList {
        private List<String> abilitySelectionLists = new ArrayList<String>(0);
        private List<String> abilities = new ArrayList<String>(0);
        private int casterLevelAdded = 0;

        private LevelUpList() {
        }
    }
}

