/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.Recipe;
import net.sf.hale.rules.Skill;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONParser;

public class RecipeManager {
    private Map<String, Recipe> recipes = new HashMap<String, Recipe>();
    private Map<String, List<String>> recipesBySkill = new HashMap<String, List<String>>();
    private Map<EquippableItemTemplate.Type, List<String>> enchantmentsByItemType = new HashMap<EquippableItemTemplate.Type, List<String>>();

    public Recipe getRecipe(String string) {
        return this.recipes.get(string);
    }

    public void loadRecipes() {
        this.recipes.clear();
        this.recipesBySkill.clear();
        Set<String> set = ResourceManager.getResourcesInDirectory("recipes");
        for (String object : set) {
            String string = ResourceManager.getResourceIDNoPath(object, ResourceType.JSON);
            if (string == null) continue;
            try {
                Recipe recipe = new Recipe(string, new SimpleJSONParser(object));
                this.recipes.put(string, recipe);
                List<String> list = this.recipesBySkill.get(recipe.getSkill().getID());
                if (list == null) {
                    list = new ArrayList<String>();
                    this.recipesBySkill.put(recipe.getSkill().getID(), list);
                }
                list.add(string);
                if (!recipe.isResultIngredient()) continue;
                for (EquippableItemTemplate.Type type : recipe.getIngredientItemTypes()) {
                    List<String> list2 = this.enchantmentsByItemType.get((Object)type);
                    if (list2 == null) {
                        list2 = new ArrayList<String>();
                        this.enchantmentsByItemType.put(type, list2);
                    }
                    list2.add(string);
                }
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error loading recipe " + string, exception);
            }
        }
        for (String string : this.recipesBySkill.keySet()) {
            ((ArrayList)this.recipesBySkill.get(string)).trimToSize();
            Collections.sort(this.recipesBySkill.get(string), new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    Recipe recipe = (Recipe)RecipeManager.this.recipes.get(string);
                    Recipe recipe2 = (Recipe)RecipeManager.this.recipes.get(string2);
                    return recipe.getSkillRankRequirement() - recipe2.getSkillRankRequirement();
                }
            });
        }
        for (EquippableItemTemplate.Type type : this.enchantmentsByItemType.keySet()) {
            ((ArrayList)this.enchantmentsByItemType.get((Object)type)).trimToSize();
        }
    }

    public Set<String> getAllRecipeIDs() {
        return Collections.unmodifiableSet(this.recipes.keySet());
    }

    public List<String> getRecipeIDsForSkill(Skill skill) {
        List<String> list = this.recipesBySkill.get(skill.getID());
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }

    public List<String> getEnchantmentsForItemType(EquippableItemTemplate.Type type) {
        List<String> list = this.enchantmentsByItemType.get((Object)type);
        if (list == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(list);
    }
}

