/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.CreatedItemModel;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItem;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.PC;
import net.sf.hale.icon.Icon;
import net.sf.hale.icon.IconFactory;
import net.sf.hale.rules.Quality;
import net.sf.hale.rules.Skill;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Recipe
implements Iterable<Ingredient> {
    private final String id;
    private final String name;
    private final String description;
    private final List<Ingredient> ingredients;
    private final List<EquippableItemTemplate.Type> ingredientItemTypes;
    private final String result;
    private final int resultQuantity;
    private final String resultPrefix;
    private final String resultPostfix;
    private final Icon resultOverlayIcon;
    private final Skill skill;
    private final int skillRankRequirement;
    private final List<LevelModifier> levelModifiers;

    public Recipe(String string, SimpleJSONParser simpleJSONParser) {
        this.id = string;
        this.name = simpleJSONParser.get("name", string);
        this.description = simpleJSONParser.get("description", null);
        this.skill = Game.ruleset.getSkill(simpleJSONParser.get("skill", null));
        this.skillRankRequirement = simpleJSONParser.get("skillRankRequirement", 0);
        this.ingredients = new ArrayList<Ingredient>();
        SimpleJSONObject simpleJSONObject = simpleJSONParser.getObject("ingredients");
        for (String object2 : simpleJSONObject.keySet()) {
            int n = simpleJSONObject.get(object2, 0);
            this.ingredients.add(new Ingredient(object2, n));
        }
        SimpleJSONObject simpleJSONObject2 = simpleJSONParser.getObject("result");
        if (simpleJSONObject2.containsKey("id")) {
            this.result = simpleJSONObject2.get("id", null);
            this.resultQuantity = simpleJSONObject2.get("quantity", 0);
            this.ingredientItemTypes = Collections.emptyList();
            this.resultPostfix = null;
            this.resultPrefix = null;
            this.resultOverlayIcon = null;
        } else {
            this.result = null;
            this.resultQuantity = 0;
            this.resultPostfix = simpleJSONObject2.containsKey("postfix") ? simpleJSONObject2.get("postfix", null) : "";
            this.resultPrefix = simpleJSONObject2.containsKey("prefix") ? simpleJSONObject2.get("prefix", null) : "";
            this.resultOverlayIcon = simpleJSONObject2.containsKey("overlayIcon") ? IconFactory.createIcon(simpleJSONObject2.getObject("overlayIcon")) : IconFactory.emptyIcon;
            ArrayList<EquippableItemTemplate.Type> arrayList = new ArrayList<EquippableItemTemplate.Type>();
            SimpleJSONArray simpleJSONArray = simpleJSONObject2.getArray("ingredientItemTypes");
            for (Object object2 : simpleJSONArray) {
                String string2 = ((SimpleJSONArrayEntry)object2).getString();
                EquippableItemTemplate.Type type = EquippableItemTemplate.Type.valueOf(string2);
                arrayList.add(type);
            }
            this.ingredientItemTypes = Collections.unmodifiableList(arrayList);
        }
        if (simpleJSONObject2.containsKey("levels")) {
            this.levelModifiers = new ArrayList<LevelModifier>();
            SimpleJSONArray simpleJSONArray = simpleJSONObject2.getArray("levels");
            for (Object object : simpleJSONArray) {
                Object object2;
                object2 = ((SimpleJSONArrayEntry)object).getObject();
                this.levelModifiers.add(new LevelModifier((SimpleJSONObject)object2));
            }
        } else {
            this.levelModifiers = Collections.emptyList();
        }
        simpleJSONParser.warnOnUnusedKeys();
    }

    public String getID() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getResultID() {
        return this.result;
    }

    public int getResultQuantity() {
        return this.resultQuantity;
    }

    public Skill getSkill() {
        return this.skill;
    }

    public int getSkillRankRequirement() {
        return this.skillRankRequirement;
    }

    public List<EquippableItemTemplate.Type> getIngredientItemTypes() {
        return this.ingredientItemTypes;
    }

    public boolean isResultIngredient() {
        return !this.ingredientItemTypes.isEmpty();
    }

    public boolean isIngredient(String string) {
        for (Ingredient ingredient : this.ingredients) {
            if (!ingredient.itemID.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean canCraft() {
        for (Ingredient ingredient : this.ingredients) {
            if (Game.curCampaign.party.hasItem(ingredient.itemID, ingredient.quantity)) continue;
            return false;
        }
        return true;
    }

    private void removeIngredients() {
        for (Ingredient ingredient : this.ingredients) {
            Game.curCampaign.party.removeItem(ingredient.itemID, ingredient.quantity);
        }
    }

    private LevelModifier findLevelModifier(int n) {
        if (this.levelModifiers.size() == 0) {
            return new LevelModifier();
        }
        LevelModifier levelModifier = this.levelModifiers.get(0);
        for (int i = 1; i < this.levelModifiers.size(); ++i) {
            LevelModifier levelModifier2 = this.levelModifiers.get(i);
            if (!(levelModifier2.skillRankRequirement < n & levelModifier2.skillRankRequirement > levelModifier.skillRankRequirement)) continue;
            levelModifier = levelModifier2;
        }
        return levelModifier;
    }

    private void addMessage(Item item, int n, Creature creature, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(item.getLongName());
        stringBuilder.append(" ");
        stringBuilder.append(this.skill.getPastTenseVerb());
        stringBuilder.append(" and ");
        if (bl) {
            stringBuilder.append("equipped by ");
        } else {
            stringBuilder.append("in the inventory of ");
        }
        stringBuilder.append(creature.getTemplate().getName());
        stringBuilder.append(".");
        if (n != 1) {
            stringBuilder.insert(0, n + "x ");
        }
        Game.mainViewer.addMessage(stringBuilder.toString());
        Game.mainViewer.updateInterface();
    }

    public EquippableItem createItem(String string, Quality quality, int n) {
        if (!this.isResultIngredient()) {
            throw new IllegalArgumentException("Cannot create an item by modification for recipe " + this.getID());
        }
        LevelModifier levelModifier = this.findLevelModifier(n);
        Quality quality2 = quality == null || levelModifier.quality == null ? quality : levelModifier.quality;
        String string2 = string + "-0x" + Integer.toHexString(levelModifier.enchantment.hashCode());
        if (!EntityManager.hasEntityTemplate(string2)) {
            CreatedItemModel createdItemModel = new CreatedItemModel(string, string2);
            if (levelModifier.enchantment != null) {
                createdItemModel.addEnchantment(levelModifier.enchantment);
            }
            createdItemModel.setNamePostfix(this.resultPostfix);
            createdItemModel.setNamePrefix(this.resultPrefix);
            createdItemModel.setValueModifier(levelModifier.valueModifier);
            createdItemModel.setOverlayIcon(this.resultOverlayIcon);
            CreatedItem createdItem = createdItemModel.getCreatedItem();
            Game.curCampaign.addCreatedItem(createdItem);
        }
        return (EquippableItem)EntityManager.getItem(string2, quality2);
    }

    public void craft(Item item, Creature creature, Inventory.Slot slot) {
        if (!this.isResultIngredient()) {
            throw new IllegalArgumentException("Must not call craft with a specified item for recipe " + this.getID());
        }
        EquippableItem equippableItem = this.createItem(item.getTemplate().getID(), item.getQuality(), Game.curCampaign.getBestPartySkillModifier(this.skill.getID()));
        this.removeIngredients();
        if (slot != null) {
            creature.inventory.removeEquippedItem(slot);
            creature.inventory.addAndEquip(equippableItem, slot);
        } else {
            creature.inventory.getUnequippedItems().remove(item);
            creature.inventory.getUnequippedItems().add(equippableItem);
        }
        this.addMessage(item, 1, creature, slot != null);
    }

    public void craft() {
        if (!this.canCraft()) {
            return;
        }
        if (this.isResultIngredient()) {
            throw new IllegalArgumentException("Must call craft with a specified item for recipe " + this.id);
        }
        PC pC = Game.curCampaign.party.getSelected();
        this.removeIngredients();
        LevelModifier levelModifier = this.findLevelModifier(Game.curCampaign.getBestPartySkillModifier(this.skill.getID()));
        Item item = levelModifier.quality == null ? EntityManager.getItem(this.result) : EntityManager.getItem(this.result, levelModifier.quality);
        int n = Math.max(1, this.resultQuantity);
        pC.inventory.getUnequippedItems().add(item, n);
        this.addMessage(item, n, pC, false);
    }

    @Override
    public Iterator<Ingredient> iterator() {
        return new IngredientIterator();
    }

    private class IngredientIterator
    implements Iterator<Ingredient> {
        private int index = 0;

        private IngredientIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Recipe.this.ingredients.size();
        }

        @Override
        public Ingredient next() {
            Ingredient ingredient = (Ingredient)Recipe.this.ingredients.get(this.index);
            ++this.index;
            return ingredient;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Ingredients may not be removed from recipes");
        }
    }

    private class LevelModifier {
        private final Quality quality;
        private final int skillRankRequirement;
        private final String enchantment;
        private final int valueModifier;

        private LevelModifier(SimpleJSONObject simpleJSONObject) {
            this.quality = simpleJSONObject.containsKey("quality") ? Game.ruleset.getItemQuality(simpleJSONObject.get("quality", null)) : null;
            this.skillRankRequirement = simpleJSONObject.get("skillRankRequirement", 0);
            this.enchantment = simpleJSONObject.containsKey("enchantment") ? simpleJSONObject.get("enchantment", null) : null;
            this.valueModifier = simpleJSONObject.containsKey("valueModifier") ? simpleJSONObject.get("valueModifier", 100) : 100;
        }

        private LevelModifier() {
            this.quality = null;
            this.skillRankRequirement = 0;
            this.enchantment = null;
            this.valueModifier = 100;
        }
    }

    public class Ingredient {
        private final String itemID;
        private final int quantity;

        private Ingredient(String string, int n) {
            this.itemID = string;
            this.quantity = n;
        }

        public String getItemID() {
            return this.itemID;
        }

        public int getQuantity() {
            return this.quantity;
        }
    }
}

