/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.ability.AbilitySelectionList;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.Weapon;
import net.sf.hale.entity.WeaponTemplate;
import net.sf.hale.icon.SubIcon;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.RacialType;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Race {
    private final String id;
    private final String name;
    private final String icon;
    private final int movementCost;
    private final WeaponTemplate defaultWeapon;
    private final boolean playerSelectable;
    private final List<RacialType> racialTypes;
    private final String descriptionFile;
    private final String maleForegroundIcon;
    private final String maleBackgroundIcon;
    private final String maleEarsIcon;
    private final String femaleForegroundIcon;
    private final String femaleBackgroundIcon;
    private final String femaleEarsIcon;
    private final String maleClothesIcon;
    private final String femaleClothesIcon;
    private final Map<Integer, List<String>> abilitySelectionLists;
    private final Map<SubIcon.Type, Point> iconOffsets;
    private final List<String> abilities;
    private final List<String> randomMaleNames;
    private final List<String> randomFemaleNames;
    private final int baseStr;
    private final int baseDex;
    private final int baseCon;
    private final int baseInt;
    private final int baseWis;
    private final int baseCha;
    private final boolean showDetailedDescription;

    public Race(String string) {
        int n;
        Object object;
        Object object2;
        Object object3;
        Iterator<Object> iterator;
        Object object5;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("races/" + string, ResourceType.JSON);
        this.id = string;
        this.name = simpleJSONParser.get("name", string);
        String string2 = simpleJSONParser.get("defaultWeapon", null);
        this.defaultWeapon = (WeaponTemplate)EntityManager.getItemTemplate(string2);
        simpleJSONParser.setWarnOnMissingKeys(false);
        this.movementCost = simpleJSONParser.get("baseMovementCost", 1000);
        this.descriptionFile = simpleJSONParser.get("descriptionFile", "descriptions/races/" + this.name + ResourceType.HTML.getExtension());
        this.icon = simpleJSONParser.get("icon", null);
        this.playerSelectable = simpleJSONParser.get("playerSelectable", false);
        this.showDetailedDescription = simpleJSONParser.get("showDetailedDescription", true);
        if (simpleJSONParser.containsKey("baseAttributes")) {
            object5 = simpleJSONParser.getArray("baseAttributes");
            iterator = ((SimpleJSONArray)object5).iterator();
            this.baseStr = iterator.next().getInt(10);
            this.baseDex = iterator.next().getInt(10);
            this.baseCon = iterator.next().getInt(10);
            this.baseInt = iterator.next().getInt(10);
            this.baseWis = iterator.next().getInt(10);
            this.baseCha = iterator.next().getInt(10);
        } else {
            this.baseStr = 10;
            this.baseDex = 10;
            this.baseCon = 10;
            this.baseInt = 10;
            this.baseWis = 10;
            this.baseCha = 10;
        }
        this.abilities = new ArrayList<String>();
        if (simpleJSONParser.containsKey("abilities")) {
            object5 = simpleJSONParser.getArray("abilities");
            iterator = ((SimpleJSONArray)object5).iterator();
            while (iterator.hasNext()) {
                SimpleJSONArrayEntry object42 = iterator.next();
                this.abilities.add(object42.getString());
            }
        }
        ((ArrayList)this.abilities).trimToSize();
        this.racialTypes = new ArrayList<RacialType>();
        if (simpleJSONParser.containsKey("racialTypes")) {
            object5 = simpleJSONParser.getArray("racialTypes");
            iterator = ((SimpleJSONArray)object5).iterator();
            while (iterator.hasNext()) {
                SimpleJSONArrayEntry simpleJSONArrayEntry = iterator.next();
                this.racialTypes.add(Game.ruleset.getRacialType(simpleJSONArrayEntry.getString()));
            }
        }
        ((ArrayList)this.racialTypes).trimToSize();
        if (simpleJSONParser.containsKey("icons")) {
            object5 = simpleJSONParser.getObject("icons");
            this.maleBackgroundIcon = ((SimpleJSONObject)object5).get("maleBackground", null);
            this.maleForegroundIcon = ((SimpleJSONObject)object5).get("maleForeground", null);
            this.maleEarsIcon = ((SimpleJSONObject)object5).get("maleEars", null);
            this.femaleBackgroundIcon = ((SimpleJSONObject)object5).get("femaleBackground", null);
            this.femaleForegroundIcon = ((SimpleJSONObject)object5).get("femaleForeground", null);
            this.femaleEarsIcon = ((SimpleJSONObject)object5).get("femaleEars", null);
            this.maleClothesIcon = ((SimpleJSONObject)object5).get("maleClothes", null);
            this.femaleClothesIcon = ((SimpleJSONObject)object5).get("femaleClothes", null);
        } else {
            this.maleBackgroundIcon = null;
            this.maleForegroundIcon = null;
            this.maleEarsIcon = null;
            this.femaleBackgroundIcon = null;
            this.femaleForegroundIcon = null;
            this.femaleEarsIcon = null;
            this.maleClothesIcon = null;
            this.femaleClothesIcon = null;
        }
        this.iconOffsets = new HashMap<SubIcon.Type, Point>();
        if (simpleJSONParser.containsKey("iconOffsets")) {
            object5 = simpleJSONParser.getObject("iconOffsets");
            for (String string3 : ((SimpleJSONObject)object5).keySet()) {
                object3 = SubIcon.Type.valueOf(string3);
                object2 = ((SimpleJSONObject)object5).getArray(string3);
                object = ((SimpleJSONArray)object2).iterator();
                n = object.next().getInt(0);
                int n2 = object.next().getInt(0);
                this.iconOffsets.put((SubIcon.Type)((Object)object3), new Point(n, n2));
            }
        }
        this.abilitySelectionLists = new HashMap<Integer, List<String>>();
        if (simpleJSONParser.containsKey("abilitySelectionsFromList")) {
            object5 = simpleJSONParser.getObject("abilitySelectionsFromList");
            for (String string4 : ((SimpleJSONObject)object5).keySet()) {
                object3 = ((SimpleJSONObject)object5).getArray(string4);
                object2 = ((SimpleJSONArray)object3).iterator();
                while (object2.hasNext()) {
                    object = (SimpleJSONArrayEntry)object2.next();
                    n = ((SimpleJSONArrayEntry)object).getInt(0);
                    this.addAbilitySelectionListAtLevel(string4, n);
                }
            }
        }
        this.randomMaleNames = new ArrayList<String>();
        if (simpleJSONParser.containsKey("randomMaleNames")) {
            object5 = simpleJSONParser.getArray("randomMaleNames");
            iterator = ((SimpleJSONArray)object5).iterator();
            while (iterator.hasNext()) {
                SimpleJSONArrayEntry simpleJSONArrayEntry = (SimpleJSONArrayEntry)iterator.next();
                this.randomMaleNames.add(simpleJSONArrayEntry.getString());
            }
        }
        ((ArrayList)this.randomMaleNames).trimToSize();
        this.randomFemaleNames = new ArrayList<String>();
        if (simpleJSONParser.containsKey("randomFemaleNames")) {
            object5 = simpleJSONParser.getArray("randomFemaleNames");
            iterator = ((SimpleJSONArray)object5).iterator();
            while (iterator.hasNext()) {
                SimpleJSONArrayEntry simpleJSONArrayEntry = (SimpleJSONArrayEntry)iterator.next();
                this.randomFemaleNames.add(simpleJSONArrayEntry.getString());
            }
        }
        ((ArrayList)this.randomFemaleNames).trimToSize();
        simpleJSONParser.warnOnUnusedKeys();
    }

    private void addAbilitySelectionListAtLevel(String string, int n) {
        List<String> list = this.abilitySelectionLists.get(n);
        if (list == null) {
            list = new ArrayList<String>(1);
            this.abilitySelectionLists.put(n, list);
        }
        list.add(string);
    }

    public boolean drawsSubIconType(SubIcon.Type type) {
        return this.iconOffsets.containsKey((Object)type);
    }

    public Point getIconOffset(SubIcon.Type type) {
        if (!this.iconOffsets.containsKey((Object)type)) {
            this.iconOffsets.put(type, new Point(0, 0));
        }
        return new Point(this.iconOffsets.get((Object)type));
    }

    private String getRandomFromList(List<String> list) {
        switch (list.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return list.get(0);
            }
        }
        return list.get(Game.dice.rand(0, list.size() - 1));
    }

    public String getRandomMaleName() {
        return this.getRandomFromList(this.randomMaleNames);
    }

    public String getRandomFemaleName() {
        return this.getRandomFromList(this.randomFemaleNames);
    }

    public boolean showDetailedDescription() {
        return this.showDetailedDescription;
    }

    public String getMaleClothesIcon() {
        return this.maleClothesIcon;
    }

    public String getFemaleClothesIcon() {
        return this.femaleClothesIcon;
    }

    public String getFemaleEarsIcon() {
        return this.femaleEarsIcon;
    }

    public String getFemaleForegroundIcon() {
        return this.femaleForegroundIcon;
    }

    public String getFemaleBackgroundIcon() {
        return this.femaleBackgroundIcon;
    }

    public String getMaleEarsIcon() {
        return this.maleEarsIcon;
    }

    public String getMaleForegroundIcon() {
        return this.maleForegroundIcon;
    }

    public String getMaleBackgroundIcon() {
        return this.maleBackgroundIcon;
    }

    public String getDescriptionFile() {
        return ResourceManager.getResourceAsString(this.descriptionFile);
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getMovementCost() {
        return this.movementCost;
    }

    public boolean isPlayerSelectable() {
        return this.playerSelectable;
    }

    public int getBaseStr() {
        return this.baseStr;
    }

    public int getBaseDex() {
        return this.baseDex;
    }

    public int getBaseCon() {
        return this.baseCon;
    }

    public int getBaseInt() {
        return this.baseInt;
    }

    public int getBaseWis() {
        return this.baseWis;
    }

    public int getBaseCha() {
        return this.baseCha;
    }

    public boolean hasRacialType(String string) {
        for (RacialType racialType : this.racialTypes) {
            if (!racialType.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public List<AbilitySelectionList> getAbilitySelectionsAddedAtLevel(int n) {
        List<String> list = this.abilitySelectionLists.get(n);
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<AbilitySelectionList> arrayList = new ArrayList<AbilitySelectionList>(list.size());
        for (String string : list) {
            arrayList.add(Game.ruleset.getAbilitySelectionList(string));
        }
        return arrayList;
    }

    public List<RacialType> getRacialTypes() {
        return new ArrayList<RacialType>(this.racialTypes);
    }

    public void addAbilitiesToCreature(Creature creature) {
        for (String string : this.abilities) {
            Ability ability = Game.ruleset.getAbility(string);
            if (ability == null) {
                Logger.appendToWarningLog("Racial ability " + string + " for race " + this.id + " not found.");
                continue;
            }
            creature.abilities.addRacialAbility(ability);
        }
    }

    public Set<AbilitySelectionList> getAllReferencedAbilitySelectionLists() {
        LinkedHashSet<AbilitySelectionList> linkedHashSet = new LinkedHashSet<AbilitySelectionList>();
        for (int n : this.abilitySelectionLists.keySet()) {
            for (String string : this.abilitySelectionLists.get(n)) {
                AbilitySelectionList abilitySelectionList = Game.ruleset.getAbilitySelectionList(string);
                linkedHashSet.add(abilitySelectionList);
            }
        }
        return linkedHashSet;
    }

    public Weapon getDefaultWeapon() throws IllegalStateException {
        try {
            return (Weapon)EntityManager.getItem(this.defaultWeapon.getID(), this.defaultWeapon.getDefaultQuality());
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error creating default weapon for race " + this.id, exception);
        }
    }
}

