/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.util.SimpleJSONObject;

public class QuestSubEntry
implements Saveable {
    private boolean completed;
    private boolean showTitle;
    private String title;
    private StringBuilder description;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("title", this.title);
        jSONOrderedObject.put("showTitle", this.showTitle);
        jSONOrderedObject.put("completed", this.completed);
        jSONOrderedObject.put("description", this.description.toString());
        return jSONOrderedObject;
    }

    public static QuestSubEntry load(SimpleJSONObject simpleJSONObject) {
        QuestSubEntry questSubEntry = new QuestSubEntry(simpleJSONObject.get("title", null));
        questSubEntry.showTitle = simpleJSONObject.get("showTitle", false);
        questSubEntry.completed = simpleJSONObject.get("completed", false);
        String string = simpleJSONObject.get("description", null);
        questSubEntry.description.append(string);
        return questSubEntry;
    }

    public QuestSubEntry(String string) {
        this.title = string;
        this.description = new StringBuilder();
        this.completed = false;
        this.showTitle = true;
    }

    public void setShowTitle(boolean bl) {
        this.showTitle = bl;
    }

    public boolean showTitle() {
        return this.showTitle;
    }

    public void setCompleted() {
        this.completed = true;
    }

    public void addExternalText(String string) {
        this.description.append(ResourceManager.getResourceAsString(string));
    }

    public void addText(String string) {
        this.description.append(string);
        this.description.append("  ");
    }

    public void clearText() {
        this.description = new StringBuilder();
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description.toString();
    }

    public String toString() {
        return this.title;
    }
}

