/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.rules.QuestEntry;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class QuestEntryList
implements Saveable {
    private final Map<String, QuestEntry> activeEntries = new LinkedHashMap<String, QuestEntry>();
    private final Map<String, QuestEntry> completedEntries = new LinkedHashMap<String, QuestEntry>();

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        Object[] objectArray = new Object[this.activeEntries.size()];
        int n = 0;
        for (String object : this.activeEntries.keySet()) {
            objectArray[n] = this.activeEntries.get(object).save();
            ++n;
        }
        jSONOrderedObject.put("activeEntries", objectArray);
        Object[] objectArray2 = new Object[this.completedEntries.size()];
        n = 0;
        for (String string : this.completedEntries.keySet()) {
            objectArray2[n] = this.completedEntries.get(string).save();
            ++n;
        }
        jSONOrderedObject.put("completedEntries", objectArray2);
        return jSONOrderedObject;
    }

    public static QuestEntryList load(SimpleJSONObject simpleJSONObject) {
        QuestEntry questEntry;
        SimpleJSONObject simpleJSONObject2;
        QuestEntryList questEntryList = new QuestEntryList();
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("activeEntries")) {
            simpleJSONObject2 = simpleJSONArrayEntry.getObject();
            questEntry = QuestEntry.load(simpleJSONObject2);
            questEntryList.activeEntries.put(questEntry.getTitle(), questEntry);
        }
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONObject.getArray("completedEntries")) {
            simpleJSONObject2 = simpleJSONArrayEntry.getObject();
            questEntry = QuestEntry.load(simpleJSONObject2);
            questEntryList.completedEntries.put(questEntry.getTitle(), questEntry);
        }
        return questEntryList;
    }

    public void addEntry(QuestEntry questEntry) {
        if (this.hasEntry(questEntry)) {
            Logger.appendToErrorLog("Attempted to add entry with duplicate title " + questEntry.getTitle());
            return;
        }
        if (questEntry.isCompleted()) {
            this.addCompleted(questEntry);
        } else {
            this.addActive(questEntry);
        }
    }

    public QuestEntry getEntry(String string) {
        if (this.activeEntries.containsKey(string)) {
            return this.activeEntries.get(string);
        }
        return this.completedEntries.get(string);
    }

    public boolean hasEntry(String string) {
        if (this.activeEntries.containsKey(string)) {
            return true;
        }
        return this.completedEntries.containsKey(string);
    }

    public boolean hasEntry(QuestEntry questEntry) {
        return this.hasEntry(questEntry.getTitle());
    }

    public void setCompleted(QuestEntry questEntry) {
        if (this.activeEntries.containsKey(questEntry.getTitle())) {
            this.removeActive(questEntry);
            this.addCompleted(questEntry);
        }
    }

    private void addCompleted(QuestEntry questEntry) {
        this.completedEntries.put(questEntry.getTitle(), questEntry);
    }

    private void addActive(QuestEntry questEntry) {
        this.activeEntries.put(questEntry.getTitle(), questEntry);
    }

    private void removeActive(QuestEntry questEntry) {
        this.activeEntries.remove(questEntry.getTitle());
    }

    public Collection<QuestEntry> getCompletedEntries() {
        return Collections.unmodifiableCollection(this.completedEntries.values());
    }

    public Collection<QuestEntry> getActiveEntries() {
        return Collections.unmodifiableCollection(this.activeEntries.values());
    }
}

