/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.rules.QuestSubEntry;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class QuestEntry
implements Iterable<QuestSubEntry>,
Saveable {
    private boolean completed;
    private boolean showLogNotifications;
    private final Map<String, QuestSubEntry> subEntries;
    private final LinkedList<QuestSubEntry> subEntriesList;
    private final String title;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("title", this.title);
        jSONOrderedObject.put("completed", this.completed);
        jSONOrderedObject.put("showLogNotifications", this.showLogNotifications);
        int n = 0;
        Object[] objectArray = new Object[this.subEntriesList.size()];
        for (QuestSubEntry questSubEntry : this.subEntriesList) {
            objectArray[n] = questSubEntry.save();
            ++n;
        }
        jSONOrderedObject.put("subEntries", objectArray);
        return jSONOrderedObject;
    }

    public static QuestEntry load(SimpleJSONObject simpleJSONObject) {
        QuestEntry questEntry = new QuestEntry(simpleJSONObject.get("title", null));
        questEntry.completed = simpleJSONObject.get("completed", false);
        questEntry.showLogNotifications = simpleJSONObject.get("showLogNotifications", false);
        for (SimpleJSONArrayEntry object : simpleJSONObject.getArray("subEntries")) {
            SimpleJSONObject simpleJSONObject2 = object.getObject();
            QuestSubEntry questSubEntry = QuestSubEntry.load(simpleJSONObject2);
            questEntry.subEntriesList.add(questSubEntry);
        }
        for (QuestSubEntry questSubEntry : questEntry.subEntriesList) {
            questEntry.subEntries.put(questSubEntry.getTitle(), questSubEntry);
        }
        return questEntry;
    }

    public QuestEntry(String string) {
        this.title = string;
        this.completed = false;
        this.showLogNotifications = true;
        this.subEntries = new HashMap<String, QuestSubEntry>();
        this.subEntriesList = new LinkedList();
    }

    public boolean showsLogNotifications() {
        return this.showLogNotifications;
    }

    public void setShowLogNotifications(boolean bl) {
        this.showLogNotifications = bl;
    }

    public void setCompleted() {
        this.completed = true;
        Game.curCampaign.questEntries.setCompleted(this);
    }

    public synchronized void setCurrentSubEntriesCompleted() {
        for (String string : this.subEntries.keySet()) {
            this.subEntries.get(string).setCompleted();
        }
    }

    public boolean hasSubEntry(String string) {
        return this.subEntries.containsKey(string);
    }

    public QuestSubEntry getSubEntry(String string) {
        return this.subEntries.get(string);
    }

    public synchronized QuestSubEntry createSubEntry(String string) {
        QuestSubEntry questSubEntry = new QuestSubEntry(string);
        this.subEntries.put(questSubEntry.getTitle(), questSubEntry);
        this.subEntriesList.add(questSubEntry);
        Game.mainViewer.setNewQuestEntry(this);
        Game.mainViewer.updateInterface();
        return questSubEntry;
    }

    public int getNumSubEntries() {
        return this.subEntriesList.size();
    }

    public QuestSubEntry getMostRecentSubEntry() {
        return this.subEntriesList.getLast();
    }

    @Override
    public Iterator<QuestSubEntry> iterator() {
        return new EntryIterator();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String toString() {
        return this.title;
    }

    private class EntryIterator
    implements Iterator<QuestSubEntry> {
        private Iterator<QuestSubEntry> iter;

        private EntryIterator() {
            this.iter = QuestEntry.this.subEntriesList.descendingIterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public QuestSubEntry next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove a sub entry from a quest entry.");
        }
    }
}

