/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.ability.Ability;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Creature;
import net.sf.hale.rules.Role;
import net.sf.hale.rules.Skill;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;

public class PrereqList {
    private final Map<String, Integer> skillPrereqs = new HashMap<String, Integer>();
    private final List<String> abilityPrereqs = new ArrayList<String>();
    private final Map<Stat, Integer> statPrereqs = new HashMap<Stat, Integer>();
    private final List<String> weaponProficiencyPrereqs = new ArrayList<String>();
    private final List<String> armorProficiencyPrereqs = new ArrayList<String>();
    private final List<String> rolePrereqs = new ArrayList<String>();
    private final List<Integer> roleLevelPrereqs = new ArrayList<Integer>();

    public PrereqList() {
    }

    public PrereqList(SimpleJSONObject simpleJSONObject) {
        this();
        for (PrereqType prereqType : PrereqType.values()) {
            if (!simpleJSONObject.containsKey(prereqType.name())) continue;
            prereqType.parse(simpleJSONObject.getArray(prereqType.name()), this);
        }
    }

    public boolean hasRolePrereqs(Creature creature) {
        if (this.rolePrereqs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.rolePrereqs.size(); ++i) {
            Role role = Game.ruleset.getRole(this.rolePrereqs.get(i));
            if (role == null || creature.roles.getLevel(role) < 1) continue;
            return true;
        }
        return false;
    }

    public boolean meetsRolePrereqs(Creature creature) {
        if (this.rolePrereqs.size() == 0) {
            return true;
        }
        for (int i = 0; i < this.rolePrereqs.size(); ++i) {
            Role role = Game.ruleset.getRole(this.rolePrereqs.get(i));
            int n = this.roleLevelPrereqs.get(i);
            if (role == null || creature.roles.getLevel(role) < n) continue;
            return true;
        }
        return false;
    }

    public boolean meetsPrereqs(Creature creature) {
        for (Stat object : this.statPrereqs.keySet()) {
            if (this.meetsStatPrereq(creature, object)) continue;
            return false;
        }
        for (String string : this.skillPrereqs.keySet()) {
            if (this.meetsSkillPrereq(creature, string)) continue;
            return false;
        }
        if (!this.meetsRolePrereqs(creature)) {
            return false;
        }
        for (String string : this.abilityPrereqs) {
            if (this.meetsAbilityPrereq(creature, string)) continue;
            return false;
        }
        for (String string : this.weaponProficiencyPrereqs) {
            if (this.meetsWeaponProficiencyPrereq(creature, string)) continue;
            return false;
        }
        for (String string : this.armorProficiencyPrereqs) {
            if (this.meetsArmorProficiencyPrereq(creature, string)) continue;
            return false;
        }
        return true;
    }

    private boolean meetsStatPrereq(Creature creature, Stat stat) {
        return creature.stats.get(stat) >= this.statPrereqs.get((Object)stat);
    }

    private boolean meetsSkillPrereq(Creature creature, String string) {
        return creature.skills.getRanks(string) >= this.skillPrereqs.get(string);
    }

    private boolean meetsAbilityPrereq(Creature creature, String string) {
        return creature.abilities.has(string);
    }

    private boolean meetsWeaponProficiencyPrereq(Creature creature, String string) {
        return creature.stats.hasWeaponProficiency(string);
    }

    private boolean meetsArmorProficiencyPrereq(Creature creature, String string) {
        return creature.stats.hasArmorProficiency(string);
    }

    public boolean isEmpty() {
        if (!this.weaponProficiencyPrereqs.isEmpty()) {
            return false;
        }
        if (!this.armorProficiencyPrereqs.isEmpty()) {
            return false;
        }
        if (!this.abilityPrereqs.isEmpty()) {
            return false;
        }
        if (!this.rolePrereqs.isEmpty()) {
            return false;
        }
        if (!this.statPrereqs.isEmpty()) {
            return false;
        }
        return this.skillPrereqs.size() == 0;
    }

    private void appendMetOrNotMet(Creature creature, boolean bl, StringBuilder stringBuilder) {
        stringBuilder.append("<tr><td style=\"width: 10ex; text-align: center; vertical-align: middle\">");
        if (creature != null) {
            if (bl) {
                stringBuilder.append("<span style=\"font-family: green;\">Met </span>");
            } else {
                stringBuilder.append("<span style=\"font-family: red;\">Not Met </span>");
            }
        }
        stringBuilder.append("</td><td>");
    }

    public void appendDescription(StringBuilder stringBuilder, Creature creature) {
        Object object;
        if (this.isEmpty()) {
            return;
        }
        stringBuilder.append("<div style=\"font-family: medium-bold-blue; margin-top : 1em;\">Prerequisites</div>");
        stringBuilder.append("<table>");
        for (Stat object2 : this.statPrereqs.keySet()) {
            this.appendMetOrNotMet(creature, creature != null && this.meetsStatPrereq(creature, object2), stringBuilder);
            stringBuilder.append("<span style=\"font-family: purple;\">").append(object2.name);
            stringBuilder.append("</span> ").append(this.statPrereqs.get((Object)object2)).append("</td></tr>");
        }
        for (String string : this.skillPrereqs.keySet()) {
            object = Game.ruleset.getSkill(string);
            if (object == null) {
                throw new NullPointerException("Skill " + string + " not found in prereq list.");
            }
            this.appendMetOrNotMet(creature, creature != null && this.meetsSkillPrereq(creature, string), stringBuilder);
            stringBuilder.append(this.skillPrereqs.get(string));
            stringBuilder.append(" ranks in <span style=\"font-family: blue;\">");
            stringBuilder.append(((Skill)object).getNoun()).append("</span></td></tr>");
        }
        if (this.rolePrereqs.size() > 0) {
            this.appendMetOrNotMet(creature, creature != null && this.meetsRolePrereqs(creature), stringBuilder);
        }
        for (int i = 0; i < this.rolePrereqs.size(); ++i) {
            Role role = Game.ruleset.getRole(this.rolePrereqs.get(i));
            if (role == null) {
                throw new NullPointerException("Role " + this.rolePrereqs.get(i) + " not found in prereq list");
            }
            stringBuilder.append("Level <span style=\"font-family: red;\">");
            stringBuilder.append(this.roleLevelPrereqs.get(i)).append("</span> in ");
            stringBuilder.append("<span style=\"font-family: blue;\">");
            stringBuilder.append(role.getName()).append("</span>");
            if (i != this.rolePrereqs.size() - 1) {
                stringBuilder.append(" OR ");
                continue;
            }
            stringBuilder.append("</td></tr>");
        }
        for (String string : this.abilityPrereqs) {
            object = Game.ruleset.getAbility(string);
            if (object == null) {
                throw new NullPointerException("Ability " + string + " not found in prereq list.");
            }
            this.appendMetOrNotMet(creature, creature != null && this.meetsAbilityPrereq(creature, string), stringBuilder);
            stringBuilder.append("Ability: ");
            stringBuilder.append("<span style=\"font-family: orange;\">");
            stringBuilder.append(((Ability)object).getName()).append("</span></td></tr>");
        }
        for (String string : this.weaponProficiencyPrereqs) {
            this.appendMetOrNotMet(creature, creature != null && this.meetsWeaponProficiencyPrereq(creature, string), stringBuilder);
            stringBuilder.append("<p>Weapon Proficiency: ");
            stringBuilder.append("<span style=\"font-family: red;\">").append(string).append("</span></td></tr>");
        }
        for (String string : this.armorProficiencyPrereqs) {
            this.appendMetOrNotMet(creature, creature != null && this.meetsArmorProficiencyPrereq(creature, string), stringBuilder);
            stringBuilder.append("<p>Armor Proficiency: ");
            stringBuilder.append("<span style=\"font-family: green;\">").append(string).append("</span></td></tr>");
        }
        stringBuilder.append("</table>");
    }

    private static class SkillParser
    implements PrereqParser {
        private SkillParser() {
        }

        @Override
        public void parse(SimpleJSONArrayEntry simpleJSONArrayEntry, PrereqList prereqList) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            prereqList.skillPrereqs.put(simpleJSONObject.get("id", null), simpleJSONObject.get("ranks", 0));
        }
    }

    private static class AbilityParser
    implements PrereqParser {
        private AbilityParser() {
        }

        @Override
        public void parse(SimpleJSONArrayEntry simpleJSONArrayEntry, PrereqList prereqList) {
            prereqList.abilityPrereqs.add(simpleJSONArrayEntry.getString());
        }
    }

    private static class RoleParser
    implements PrereqParser {
        private RoleParser() {
        }

        @Override
        public void parse(SimpleJSONArrayEntry simpleJSONArrayEntry, PrereqList prereqList) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            prereqList.rolePrereqs.add(simpleJSONObject.get("id", null));
            prereqList.roleLevelPrereqs.add(simpleJSONObject.get("level", 0));
        }
    }

    private static class StatParser
    implements PrereqParser {
        private StatParser() {
        }

        @Override
        public void parse(SimpleJSONArrayEntry simpleJSONArrayEntry, PrereqList prereqList) {
            SimpleJSONObject simpleJSONObject = simpleJSONArrayEntry.getObject();
            Stat stat = Stat.valueOf(simpleJSONObject.get("type", null));
            prereqList.statPrereqs.put(stat, simpleJSONObject.get("value", 0));
        }
    }

    private static class WeaponParser
    implements PrereqParser {
        private WeaponParser() {
        }

        @Override
        public void parse(SimpleJSONArrayEntry simpleJSONArrayEntry, PrereqList prereqList) {
            prereqList.weaponProficiencyPrereqs.add(simpleJSONArrayEntry.getString());
        }
    }

    private static class ArmorParser
    implements PrereqParser {
        private ArmorParser() {
        }

        @Override
        public void parse(SimpleJSONArrayEntry simpleJSONArrayEntry, PrereqList prereqList) {
            prereqList.armorProficiencyPrereqs.add(simpleJSONArrayEntry.getString());
        }
    }

    private static interface PrereqParser {
        public void parse(SimpleJSONArrayEntry var1, PrereqList var2);
    }

    private static enum PrereqType {
        skills(new SkillParser()),
        abilities(new AbilityParser()),
        roles(new RoleParser()),
        stats(new StatParser()),
        weapons(new WeaponParser()),
        armor(new ArmorParser());

        private PrereqParser parser;

        private PrereqType(PrereqParser prereqParser) {
            this.parser = prereqParser;
        }

        private void parse(SimpleJSONArray simpleJSONArray, PrereqList prereqList) {
            for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
                this.parser.parse(simpleJSONArrayEntry, prereqList);
            }
        }
    }
}

