/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import net.sf.hale.Game;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.Item;
import net.sf.hale.entity.ItemList;
import net.sf.hale.entity.LootList;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.rules.Currency;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;

public class Merchant
implements Saveable {
    private final LootList baseItems;
    private String name;
    private int buyValuePercentage;
    private int sellValuePercentage;
    private boolean usesSpeechSkill;
    private boolean confirmOnExit;
    private int currentBuyPercentage;
    private int currentSellPercentage;
    private int respawnHours;
    private final String id;
    private int lastRespawnRounds;
    private ItemList currentItems;

    @Override
    public Object save() {
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("id", this.id);
        jSONOrderedObject.put("lastRespawnRound", this.lastRespawnRounds);
        jSONOrderedObject.put("currentItems", this.currentItems.save());
        return jSONOrderedObject;
    }

    public void load(SimpleJSONObject simpleJSONObject) {
        this.lastRespawnRounds = simpleJSONObject.get("lastRespawnRound", 0);
        this.currentItems = new ItemList();
        this.currentItems.load(simpleJSONObject.getArray("currentItems"));
    }

    public Merchant(String string) {
        this.id = string;
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("merchants/" + string, ResourceType.JSON);
        this.name = simpleJSONParser.get("name", null);
        this.sellValuePercentage = simpleJSONParser.get("sellValuePercentage", 0);
        this.buyValuePercentage = simpleJSONParser.get("buyValuePercentage", 0);
        this.usesSpeechSkill = simpleJSONParser.get("usesSpeechSkill", false);
        this.confirmOnExit = simpleJSONParser.get("confirmOnExit", false);
        this.respawnHours = simpleJSONParser.get("respawnHours", 0);
        this.baseItems = new LootList(simpleJSONParser.getArray("items"));
        simpleJSONParser.warnOnUnusedKeys();
        this.currentBuyPercentage = this.buyValuePercentage;
        this.currentSellPercentage = this.sellValuePercentage;
    }

    public ItemList getCurrentItems() {
        return this.currentItems;
    }

    public int getRespawnHours() {
        return this.respawnHours;
    }

    public LootList getBaseItems() {
        return this.baseItems;
    }

    public boolean usesSpeechSkill() {
        return this.usesSpeechSkill;
    }

    public boolean confirmOnExit() {
        return this.confirmOnExit;
    }

    private boolean checkRespawn() {
        if (this.currentItems == null) {
            return true;
        }
        if (this.respawnHours == 0) {
            return false;
        }
        int n = Game.curCampaign.getDate().getTotalRoundsElapsed();
        int n2 = n - this.lastRespawnRounds;
        return n2 >= this.respawnHours * Game.curCampaign.getDate().ROUNDS_PER_HOUR;
    }

    public ItemList updateCurrentItems() {
        if (this.checkRespawn()) {
            this.lastRespawnRounds = Game.curCampaign.getDate().getTotalRoundsElapsed();
            this.currentItems = this.baseItems.generate();
        }
        return this.currentItems;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setPartySpeech(int n) {
        if (this.usesSpeechSkill) {
            double d = -1.0 * (double)n / (double)Game.ruleset.getValue("BuySellGapSpeechExpFactor");
            double d2 = Math.exp(d);
            double d3 = (double)(this.sellValuePercentage - this.buyValuePercentage) / 2.0;
            int n2 = (int)Math.round(d3 * (1.0 - d2));
            this.currentBuyPercentage = this.buyValuePercentage + n2;
            this.currentSellPercentage = this.sellValuePercentage - n2;
        }
    }

    public void setBuyValuePercentage(int n) {
        this.buyValuePercentage = n;
    }

    public void setSellValuePercentage(int n) {
        this.sellValuePercentage = n;
    }

    public int getBuyValuePercentage() {
        return this.buyValuePercentage;
    }

    public int getSellValuePercentage() {
        return this.sellValuePercentage;
    }

    public int getCurrentBuyPercentage() {
        return this.currentBuyPercentage;
    }

    public int getCurrentSellPercentage() {
        return this.currentSellPercentage;
    }

    public void sellItem(Item item, Creature creature) {
        this.sellItem(item, creature, 1);
    }

    public void buyItem(Item item, Creature creature) {
        this.buyItem(item, creature, 1);
    }

    public void sellItem(Item item, Creature creature, int n) {
        int n2 = Currency.getPlayerBuyCost(item, n, this.currentSellPercentage).getValue();
        if (Game.curCampaign.getPartyCurrency().getValue() < n2) {
            return;
        }
        Item item2 = EntityManager.getItem(item.getTemplate().getID(), item.getQuality());
        Game.curCampaign.getPartyCurrency().addValue(-n2);
        creature.inventory.getUnequippedItems().add(item2, n);
        if (this.currentItems.getQuantity(item) != Integer.MAX_VALUE) {
            this.currentItems.remove(item, n);
        }
        Game.mainViewer.updateInterface();
    }

    public void buyItem(Item item, Creature creature, int n) {
        if (item.getTemplate().isQuest()) {
            return;
        }
        int n2 = Currency.getPlayerSellCost(item, n, this.currentBuyPercentage).getValue();
        Game.curCampaign.getPartyCurrency().addValue(n2);
        creature.inventory.getUnequippedItems().remove(item, n);
        if (this.currentItems.getQuantity(item) != Integer.MAX_VALUE) {
            this.currentItems.add(item, n);
        }
        Game.mainViewer.updateInterface();
    }
}

