/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.HashMap;
import java.util.Map;
import net.sf.hale.Game;
import net.sf.hale.entity.Entity;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.Saveable;
import net.sf.hale.util.SimpleJSONObject;

public class Faction {
    private String name;
    private Map<String, Relationship> relationships;

    public Faction(String string) {
        this.name = string;
        this.relationships = new HashMap<String, Relationship>();
    }

    public boolean isFriendly(Entity entity) {
        return this.getRelationship(entity) == Relationship.Friendly;
    }

    public boolean isHostile(Entity entity) {
        return this.getRelationship(entity) == Relationship.Hostile;
    }

    public Relationship getRelationship(Entity entity) {
        if (entity == null) {
            return null;
        }
        Faction faction = entity.getFaction();
        if (faction == null) {
            return Relationship.Neutral;
        }
        return this.getRelationship(faction);
    }

    public Relationship getRelationship(String string) {
        Relationship relationship = this.relationships.get(string);
        if (relationship == null) {
            return Relationship.Neutral;
        }
        return relationship;
    }

    public Relationship getRelationship(Faction faction) {
        Relationship relationship = this.relationships.get(faction.getName());
        if (relationship == null) {
            return Relationship.Neutral;
        }
        return relationship;
    }

    public void setRelationship(Faction faction, Relationship relationship) {
        this.relationships.put(faction.getName(), relationship);
    }

    public void setRelationship(String string, Relationship relationship) {
        this.relationships.put(string, relationship);
    }

    public String getName() {
        return this.name;
    }

    public static class CustomRelationship
    implements Saveable {
        public final String faction1;
        public final String faction2;
        public final String relationship;

        public CustomRelationship(String string, String string2, String string3) {
            this.faction1 = string;
            this.faction2 = string2;
            this.relationship = string3;
        }

        @Override
        public Object save() {
            JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
            jSONOrderedObject.put("faction1", this.faction1);
            jSONOrderedObject.put("faction2", this.faction2);
            jSONOrderedObject.put("relationship", this.relationship);
            return jSONOrderedObject;
        }

        public void setFactionRelationships() {
            Faction faction = Game.ruleset.getFaction(this.faction1);
            Faction faction2 = Game.ruleset.getFaction(this.faction2);
            Relationship relationship = Relationship.valueOf(this.relationship);
            faction.setRelationship(faction2, relationship);
            faction2.setRelationship(faction, relationship);
        }

        public static CustomRelationship load(SimpleJSONObject simpleJSONObject) {
            String string = simpleJSONObject.get("faction1", null);
            String string2 = simpleJSONObject.get("faction2", null);
            String string3 = simpleJSONObject.get("relationship", null);
            return new CustomRelationship(string, string2, string3);
        }
    }

    public static enum Relationship {
        Friendly,
        Neutral,
        Hostile;

    }
}

