/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.Random;
import net.sf.hale.Game;

public class Dice {
    private Random generator = new Random();

    public Dice() {
        if (Game.config.randSeedSet()) {
            this.generator.setSeed(Game.config.getRandSeed());
        }
    }

    public float gaussian(float f, float f2) {
        return (float)this.generator.nextGaussian() * f2 + f;
    }

    public double rand(double d, double d2) {
        double d3 = d2 - d;
        return this.generator.nextDouble() * d3 + d;
    }

    public float rand(float f, float f2) {
        float f3 = f2 - f;
        return this.generator.nextFloat() * f3 + f;
    }

    public int randInt(int n, int n2) {
        return this.rand(n, n2);
    }

    public int rand(int n, int n2) {
        int n3 = n2 - n + 1;
        return this.generator.nextInt(n3) + n;
    }

    public int d(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += this.generator.nextInt(n) + 1;
        }
        return n3;
    }

    public int d2(int n) {
        return this.d(2, n);
    }

    public int d3(int n) {
        return this.d(3, n);
    }

    public int d4(int n) {
        return this.d(4, n);
    }

    public int d5(int n) {
        return this.d(5, n);
    }

    public int d6(int n) {
        return this.d(6, n);
    }

    public int d8(int n) {
        return this.d(8, n);
    }

    public int d10(int n) {
        return this.d(10, n);
    }

    public int d12(int n) {
        return this.d(12, n);
    }

    public int d20(int n) {
        return this.d(20, n);
    }

    public int d100(int n) {
        return this.d(100, n);
    }

    public int d2() {
        return this.d(2, 1);
    }

    public int d3() {
        return this.d(3, 1);
    }

    public int d4() {
        return this.d(4, 1);
    }

    public int d5() {
        return this.d(5, 1);
    }

    public int d6() {
        return this.d(6, 1);
    }

    public int d8() {
        return this.d(8, 1);
    }

    public int d10() {
        return this.d(10, 1);
    }

    public int d12() {
        return this.d(12, 1);
    }

    public int d20() {
        return this.d(20, 1);
    }

    public int d100() {
        return this.d(100, 1);
    }
}

