/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.text.NumberFormat;
import net.sf.hale.Game;

public class Date {
    private final NumberFormat numberFormat;
    public int roundMillis;
    private int roundNumber;
    private int rounds;
    private int minutes;
    private int hours;
    private int days;
    private int months;
    public int ROUNDS_PER_MINUTE;
    public int MINUTES_PER_HOUR;
    public int HOURS_PER_DAY;
    public int DAYS_PER_MONTH;
    public int ROUNDS_PER_HOUR;
    public int ROUNDS_PER_DAY;
    public int ROUNDS_PER_MONTH;
    public int MINUTES_PER_DAY;
    public int MINUTES_PER_MONTH;
    public int HOURS_PER_MONTH;

    public Date(int n, int n2, int n3, int n4) {
        this.ROUNDS_PER_MINUTE = n;
        this.MINUTES_PER_HOUR = n2;
        this.HOURS_PER_DAY = n3;
        this.DAYS_PER_MONTH = n4;
        this.computeTimeScales();
        this.roundNumber = 0;
        this.rounds = 1;
        this.minutes = 0;
        this.hours = 0;
        this.days = 0;
        this.months = 0;
        this.numberFormat = NumberFormat.getInstance();
        this.numberFormat.setMinimumIntegerDigits(2);
    }

    private void computeTimeScales() {
        this.ROUNDS_PER_HOUR = this.ROUNDS_PER_MINUTE * this.MINUTES_PER_HOUR;
        this.ROUNDS_PER_DAY = this.ROUNDS_PER_HOUR * this.HOURS_PER_DAY;
        this.ROUNDS_PER_MONTH = this.ROUNDS_PER_DAY * this.DAYS_PER_MONTH;
        this.MINUTES_PER_DAY = this.MINUTES_PER_HOUR * this.HOURS_PER_DAY;
        this.MINUTES_PER_MONTH = this.MINUTES_PER_DAY * this.DAYS_PER_MONTH;
        this.HOURS_PER_MONTH = this.HOURS_PER_DAY * this.DAYS_PER_MONTH;
        this.roundMillis = 60000 / this.ROUNDS_PER_MINUTE;
    }

    public void setRoundsPerMinute(int n) {
        this.ROUNDS_PER_MINUTE = n;
        this.computeTimeScales();
    }

    public void setMinutesPerHour(int n) {
        this.MINUTES_PER_HOUR = n;
        this.computeTimeScales();
    }

    public void setHoursPerDay(int n) {
        this.HOURS_PER_DAY = n;
        this.computeTimeScales();
    }

    public void setDaysPerMonth(int n) {
        this.DAYS_PER_MONTH = n;
        this.computeTimeScales();
    }

    public String getDateString(int n, int n2, int n3, int n4, int n5) {
        int n6 = n * this.ROUNDS_PER_MONTH + n2 * this.ROUNDS_PER_DAY + n3 * this.ROUNDS_PER_HOUR + n4 * this.ROUNDS_PER_MINUTE + n5;
        n5 = n6 % this.ROUNDS_PER_MINUTE;
        n4 = (n6 -= n5) % this.ROUNDS_PER_HOUR / this.ROUNDS_PER_MINUTE;
        n3 = (n6 -= n4 * this.ROUNDS_PER_MINUTE) % this.ROUNDS_PER_DAY / this.ROUNDS_PER_HOUR;
        n2 = (n6 -= n3 * this.ROUNDS_PER_HOUR) % this.ROUNDS_PER_MONTH / this.ROUNDS_PER_DAY;
        n = (n6 -= n2 * this.ROUNDS_PER_DAY) / this.ROUNDS_PER_MONTH;
        return this.shortString(n, n2, n3, n4, n5);
    }

    private void recalculate() {
        int n = this.roundNumber;
        this.rounds = this.roundNumber % this.ROUNDS_PER_MINUTE;
        this.minutes = (n -= this.rounds) % this.ROUNDS_PER_HOUR / this.ROUNDS_PER_MINUTE;
        this.hours = (n -= this.minutes * this.ROUNDS_PER_MINUTE) % this.ROUNDS_PER_DAY / this.ROUNDS_PER_HOUR;
        this.days = (n -= this.hours * this.ROUNDS_PER_HOUR) % this.ROUNDS_PER_MONTH / this.ROUNDS_PER_DAY;
        this.months = (n -= this.days * this.ROUNDS_PER_DAY) / this.ROUNDS_PER_MONTH;
        Game.curCampaign.checkEncounterRespawns();
    }

    public void reset() {
        this.roundNumber = 0;
        this.recalculate();
    }

    public void incrementRounds(int n) {
        this.roundNumber += n;
        this.recalculate();
    }

    public void incrementMinutes(int n) {
        this.roundNumber += n * this.ROUNDS_PER_MINUTE;
        this.recalculate();
    }

    public void incrementHours(int n) {
        this.roundNumber += n * this.ROUNDS_PER_HOUR;
        this.recalculate();
    }

    public void incrementDays(int n) {
        this.roundNumber += n * this.ROUNDS_PER_DAY;
        this.recalculate();
    }

    public void incrementMonths(int n) {
        this.roundNumber += n * this.ROUNDS_PER_MONTH;
        this.recalculate();
    }

    public void incrementRound() {
        this.incrementRounds(1);
    }

    public void incrementMinute() {
        this.incrementMinutes(1);
    }

    public void incrementHour() {
        this.incrementHours(1);
    }

    public void incrementDay() {
        this.incrementDays(1);
    }

    public void incrementMonth() {
        this.incrementMonths(1);
    }

    public int getTotalRoundsElapsed() {
        return this.roundNumber;
    }

    public int getRounds() {
        return this.rounds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getHours() {
        return this.hours;
    }

    public int getDays() {
        return this.days;
    }

    public int getMonths() {
        return this.months;
    }

    private String shortString(int n, int n2, int n3, int n4, int n5) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n != 0) {
            stringBuilder.append(n);
            if (n == 1) {
                stringBuilder.append(" Month ");
            } else {
                stringBuilder.append(" Months ");
            }
        }
        if (n2 != 0) {
            stringBuilder.append(n2);
            if (n2 == 1) {
                stringBuilder.append(" Day ");
            } else {
                stringBuilder.append(" Days ");
            }
        }
        if (n3 != 0) {
            stringBuilder.append(n3);
            if (n3 == 1) {
                stringBuilder.append(" Hour ");
            } else {
                stringBuilder.append(" Hours ");
            }
        }
        if (n4 != 0) {
            stringBuilder.append(n4);
            if (n4 == 1) {
                stringBuilder.append(" Minute ");
            } else {
                stringBuilder.append(" Minutes ");
            }
        }
        if (n5 != 0) {
            stringBuilder.append(n5);
            if (n5 == 1) {
                stringBuilder.append(" Round ");
            } else {
                stringBuilder.append(" Rounds ");
            }
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("0 Minutes");
        }
        return stringBuilder.toString().trim();
    }

    public String monthDayTimeString() {
        return this.numberFormat.format(this.hours) + ":" + this.numberFormat.format(this.minutes) + " Day " + (this.days + 1) + ", Month " + (this.months + 1);
    }

    public String toString() {
        return "Month " + this.months + ", Day " + this.days + ", Hour " + this.hours + ", Minute " + this.minutes + ", Round " + this.rounds;
    }
}

