/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.ArrayList;
import java.util.List;
import net.sf.hale.DifficultyManager;
import net.sf.hale.Game;
import net.sf.hale.entity.Creature;
import net.sf.hale.rules.DamageType;

public class Damage {
    private Creature parent;
    private int totalDamage;
    private String message;
    private List<Entry> entries;

    public Damage(Creature creature) {
        this.parent = creature;
        this.totalDamage = -1;
        this.entries = new ArrayList<Entry>();
    }

    public Damage(Creature creature, DamageType damageType, int n) {
        this(creature);
        this.add(damageType, n);
    }

    private Entry getEntry(DamageType damageType) {
        for (Entry entry : this.entries) {
            if (entry.type != damageType) continue;
            return entry;
        }
        Entry entry = new Entry(damageType);
        this.entries.add(entry);
        return entry;
    }

    public void add(DamageType damageType, int n) {
        Entry entry;
        Entry entry2 = entry = this.getEntry(damageType);
        entry2.damage = entry2.damage + n;
    }

    private void add(Entry entry) {
        this.add(entry.type, entry.damage);
    }

    public void add(Damage damage) {
        for (Entry entry : damage.entries) {
            this.add(entry);
        }
    }

    public int computeAppliedDamage() {
        DifficultyManager difficultyManager = Game.ruleset.getDifficultyManager();
        this.totalDamage = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Entry entry : this.entries) {
            int n = entry.damage;
            if (this.parent.getFaction() == Game.ruleset.getFaction(Game.ruleset.getString("PlayerFaction"))) {
                n = n * difficultyManager.getDamageFactorOnPCs() / 100;
            }
            int n2 = this.parent.stats.getAppliedDamage(n, entry.type);
            this.totalDamage += n2;
            if (entry.type == null) continue;
            int n3 = this.parent.stats.getDamageReduction(entry.type);
            int n4 = this.parent.stats.getDamageImmunity(entry.type);
            stringBuilder.append(" (" + n + " " + entry.type.getName());
            if (n3 > 0) {
                stringBuilder.append(", " + n3 + " Damage Reduction");
            }
            if (n4 > 0) {
                stringBuilder.append(", " + n4 + "% Immune");
            } else if (n4 < 0) {
                stringBuilder.append(", " + -n4 + "% Vulnerable");
            }
            stringBuilder.append(")");
        }
        stringBuilder.append(".");
        stringBuilder.insert(0, this.parent.getTemplate().getName() + " takes " + this.totalDamage + " damage");
        this.message = stringBuilder.toString();
        return this.totalDamage;
    }

    public String getMessage() {
        return this.message;
    }

    public int getTotalAppliedDamage() {
        if (this.totalDamage == -1) {
            throw new IllegalStateException("computeAppliedDamage must be called prior to getTotalAppliedDamage");
        }
        return this.totalDamage;
    }

    public boolean causesDamage() {
        for (Entry entry : this.entries) {
            if (entry.damage <= 0) continue;
            return true;
        }
        return false;
    }

    private class Entry {
        private final DamageType type;
        private int damage;

        private Entry(DamageType damageType) {
            this.type = damageType;
        }
    }
}

