/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import net.sf.hale.entity.Item;
import net.sf.hale.util.Logger;
import net.sf.hale.util.StringParser;

public class Currency {
    private int value;

    public Currency() {
        this.value = 0;
    }

    public Currency(int n) {
        this.value = n;
    }

    public Currency(Currency currency) {
        this.value = currency.value;
    }

    public void setValue(int n) {
        this.value = n;
    }

    public int getValue() {
        return this.value;
    }

    public void addValue(int n) {
        this.value += n;
    }

    public void addCP(int n) {
        this.value += n * 100;
    }

    public void addSP(int n) {
        this.value += n * 1000;
    }

    public void addGP(int n) {
        this.value += n * 10000;
    }

    public void addPP(int n) {
        this.value += n * 100000;
    }

    public void add(Currency currency) {
        this.value += currency.value;
    }

    public String toString() {
        return this.getPP() + " PP " + this.getGP() + " GP " + this.getSP() + " SP " + this.getCP() + " CP";
    }

    private final int getCP() {
        return this.value / 100 % 10;
    }

    private final int getSP() {
        return this.value / 1000 % 10;
    }

    private final int getGP() {
        return this.value / 10000 % 10;
    }

    private final int getPP() {
        return this.value / 100000;
    }

    public String shortString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getPP() != 0) {
            stringBuilder.append(this.getPP() + " PP ");
        }
        if (this.getGP() != 0) {
            stringBuilder.append(this.getGP() + " GP ");
        }
        if (this.getSP() != 0) {
            stringBuilder.append(this.getSP() + " SP ");
        }
        if (this.getCP() != 0) {
            stringBuilder.append(this.getCP() + " CP ");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("0 CP ");
        }
        return stringBuilder.toString().trim();
    }

    public static String shortString(int n, int n2) {
        n = n * n2 / 100;
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = n / 100000;
        int n4 = n / 10000 % 10;
        int n5 = n / 1000 % 10;
        int n6 = n / 100 % 10;
        if (n3 != 0) {
            stringBuilder.append(n3 + " PP ");
        }
        if (n4 != 0) {
            stringBuilder.append(n4 + " GP ");
        }
        if (n5 != 0) {
            stringBuilder.append(n5 + " SP ");
        }
        if (n6 != 0) {
            stringBuilder.append(n6 + " CP ");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("0 CP ");
        }
        return stringBuilder.toString().trim();
    }

    public String shortString(int n) {
        int n2 = this.value;
        this.value = this.value * n / 100;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getPP() != 0) {
            stringBuilder.append(this.getPP() + " PP ");
        }
        if (this.getGP() != 0) {
            stringBuilder.append(this.getGP() + " GP ");
        }
        if (this.getSP() != 0) {
            stringBuilder.append(this.getSP() + " SP ");
        }
        if (this.getCP() != 0) {
            stringBuilder.append(this.getCP() + " CP ");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("0 CP ");
        }
        this.value = n2;
        return stringBuilder.toString().trim();
    }

    public void addFromString(String string) {
        StringParser stringParser = new StringParser(string);
        try {
            while (stringParser.hasNext()) {
                int n = stringParser.nextInt();
                if (stringParser.hasNext()) {
                    String string2 = stringParser.next().toLowerCase();
                    if (string2.equals("cp")) {
                        this.addCP(n);
                        continue;
                    }
                    if (string2.equals("sp")) {
                        this.addSP(n);
                        continue;
                    }
                    if (string2.equals("gp")) {
                        this.addGP(n);
                        continue;
                    }
                    if (!string2.equals("pp")) continue;
                    this.addPP(n);
                    continue;
                }
                Logger.appendToWarningLog("Warning.  Extra token in currency string " + string);
            }
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error parsing currency string.", exception);
        }
    }

    public int getMaxNumberAffordable(Item item, int n) {
        int n2 = item.getQualityValue() * n / 100;
        if (n2 == 0) {
            return Integer.MAX_VALUE;
        }
        return this.value / n2;
    }

    public static Currency getPlayerBuyCost(Item item, int n, int n2) {
        int n3 = item.getQualityValue();
        int n4 = n3 * n * n2 / 100;
        return new Currency(n4);
    }

    public static Currency getPlayerSellCost(Item item, int n, int n2) {
        int n3 = item.getQualityValue();
        int n4 = n3 * n * n2 / 100;
        return new Currency(n4);
    }
}

