/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import de.matthiasmann.twl.Widget;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.sf.hale.AIScriptInterface;
import net.sf.hale.Game;
import net.sf.hale.Party;
import net.sf.hale.ScriptState;
import net.sf.hale.ability.AbilitySlot;
import net.sf.hale.ability.ScriptFunctionType;
import net.sf.hale.area.Area;
import net.sf.hale.area.Transition;
import net.sf.hale.entity.CreatedItem;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Encounter;
import net.sf.hale.entity.EncounterTemplate;
import net.sf.hale.entity.Entity;
import net.sf.hale.entity.EntityManager;
import net.sf.hale.entity.EquippableItemTemplate;
import net.sf.hale.entity.Location;
import net.sf.hale.entity.PC;
import net.sf.hale.loading.JSONOrderedObject;
import net.sf.hale.loading.LoadGameException;
import net.sf.hale.loading.ReferenceHandler;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.resource.Sprite;
import net.sf.hale.resource.SpriteManager;
import net.sf.hale.rules.Currency;
import net.sf.hale.rules.Date;
import net.sf.hale.rules.Faction;
import net.sf.hale.rules.Merchant;
import net.sf.hale.rules.QuestEntryList;
import net.sf.hale.rules.Recipe;
import net.sf.hale.rules.RecipeManager;
import net.sf.hale.rules.Skill;
import net.sf.hale.rules.WorldMapLocation;
import net.sf.hale.rules.XP;
import net.sf.hale.tileset.Tileset;
import net.sf.hale.util.FileUtil;
import net.sf.hale.util.Logger;
import net.sf.hale.util.Point;
import net.sf.hale.util.PointImmutable;
import net.sf.hale.util.SaveGameUtil;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;
import net.sf.hale.view.WorldMapPopup;

public class Campaign {
    private final String id;
    private String startArea;
    private String name;
    private int minPartySize;
    private int maxPartySize;
    private int minStartingLevel;
    private int maxStartingLevel;
    private boolean allowLevelUp;
    private int minCurrency;
    private String worldMapImage;
    private String startingCharacter;
    private Date date;
    private final RecipeManager recipeManager;
    private final Map<String, Tileset> tilesets;
    private final Map<String, EncounterTemplate> encounterTemplates;
    private final Map<String, CreatedItem> createdItems;
    private final List<Faction.CustomRelationship> customRelationships;
    private final Map<String, Merchant> merchants;
    private final Map<String, Transition> transitions;
    private final Map<String, Area> areas;
    public Party party;
    public final Currency partyCurrency;
    public final List<WorldMapLocation> worldMapLocations;
    public QuestEntryList questEntries;
    public ScriptState scriptState;
    public Area curArea;
    private String currentDifficulty;

    public JSONOrderedObject getSaveGameData() {
        Object[] objectArray2;
        JSONOrderedObject jSONOrderedObject = new JSONOrderedObject();
        jSONOrderedObject.put("comment", "Automatically generated Save file.  Edit at your own risk!");
        jSONOrderedObject.put("id", this.id);
        jSONOrderedObject.put("currentDifficulty", this.currentDifficulty);
        jSONOrderedObject.put("date", this.date.getTotalRoundsElapsed());
        jSONOrderedObject.put("partyCurrency", this.partyCurrency.getValue());
        jSONOrderedObject.put("currentArea", SaveGameUtil.getRef(this.curArea));
        jSONOrderedObject.put("party", this.party.save());
        Object[] objectArray4 = new Object[this.areas.size()];
        int n = 0;
        for (String objectArray32 : this.areas.keySet()) {
            objectArray4[n] = this.areas.get(objectArray32).save();
            ++n;
        }
        jSONOrderedObject.put("loadedAreas", objectArray4);
        if (this.createdItems.size() > 0) {
            objectArray2 = new Object[this.createdItems.size()];
            n = 0;
            for (CreatedItem createdItem : this.createdItems.values()) {
                objectArray2[n] = createdItem.save();
                ++n;
            }
            jSONOrderedObject.put("createdItems", objectArray2);
        }
        objectArray2 = new ArrayList();
        for (String string : this.transitions.keySet()) {
            Object object = this.transitions.get(string).save();
            if (object == null) continue;
            objectArray2.add(object);
        }
        jSONOrderedObject.put("transitions", objectArray2.toArray());
        Object[] objectArray = new Object[this.merchants.size()];
        n = 0;
        for (String string : this.merchants.keySet()) {
            objectArray[n] = this.merchants.get(string).save();
            ++n;
        }
        jSONOrderedObject.put("merchants", objectArray);
        jSONOrderedObject.put("questEntries", this.questEntries.save());
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (WorldMapLocation worldMapLocation : this.worldMapLocations) {
            if (!worldMapLocation.isRevealed()) continue;
            arrayList.add(worldMapLocation.save());
        }
        if (arrayList.size() > 0) {
            jSONOrderedObject.put("worldMapLocations", arrayList.toArray());
        }
        if (!this.scriptState.isEmpty()) {
            jSONOrderedObject.put("scriptState", this.scriptState.save());
        }
        if (this.customRelationships.size() > 0) {
            n = 0;
            Object[] objectArray3 = new Object[this.customRelationships.size()];
            for (Faction.CustomRelationship customRelationship : this.customRelationships) {
                objectArray3[n] = customRelationship.save();
                ++n;
            }
            jSONOrderedObject.put("factionRelationships", objectArray3);
        }
        return jSONOrderedObject;
    }

    public void load(SimpleJSONParser simpleJSONParser) throws LoadGameException {
        Object object;
        Object object2;
        Object object32;
        Iterator<SimpleJSONArrayEntry> iterator2;
        ReferenceHandler referenceHandler = new ReferenceHandler();
        if (!this.id.equals(simpleJSONParser.get("id", null))) {
            throw new LoadGameException("Campaign Save file ID does not match");
        }
        Game.ruleset.getDifficultyManager().setCurrentDifficulty(simpleJSONParser.get("currentDifficulty", null));
        this.date.reset();
        this.date.incrementRounds(simpleJSONParser.get("date", 0));
        this.partyCurrency.setValue(simpleJSONParser.get("partyCurrency", 0));
        this.createdItems.clear();
        if (simpleJSONParser.containsKey("createdItems")) {
            for (Iterator<SimpleJSONArrayEntry> iterator2 : simpleJSONParser.getArray("createdItems")) {
                object32 = CreatedItem.load(((SimpleJSONArrayEntry)((Object)iterator2)).getObject());
                this.createdItems.put(((CreatedItem)object32).getCreatedItemID(), (CreatedItem)object32);
            }
        }
        this.areas.clear();
        SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("loadedAreas");
        iterator2 = simpleJSONArray.iterator();
        while (iterator2.hasNext()) {
            object32 = (SimpleJSONArrayEntry)iterator2.next();
            object2 = ((SimpleJSONArrayEntry)object32).getObject();
            object = Area.load((SimpleJSONObject)object2, referenceHandler);
            this.areas.put(((Area)object).getName(), (Area)object);
        }
        this.party = Party.load(simpleJSONParser.getObject("party"), referenceHandler);
        this.curArea = referenceHandler.getArea(simpleJSONParser.get("currentArea", null));
        this.curArea.startEffectAnimations();
        this.loadAreaTransitions();
        for (Object object32 : simpleJSONParser.getArray("transitions")) {
            object2 = ((SimpleJSONArrayEntry)object32).getObject();
            object = ((SimpleJSONObject)object2).get("name", null);
            this.getAreaTransition((String)object).load((SimpleJSONObject)object2);
        }
        this.merchants.clear();
        for (Object object32 : simpleJSONParser.getArray("merchants")) {
            object2 = ((SimpleJSONArrayEntry)object32).getObject();
            object = ((SimpleJSONObject)object2).get("id", null);
            this.getMerchant((String)object).load((SimpleJSONObject)object2);
        }
        this.questEntries = QuestEntryList.load(simpleJSONParser.getObject("questEntries"));
        if (simpleJSONParser.containsKey("worldMapLocations")) {
            for (Object object32 : simpleJSONParser.getArray("worldMapLocations")) {
                object2 = ((SimpleJSONArrayEntry)object32).getObject();
                object = ((SimpleJSONObject)object2).get("name", null);
                boolean bl = ((SimpleJSONObject)object2).get("revealed", false);
                for (WorldMapLocation worldMapLocation : this.worldMapLocations) {
                    if (!worldMapLocation.getName().equals(object)) continue;
                    worldMapLocation.setRevealed(bl);
                }
            }
        }
        this.scriptState = new ScriptState();
        if (simpleJSONParser.containsKey("scriptState")) {
            this.scriptState.load(simpleJSONParser.getObject("scriptState"));
        }
        if (simpleJSONParser.containsKey("factionRelationships")) {
            for (Object object32 : simpleJSONParser.getArray("factionRelationships")) {
                object2 = Faction.CustomRelationship.load(((SimpleJSONArrayEntry)object32).getObject());
                ((Faction.CustomRelationship)object2).setFactionRelationships();
                this.addCustomRelationship((Faction.CustomRelationship)object2);
            }
        }
        referenceHandler.resolveAllReferences();
    }

    public void readCampaignFile() {
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser("campaign" + ResourceType.JSON.getExtension());
        this.name = simpleJSONParser.get("name", null);
        this.startArea = simpleJSONParser.get("startArea", null);
        this.worldMapImage = simpleJSONParser.containsKey("worldMapBackground") ? simpleJSONParser.get("worldMapBackground", null) : null;
        this.startingCharacter = simpleJSONParser.containsKey("startingCharacter") ? simpleJSONParser.get("startingCharacter", null) : null;
        SimpleJSONObject simpleJSONObject = simpleJSONParser.getObject("partySize");
        this.minPartySize = simpleJSONObject.get("min", 0);
        this.maxPartySize = simpleJSONObject.get("max", 0);
        SimpleJSONObject simpleJSONObject2 = simpleJSONParser.getObject("startingLevel");
        this.minStartingLevel = simpleJSONObject2.get("min", 0);
        this.maxStartingLevel = simpleJSONObject2.get("max", 0);
        this.allowLevelUp = simpleJSONParser.containsKey("allowLevelUp") ? simpleJSONParser.get("allowLevelUp", false) : false;
        this.minCurrency = simpleJSONParser.containsKey("minCurrency") ? simpleJSONParser.get("minCurrency", 0) : 0;
        SimpleJSONObject simpleJSONObject3 = simpleJSONParser.getObject("timeConversions");
        int n = simpleJSONObject3.get("roundsPerMinute", 10);
        int n2 = simpleJSONObject3.get("minutesPerHour", 60);
        int n3 = simpleJSONObject3.get("hoursPerDay", 24);
        int n4 = simpleJSONObject3.get("daysPerMonth", 30);
        this.date = new Date(n, n2, n3, n4);
        SimpleJSONArray simpleJSONArray = simpleJSONParser.getArray("locations");
        for (SimpleJSONArrayEntry simpleJSONArrayEntry : simpleJSONArray) {
            this.worldMapLocations.add(new WorldMapLocation(simpleJSONArrayEntry.getObject()));
        }
        simpleJSONParser.warnOnUnusedKeys();
        this.loadAreaTransitions();
        this.loadRecipes();
        this.loadTilesets();
        if (this.startArea != null) {
            this.curArea = this.getArea(this.startArea);
        } else {
            Logger.appendToErrorLog("No start area defined for campaign: " + this.getID());
        }
    }

    public Campaign(String string) {
        this.id = string;
        this.name = "";
        this.areas = new HashMap<String, Area>();
        this.transitions = new HashMap<String, Transition>();
        this.party = new Party();
        this.encounterTemplates = new HashMap<String, EncounterTemplate>();
        this.merchants = new HashMap<String, Merchant>();
        this.recipeManager = new RecipeManager();
        this.partyCurrency = new Currency();
        this.questEntries = new QuestEntryList();
        this.worldMapLocations = new ArrayList<WorldMapLocation>();
        this.createdItems = new HashMap<String, CreatedItem>();
        this.tilesets = new HashMap<String, Tileset>();
        this.scriptState = new ScriptState();
        this.customRelationships = new ArrayList<Faction.CustomRelationship>();
    }

    public void addCustomRelationship(Faction.CustomRelationship customRelationship) {
        this.customRelationships.add(customRelationship);
    }

    public Collection<CreatedItem> getCreatedItems() {
        return this.createdItems.values();
    }

    public CreatedItem getCreatedItem(String string) {
        return this.createdItems.get(string);
    }

    public void addCreatedItem(CreatedItem createdItem) {
        this.createdItems.put(createdItem.getCreatedItemID(), createdItem);
    }

    public int getBestPartySkillCheck(String string) {
        int n = this.getBestPartySkillModifier(string);
        return n + Game.dice.d100();
    }

    public int getBestPartySkillRanks(String string) {
        int n = -1;
        for (Creature creature : this.party) {
            int n2 = creature.skills.getRanks(string);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public int getBestPartySkillModifier(String string) {
        int n = 0;
        for (Creature creature : this.party) {
            int n2 = creature.skills.getTotalModifier(string);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public void addParty(List<String> list, String string) {
        int n = XP.getPointsForLevel(this.minStartingLevel);
        if (this.startingCharacter != null) {
            PC pC = EntityManager.getPC(this.startingCharacter);
            if (this.allowLevelUp && pC.getExperiencePoints() < n) {
                pC.addExperiencePoints(n - pC.getExperiencePoints());
            }
            this.party.add(pC);
        } else {
            for (String string2 : list) {
                PC pC = EntityManager.getPC(string2);
                this.party.add(pC);
            }
        }
        this.party.setName(string);
    }

    public void addPartyCreatures(List<PC> list, String string) {
        for (PC pC : list) {
            this.party.add(pC);
        }
        this.party.setName(string);
    }

    public void checkEncounterRespawns() {
        for (Area area : this.areas.values()) {
            area.checkEncounterRespawns();
        }
    }

    public void transition(String string) {
        Transition transition = this.getAreaTransition(string);
        this.transition(transition, false);
    }

    public void transition(Transition transition, boolean bl) {
        Object object;
        WorldMapLocation worldMapLocation = Game.curCampaign.getWorldMapLocation(transition.getWorldMapLocation());
        if (worldMapLocation != null) {
            worldMapLocation.setRevealed(true);
        }
        this.curArea.runOnAreaExit(transition);
        Transition.EndPoint endPoint = bl ? transition.getEndPointForWorldMap() : transition.getEndPointForCreaturesInCurrentArea();
        if (endPoint == null) {
            throw new IllegalArgumentException("Error transitioning with " + transition.getID() + ". No match for area found.");
        }
        if (endPoint.isWorldMap()) {
            new WorldMapPopup((Widget)Game.mainViewer, transition).openPopupCentered();
            return;
        }
        PC pC = Game.curCampaign.party.getSelected();
        ArrayList<AbilitySlot> arrayList = new ArrayList<AbilitySlot>();
        ListIterator<Creature> listIterator = Game.curCampaign.party.allCreaturesIterator();
        while (listIterator.hasNext()) {
            object = (Creature)listIterator.next();
            arrayList.addAll(((Creature)object).abilities.cancelAllAuras());
            this.curArea.getEntities().removeEntity((Entity)object);
        }
        this.getTileset(this.curArea.getTileset()).freeTiles();
        this.curArea = this.getArea(endPoint.getAreaID());
        this.curArea.runOnAreaLoad(transition);
        object = endPoint.getPartyPositionsIterator();
        pC.setLocation(new Location(this.curArea, (PointImmutable)object.next()));
        this.curArea.getEntities().addEntity(pC);
        listIterator = Game.curCampaign.party.allCreaturesIterator();
        while (listIterator.hasNext()) {
            Creature creature = (Creature)listIterator.next();
            if (creature == pC) continue;
            if (object.hasNext()) {
                creature.setLocation(new Location(this.curArea, (PointImmutable)object.next()));
                this.curArea.getEntities().addEntity(creature);
                continue;
            }
            Point object2 = AIScriptInterface.findClosestEmptyTile(pC.getLocation().toPoint(), 3);
            if (object2 == null) {
                Logger.appendToErrorLog("Unable to find transition space for " + creature.getName() + "in " + transition.getID());
                continue;
            }
            creature.setLocation(new Location(this.curArea, object2));
            this.curArea.getEntities().addEntity(creature);
        }
        Game.mainViewer.addMessage("red", "Entered area " + Game.curCampaign.curArea.getName());
        if (Game.isInTurnMode()) {
            Game.areaListener.getCombatRunner().exitCombat();
        }
        Game.areaViewer.setArea(this.curArea);
        Game.areaListener.setArea(this.curArea);
        this.curArea.setEntityVisibility();
        Game.areaListener.nextTurn();
        Game.areaListener.getCombatRunner().checkAIActivation();
        Game.areaViewer.scrollToCreature(Game.curCampaign.party.getSelected());
        for (AbilitySlot abilitySlot : arrayList) {
            abilitySlot.getAbility().executeFunction(ScriptFunctionType.onReactivate, abilitySlot);
        }
    }

    public WorldMapLocation getWorldMapLocation(String string) {
        for (WorldMapLocation worldMapLocation : this.worldMapLocations) {
            if (!worldMapLocation.getName().equals(string)) continue;
            return worldMapLocation;
        }
        return null;
    }

    public Encounter getEncounter(String string, Location location) {
        EncounterTemplate encounterTemplate = this.encounterTemplates.get(string);
        if (encounterTemplate == null) {
            String string2 = "encounters/" + string;
            SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string2, ResourceType.JSON);
            encounterTemplate = new EncounterTemplate(string, simpleJSONParser);
            this.encounterTemplates.put(string, encounterTemplate);
        }
        return new Encounter(encounterTemplate, location);
    }

    public void removeArea(String string) {
        this.areas.remove(string);
    }

    public Area getArea(String string) {
        Area area = this.areas.get(string);
        if (area == null) {
            try {
                area = new Area(string);
                this.areas.put(string, area);
            }
            catch (Exception exception) {
                Logger.appendToErrorLog("Error loading area " + string, exception);
            }
        }
        return area;
    }

    public void loadAreaTransitions() {
        this.transitions.clear();
        Set<String> set = ResourceManager.getResourcesInDirectory("transitions");
        for (String string : set) {
            String string2 = ResourceManager.getResourceID(string, "transitions", ResourceType.JSON);
            if (string2 == null) continue;
            this.getAreaTransition(string2);
        }
    }

    private void loadTilesets() {
        for (String string : ResourceManager.getResourcesInDirectory("tilesets")) {
            String string2;
            String string3 = FileUtil.getRelativePath("tilesets", string);
            if (string3.contains("/") || string3.contains(File.separator) || (string2 = ResourceManager.getResourceID(string, "tilesets", ResourceType.JSON)) == null) continue;
            Tileset tileset = new Tileset(string2, string);
            this.tilesets.put(string2, tileset);
        }
    }

    public void loadRecipes() {
        this.recipeManager.loadRecipes();
    }

    public Transition getAreaTransition(String string) {
        Transition transition = this.transitions.get(string);
        if (transition == null) {
            transition = new Transition(string);
            this.transitions.put(string, transition);
        }
        return transition;
    }

    public Merchant getMerchant(String string) {
        Merchant merchant = this.merchants.get(string);
        if (merchant == null && (merchant = new Merchant(string)) != null) {
            this.merchants.put(string, merchant);
        }
        return merchant;
    }

    public Recipe getRecipe(String string) {
        return this.recipeManager.getRecipe(string);
    }

    public void setCurrentDifficulty(String string) {
        this.currentDifficulty = string;
    }

    public Sprite getWorldMapSprite() {
        if (this.worldMapImage == null) {
            return null;
        }
        return SpriteManager.getSpriteAnyExtension(this.worldMapImage);
    }

    public String getWorldMapImage() {
        return this.worldMapImage;
    }

    public String getStartArea() {
        return this.startArea;
    }

    public Tileset getTileset(String string) {
        return this.tilesets.get(string);
    }

    public List<String> getRecipeIDsForSkill(Skill skill) {
        return this.recipeManager.getRecipeIDsForSkill(skill);
    }

    public List<String> getEnchantmentsForItemType(EquippableItemTemplate.Type type) {
        return this.recipeManager.getEnchantmentsForItemType(type);
    }

    public Collection<Transition> getAreaTransitions() {
        return this.transitions.values();
    }

    public String getStartingCharacter() {
        return this.startingCharacter;
    }

    public Currency getPartyCurrency() {
        return this.partyCurrency;
    }

    public int getMinPartySize() {
        return this.minPartySize;
    }

    public int getMaxPartySize() {
        return this.maxPartySize;
    }

    public int getMinStartingLevel() {
        return this.minStartingLevel;
    }

    public int getMaxStartingLevel() {
        return this.maxStartingLevel;
    }

    public Date getDate() {
        return this.date;
    }

    public String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public boolean allowLevelUp() {
        return this.allowLevelUp;
    }

    public int getMinCurrency() {
        return this.minCurrency;
    }
}

