/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.rules;

import java.util.List;
import net.sf.hale.Game;
import net.sf.hale.area.AreaEntityList;
import net.sf.hale.bonus.Bonus;
import net.sf.hale.bonus.Stat;
import net.sf.hale.entity.Ammo;
import net.sf.hale.entity.Creature;
import net.sf.hale.entity.Inventory;
import net.sf.hale.entity.Weapon;
import net.sf.hale.entity.WeaponTemplate;
import net.sf.hale.rules.Damage;
import net.sf.hale.rules.Faction;
import net.sf.hale.rules.RacialType;
import net.sf.hale.util.AreaUtil;
import net.sf.hale.util.Point;

public class Attack {
    private int attackRoll = 0;
    private int damageRoll = 0;
    private int threatRoll = 0;
    private int baseAttackBonus = 0;
    private int attackBonus = 0;
    private float damageBonus = 0.0f;
    private int totalAttack = 0;
    private int totalDamage = 0;
    private int rangePenalty = 0;
    private int defenderAC = 0;
    private int extraDamage = 0;
    private int extraAttack = 0;
    private boolean negateDamage = false;
    private Damage damage = null;
    private int damageMin = 0;
    private int damageMax = 0;
    private int appliedDamage = 0;
    private int flankingBonus = 0;
    private boolean flankingAttack = false;
    private boolean hit = false;
    private boolean meleeTouchAttack = false;
    private boolean rangedTouchAttack = false;
    private Creature attacker;
    private Creature defender;
    private Weapon weapon;
    private Inventory.Slot inventorySlot;
    private StringBuilder message;

    public boolean damageNegated() {
        return this.negateDamage;
    }

    public void negateDamage() {
        this.negateDamage = true;
    }

    public void addDamage(Damage damage) {
        this.damage.add(damage);
    }

    public Damage getDamage() {
        return this.damage;
    }

    public String getMessage() {
        return this.message.toString();
    }

    public int getExtraAttack() {
        return this.extraAttack;
    }

    public int getExtraDamage() {
        return this.extraDamage;
    }

    public int getAppliedDamage() {
        return this.appliedDamage;
    }

    public int getFlankingBonus() {
        return this.flankingBonus;
    }

    public boolean isFlankingAttack() {
        return this.flankingAttack;
    }

    public boolean isMeleeWeaponAttack() {
        if (this.meleeTouchAttack || this.rangedTouchAttack) {
            return false;
        }
        if (this.weapon == null) {
            return false;
        }
        return this.weapon.isMelee();
    }

    public boolean isRangedWeaponAttack() {
        if (this.meleeTouchAttack || this.rangedTouchAttack) {
            return false;
        }
        if (this.weapon == null) {
            return false;
        }
        return this.weapon.isRanged();
    }

    public boolean isRanged() {
        if (this.rangedTouchAttack) {
            return true;
        }
        if (this.weapon == null) {
            return false;
        }
        return this.weapon.isRanged();
    }

    public boolean causesDamage() {
        if (this.damage == null) {
            return false;
        }
        return this.damage.causesDamage();
    }

    public int getAttackRoll() {
        return this.attackRoll;
    }

    public int getDamageRoll() {
        return this.damageRoll;
    }

    public int getThreatRoll() {
        return this.threatRoll;
    }

    public int getBaseAttackBonus() {
        return this.baseAttackBonus;
    }

    public int getAttackBonus() {
        return this.attackBonus;
    }

    public float getDamageBonus() {
        return this.damageBonus;
    }

    public int getTotalAttack() {
        return this.totalAttack;
    }

    public int getTotalDamage() {
        return this.totalDamage;
    }

    public int getRangePenalty() {
        return this.rangePenalty;
    }

    public int getDefenderAC() {
        return this.defenderAC;
    }

    public int getMinimumDamage() {
        return this.damageMin;
    }

    public int getMaximumDamage() {
        return this.damageMax;
    }

    public Creature getAttacker() {
        return this.attacker;
    }

    public Creature getDefender() {
        return this.defender;
    }

    public Weapon getWeapon() {
        return this.weapon;
    }

    public Inventory.Slot getSlot() {
        return this.inventorySlot;
    }

    public void addExtraAttack(int n) {
        this.extraAttack += n;
    }

    public void addExtraDamage(int n) {
        this.extraDamage += n;
    }

    public void setAppliedDamage(int n) {
        this.appliedDamage = n;
    }

    public void setDefenderAC(int n) {
        this.defenderAC = n;
    }

    public void setFlankingBonus(int n) {
        this.flankingBonus = n;
    }

    public void setFlankingAttack(boolean bl) {
        this.flankingAttack = bl;
    }

    public Attack(Creature creature, Creature creature2, boolean bl) {
        this.attacker = creature;
        this.defender = creature2;
        this.meleeTouchAttack = !bl;
        this.rangedTouchAttack = bl;
        this.defenderAC = creature2.stats.get(Stat.TouchArmorClass) + Game.curCampaign.curArea.getConcealment(creature, creature2);
        this.attackBonus = creature.stats.get(Stat.LevelAttackBonus) + creature.stats.get(Stat.TouchAttackBonus);
        for (RacialType racialType : creature.getTemplate().getRace().getRacialTypes()) {
            this.defenderAC += creature2.stats.get(racialType.getName(), Bonus.Type.ArmorClassVsRacialType);
        }
        for (RacialType racialType : creature2.getTemplate().getRace().getRacialTypes()) {
            this.attackBonus += creature.stats.get(racialType.getName(), Bonus.Type.AttackVsRacialType);
        }
        this.attackRoll = Game.dice.d100();
        this.totalAttack = this.attackRoll + this.attackBonus;
    }

    public Attack(Creature creature, Creature creature2) {
        this.attacker = creature;
        this.defender = creature2;
    }

    public Attack(Creature creature, Creature creature2, Inventory.Slot slot) {
        this.attacker = creature;
        this.defender = creature2;
        this.message = new StringBuilder();
        this.inventorySlot = slot;
        this.baseAttackBonus = creature.stats.get(Stat.LevelAttackBonus);
        switch (this.inventorySlot) {
            case MainHand: {
                this.damageBonus = 1.0f + (float)creature.stats.get(Stat.MainHandDamageBonus) / 100.0f;
                this.attackBonus = creature.stats.get(Stat.MainHandAttackBonus);
                break;
            }
            case OffHand: {
                this.damageBonus = 1.0f + (float)creature.stats.get(Stat.OffHandDamageBonus) / 100.0f;
                this.attackBonus = creature.stats.get(Stat.OffHandAttackBonus);
                break;
            }
            default: {
                throw new IllegalArgumentException("Attacks can only be made with main or off hand weapons");
            }
        }
        this.weapon = (Weapon)creature.inventory.getEquippedItem(slot);
        if (this.weapon == null) {
            this.weapon = creature.getTemplate().getRace().getDefaultWeapon();
        }
        int n = Game.curCampaign.curArea.getConcealment(creature, creature2);
        if (this.weapon.isRanged()) {
            n = Math.max(0, n - creature.stats.get(Bonus.Type.ConcealmentIgnoringRanged));
        }
        this.defenderAC = creature2.stats.get(Stat.ArmorClass) + n;
        for (RacialType racialType : creature.getTemplate().getRace().getRacialTypes()) {
            this.defenderAC += creature2.stats.get(racialType.getName(), Bonus.Type.ArmorClassVsRacialType);
        }
        for (RacialType racialType : creature2.getTemplate().getRace().getRacialTypes()) {
            this.attackBonus += creature.stats.get(racialType.getName(), Bonus.Type.AttackVsRacialType);
            this.damageBonus += (float)creature.stats.get(racialType.getName(), Bonus.Type.DamageVsRacialType) / 100.0f;
        }
        Ammo ammo = (Ammo)creature.inventory.getEquippedItem(Inventory.Slot.Quiver);
        int n2 = 0;
        int n3 = 0;
        if (!this.weapon.isMelee() && ammo != null) {
            int n4 = this.weapon.getTemplate().getRangePenalty() * (100 - creature.stats.get(Bonus.Type.RangePenalty)) / 100;
            int n5 = creature.getLocation().getDistance(creature2.getLocation());
            this.rangePenalty += n5 * n4 / 20;
            if (this.weapon.getTemplate().getWeaponType() != WeaponTemplate.Type.Thrown) {
                n2 = ammo.getQualityAttackBonus() + ammo.bonuses.get(Bonus.Type.WeaponAttack);
                n3 = ammo.getQualityAttackBonus() + ammo.bonuses.get(Bonus.Type.WeaponDamage);
            }
        }
        this.attackRoll = Game.dice.d100();
        this.damageRoll = Game.dice.rand(this.weapon.getTemplate().getMinDamage(), this.weapon.getTemplate().getMaxDamage());
        this.damageBonus += (float)creature.stats.get(Stat.LevelDamageBonus) / 100.0f;
        this.damageBonus += (float)(this.weapon.getQualityDamageBonus() + this.weapon.bonuses.get(Bonus.Type.WeaponDamage)) / 100.0f;
        this.damageBonus += (float)n3 / 100.0f;
        this.attackBonus += this.baseAttackBonus - this.rangePenalty;
        this.attackBonus += this.weapon.bonuses.get(Bonus.Type.WeaponAttack) + this.weapon.getQualityAttackBonus() + n2;
        this.damageBonus += (float)creature.stats.get(this.weapon.getTemplate().getDamageType().getName(), Bonus.Type.DamageForWeaponType) / 100.0f;
        this.attackBonus += creature.stats.get(this.weapon.getTemplate().getDamageType().getName(), Bonus.Type.AttackForWeaponType);
        this.totalAttack = this.attackRoll + this.attackBonus;
        this.totalDamage = Math.round((float)this.damageRoll * this.damageBonus);
        this.damageMin = Math.round((float)this.weapon.getTemplate().getMinDamage() * this.damageBonus);
        this.damageMax = Math.round((float)this.weapon.getTemplate().getMaxDamage() * this.damageBonus);
        this.damage = new Damage(creature2, this.weapon.getTemplate().getDamageType(), this.totalDamage);
        this.damage.add(creature.stats.rollStandaloneDamage(creature2));
    }

    public void computeFlankingBonus(AreaEntityList areaEntityList) {
        Point point = AreaUtil.convertGridToScreenAndCenter(this.attacker.getLocation().getX(), this.attacker.getLocation().getY());
        Point point2 = AreaUtil.convertGridToScreenAndCenter(this.defender.getLocation().getX(), this.defender.getLocation().getY());
        List<Creature> list = areaEntityList.getCreaturesWithinRadius(this.defender.getLocation().getX(), this.defender.getLocation().getY(), Game.curCampaign.curArea.getVisibilityRadius());
        for (Creature creature : list) {
            double d;
            double d2;
            double d3;
            double d4;
            if (creature == this.attacker || creature == this.defender || !creature.threatensLocation(this.defender.getLocation()) || creature.getFaction().getRelationship(this.defender) != Faction.Relationship.Hostile) continue;
            Point point3 = AreaUtil.convertGridToScreenAndCenter(creature.getLocation().getX(), creature.getLocation().getY());
            double d5 = AreaUtil.euclideanDistance2(point2.x, point2.y, point3.x, point3.y);
            double d6 = Math.acos((d5 + (d4 = (double)AreaUtil.euclideanDistance2(point2.x, point2.y, point.x, point.y)) - (d3 = (double)AreaUtil.euclideanDistance2(point.x, point.y, point3.x, point3.y))) / (2.0 * (d2 = Math.sqrt(d5)) * (d = Math.sqrt(d4)))) * 360.0 / (Math.PI * 2);
            if (!(d6 > 140.0 - (double)this.attacker.stats.get(Bonus.Type.FlankingAngle))) continue;
            this.flankingBonus = 20;
            this.flankingAttack = true;
            Game.mainViewer.addMessage("green", this.attacker.getTemplate().getName() + " and " + creature.getTemplate().getName() + " are flanking " + this.defender.getTemplate().getName());
            return;
        }
    }

    public boolean isHit() {
        return this.hit;
    }

    public boolean computeIsHit() {
        this.attackBonus += this.flankingBonus;
        this.totalAttack += this.flankingBonus;
        if (this.meleeTouchAttack) {
            return this.isHitMeleeTouch();
        }
        if (this.rangedTouchAttack) {
            return this.isHitRangedTouch();
        }
        return this.isHitNormal();
    }

    private boolean isHitRangedTouch() {
        this.message = new StringBuilder();
        this.message.append(this.attacker.getTemplate().getName() + " attempts ranged touch attack on " + this.defender.getTemplate().getName() + ": ");
        this.message.append(this.attackRoll + " + " + this.attackBonus + " = " + this.totalAttack + " vs " + this.defenderAC + ".  ");
        if (this.attackRoll > 97 || this.attackRoll > 2 && this.totalAttack >= this.defenderAC) {
            this.message.append("Succeeds.");
            this.hit = true;
        } else {
            this.message.append("Miss.");
            this.hit = false;
        }
        return this.hit;
    }

    private boolean isHitMeleeTouch() {
        this.message = new StringBuilder();
        this.message.append(this.attacker.getTemplate().getName() + " attempts melee touch attack on " + this.defender.getTemplate().getName() + ": ");
        this.message.append(this.attackRoll + " + " + this.attackBonus + " = " + this.totalAttack + " vs " + this.defenderAC + ".  ");
        if (this.attackRoll > 97 || this.attackRoll > 2 && this.totalAttack >= this.defenderAC) {
            this.message.append("Succeeds.");
            this.hit = true;
        } else {
            this.message.append("Miss.");
            this.hit = false;
        }
        return this.hit;
    }

    private boolean isHitNormal() {
        boolean bl;
        Ammo ammo;
        this.message = new StringBuilder();
        if (this.weapon.getTemplate().getWeaponType() == WeaponTemplate.Type.Thrown) {
            this.attacker.inventory.remove(this.weapon);
        } else if (!this.weapon.isMelee() && (ammo = (Ammo)this.attacker.inventory.getEquippedItem(Inventory.Slot.Quiver)) != null) {
            this.attacker.inventory.remove(ammo);
        }
        if (this.attacker.getOffHandWeapon() != null) {
            switch (this.inventorySlot) {
                case MainHand: {
                    this.message.append("<span style=\"font-family:green;\">[Main hand attack]</span> ");
                    break;
                }
                case OffHand: {
                    this.message.append("<span style=\"font-family:green;\">[Off hand attack]</span> ");
                    break;
                }
            }
        }
        if (!(bl = this.defender.stats.has(Bonus.Type.CriticalHitImmunity))) {
            this.totalAttack += this.extraAttack;
            this.attackBonus += this.extraAttack;
        }
        this.message.append(this.attacker.getTemplate().getName() + " attacks " + this.defender.getTemplate().getName() + ": " + this.attackToString() + " vs AC " + this.defenderAC);
        if (this.attackRoll > 97 || this.attackRoll > 2 && this.totalAttack >= this.defenderAC) {
            this.hit = true;
            int n = this.weapon.getTemplate().getCriticalThreat() - this.attacker.stats.get(this.weapon.getTemplate().getBaseWeapon().getName(), Bonus.Type.BaseWeaponCriticalChance) - this.weapon.bonuses.get(Bonus.Type.WeaponCriticalChance);
            if (this.attackRoll >= n && !bl) {
                boolean bl2;
                this.threatRoll = Game.dice.d100();
                this.message.append(". Critical threat: " + this.threatToString());
                int n2 = this.threatRoll + this.attackBonus;
                boolean bl3 = bl2 = n2 > 97 || n2 >= this.defenderAC;
                if (this.defender.isPlayerFaction() && !Game.ruleset.getDifficultyManager().criticalHitsOnPCs()) {
                    bl2 = false;
                }
                if (bl2) {
                    this.message.append(". Critical Hit");
                    int n3 = this.weapon.getTemplate().getCriticalMultiplier() + this.attacker.stats.get(this.weapon.getTemplate().getBaseWeapon().getName(), Bonus.Type.BaseWeaponCriticalMultiplier) + this.weapon.bonuses.get(Bonus.Type.WeaponCriticalMultiplier);
                    this.damage.add(this.weapon.getTemplate().getDamageType(), this.totalDamage * (n3 - 1));
                    this.damageRoll *= n3;
                    this.totalDamage *= n3;
                    Game.areaViewer.addScreenShake();
                } else {
                    this.message.append(". Normal Hit");
                }
            } else {
                this.message.append(". Hit");
            }
            if (!bl) {
                this.damage.add(this.weapon.getTemplate().getDamageType(), this.extraDamage);
                this.totalDamage += this.extraDamage;
            }
            if (bl && (this.attackRoll >= n || this.extraDamage > 0 || this.extraAttack > 0)) {
                this.message.append(". ").append(this.defender.getTemplate().getName()).append(" is immune to critical hits");
            }
            this.message.append(". ");
        } else {
            this.hit = false;
            this.message.append(". Miss.");
        }
        return this.hit;
    }

    public int computeAppliedDamage() {
        this.appliedDamage = this.damage.computeAppliedDamage();
        return this.appliedDamage;
    }

    public String threatToString() {
        return this.threatRoll + " + " + this.attackBonus + " = " + (this.threatRoll + this.attackBonus);
    }

    public String attackToString() {
        return this.attackRoll + " + " + this.attackBonus + " = " + this.totalAttack;
    }

    public String damageToString() {
        String string = this.damageRoll + " * " + Game.numberFormat(3).format(this.damageBonus);
        if (this.extraDamage != 0) {
            string = string + " + " + this.extraDamage;
        }
        return string + " = " + this.totalDamage;
    }

    public String toString() {
        return "Rolled " + this.attackToString() + " for " + this.damageToString() + " Damage";
    }
}

