/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.resource;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.hale.resource.PackageType;
import net.sf.hale.resource.ResourcePackage;
import net.sf.hale.util.Logger;

public class ZipResourcePackage
extends ResourcePackage {
    private final ZipFile file;

    public ZipResourcePackage(ZipFile zipFile, PackageType packageType) {
        super(packageType);
        this.file = zipFile;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            if (zipEntry.isDirectory()) continue;
            this.entries.add(zipEntry.getName());
        }
    }

    @Override
    public InputStream getStream(String string) {
        try {
            return this.file.getInputStream(this.file.getEntry(string));
        }
        catch (Exception exception) {
            Logger.appendToErrorLog("Error getting stream from " + string, exception);
            return null;
        }
    }
}

