/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.resource;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.sf.hale.Game;
import net.sf.hale.resource.ResourceManager;
import net.sf.hale.resource.ResourceType;
import net.sf.hale.resource.Sprite;
import net.sf.hale.util.Logger;
import net.sf.hale.util.SimpleJSONArray;
import net.sf.hale.util.SimpleJSONArrayEntry;
import net.sf.hale.util.SimpleJSONObject;
import net.sf.hale.util.SimpleJSONParser;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class SpriteManager {
    private static final Map<String, Sprite> sprites = new HashMap<String, Sprite>();
    private static final Map<String, Sprite> spriteSheets = new HashMap<String, Sprite>();

    public static void loadSpriteSheets() {
        Set<String> set = ResourceManager.getResourcesInDirectory("images");
        for (String string : set) {
            if (!string.endsWith(ResourceType.JSON.getExtension())) continue;
            SpriteManager.readSpriteSheet(string);
        }
    }

    public static void loadAllPortraits() {
        for (String string : ResourceManager.getResourcesInDirectory("portraits")) {
            if (!string.endsWith(ResourceType.PNG.getExtension())) continue;
            SpriteManager.getImage(string);
        }
    }

    public static List<String> readSpriteSheet(String string) {
        ArrayList<Sprite> arrayList = new ArrayList<Sprite>();
        ByteBufferSized byteBufferSized = null;
        String string2 = new File(string).getParent().replace('\\', '/');
        ArrayList<String> arrayList2 = new ArrayList<String>();
        SimpleJSONParser simpleJSONParser = new SimpleJSONParser(string);
        int n = simpleJSONParser.get("gridSize", 0);
        String string3 = simpleJSONParser.get("source", null);
        String string4 = simpleJSONParser.get("category", null);
        String string5 = string4 != null ? string4 : string3;
        byteBufferSized = SpriteManager.loadPixels(string2 + "/" + string3 + ".png");
        Sprite sprite = new Sprite(0, byteBufferSized.width, byteBufferSized.height);
        arrayList.add(sprite);
        SimpleJSONObject simpleJSONObject = simpleJSONParser.getObject("images");
        for (String string6 : simpleJSONObject.keySet()) {
            int n2;
            int n3;
            SimpleJSONArray simpleJSONArray = simpleJSONObject.getArray(string6);
            Iterator<SimpleJSONArrayEntry> iterator = simpleJSONArray.iterator();
            int n4 = iterator.next().getInt(0);
            int n5 = iterator.next().getInt(0);
            if (iterator.hasNext()) {
                n3 = iterator.next().getInt(0);
                n2 = iterator.next().getInt(0);
            } else {
                n3 = n;
                n2 = n;
                n4 *= n;
                n5 *= n;
            }
            String string7 = string2 + "/" + string5 + "/" + string6 + ".png";
            double d = (double)n4 / (double)sprite.getWidth();
            double d2 = (double)n5 / (double)sprite.getHeight();
            double d3 = (double)(n4 + n3) / (double)sprite.getWidth();
            double d4 = (double)(n5 + n2) / (double)sprite.getHeight();
            Sprite sprite2 = new Sprite(sprite.getTextureReference(), n3, n2, d, d2, d3, d4);
            arrayList2.add(string5 + "/" + string6);
            if (sprites.containsKey(string7)) {
                Logger.appendToWarningLog("Warning, overwriting sprite " + string7);
            }
            sprites.put(string7, sprite2);
            arrayList.add(sprite2);
        }
        String string8 = string2 + "/" + string3;
        Game.textureLoader.loadTexture(byteBufferSized.pixels, byteBufferSized.width, byteBufferSized.height, arrayList);
        if (spriteSheets.containsKey(string8)) {
            Logger.appendToWarningLog("Warning, SpriteSheet " + (String)string8 + " is being overwritten.  This is a texture memory leak.");
        }
        spriteSheets.put(string8, sprite);
        return arrayList2;
    }

    public static String getResourceID(String string) {
        if (SpriteManager.getSprite(string, ResourceType.PNG) != null) {
            return "images/" + string + ResourceType.PNG.getExtension();
        }
        if (SpriteManager.getSprite(string, ResourceType.JPEG) != null) {
            return "images/" + string + ResourceType.JPEG.getExtension();
        }
        if (SpriteManager.getPortrait(string) != null) {
            return "portraits/" + string + ResourceType.PNG.getExtension();
        }
        return null;
    }

    public static Set<String> getSpriteIDs() {
        return Collections.unmodifiableSet(sprites.keySet());
    }

    public static final boolean hasSprite(String string) {
        if (string.endsWith(ResourceType.PNG.getExtension())) {
            return sprites.containsKey(string);
        }
        return sprites.containsKey("images/" + string + ResourceType.PNG.getExtension());
    }

    public static final Sprite getSpriteAnyExtension(String string) {
        Sprite sprite = SpriteManager.getImage("images/" + string + ResourceType.PNG.getExtension());
        if (sprite != null) {
            return sprite;
        }
        sprite = SpriteManager.getImage("images/" + string + ResourceType.JPEG.getExtension());
        return sprite;
    }

    public static final Sprite getSprite(String string, ResourceType resourceType) {
        return SpriteManager.getImage("images/" + string + resourceType.getExtension());
    }

    public static final Sprite getSprite(String string) {
        return SpriteManager.getImage("images/" + string + ResourceType.PNG.getExtension());
    }

    public static final Sprite getPortrait(String string) {
        return SpriteManager.getImage("portraits/" + string + ResourceType.PNG.getExtension());
    }

    public static final Sprite getImage(String string) {
        if (!sprites.containsKey(string) && ResourceManager.hasResource(string)) {
            sprites.put(string, SpriteManager.loadImage(string));
        }
        return sprites.get(string);
    }

    private static final ByteBufferSized loadPixels(String string) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(ResourceManager.getStream(string));
        }
        catch (IOException iOException) {
            Logger.appendToErrorLog("Failed to load image: " + string, iOException);
            throw new IllegalArgumentException("Image does not exist at " + string);
        }
        int[] nArray = new int[bufferedImage.getWidth() * bufferedImage.getHeight()];
        bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), nArray, 0, bufferedImage.getWidth());
        byte[] byArray = new byte[nArray.length * 4];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[4 * i + 3] = (byte)(nArray[i] >>> 24);
            byArray[4 * i + 0] = (byte)(nArray[i] >>> 16);
            byArray[4 * i + 1] = (byte)(nArray[i] >>> 8);
            byArray[4 * i + 2] = (byte)nArray[i];
        }
        ByteBuffer byteBuffer = (ByteBuffer)BufferUtils.createByteBuffer((int)byArray.length).put(byArray).flip();
        ByteBufferSized byteBufferSized = new ByteBufferSized(byteBuffer, bufferedImage.getWidth(), bufferedImage.getHeight());
        return byteBufferSized;
    }

    private static final Sprite loadImage(String string) {
        ByteBufferSized byteBufferSized = SpriteManager.loadPixels(string);
        Sprite sprite = new Sprite(0, byteBufferSized.width, byteBufferSized.height);
        List<Sprite> list = Collections.singletonList(sprite);
        Game.textureLoader.loadTexture(byteBufferSized.pixels, byteBufferSized.width, byteBufferSized.height, list);
        return sprite;
    }

    public static void clear() {
        Integer n;
        Sprite sprite;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (String string : spriteSheets.keySet()) {
            sprite = spriteSheets.get(string);
            n = sprite.getTextureReference();
            if (hashSet.contains(n)) continue;
            GL11.glDeleteTextures((int)n);
            hashSet.add(n);
        }
        for (String string : sprites.keySet()) {
            sprite = sprites.get(string);
            n = sprite.getTextureReference();
            if (hashSet.contains(n)) continue;
            GL11.glDeleteTextures((int)n);
            hashSet.add(n);
        }
        sprites.clear();
        spriteSheets.clear();
    }

    public static void freeTexture(Sprite sprite) {
        Sprite sprite2;
        int n = sprite.getTextureReference();
        GL11.glDeleteTextures((int)n);
        Iterator<String> iterator = spriteSheets.keySet().iterator();
        while (iterator.hasNext()) {
            sprite2 = spriteSheets.get(iterator.next());
            if (sprite2.getTextureReference() != n) continue;
            iterator.remove();
        }
        iterator = sprites.keySet().iterator();
        while (iterator.hasNext()) {
            sprite2 = sprites.get(iterator.next());
            if (sprite2.getTextureReference() != n) continue;
            iterator.remove();
        }
    }

    public static long getTextureMemoryUsage() {
        long l;
        Integer n;
        Sprite sprite;
        long l2 = 0L;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (String string : spriteSheets.keySet()) {
            sprite = spriteSheets.get(string);
            n = sprite.getTextureReference();
            if (hashSet.contains(n)) continue;
            hashSet.add(n);
            l = sprite.getWidth() * sprite.getHeight() * 4;
            l2 += l;
        }
        for (String string : sprites.keySet()) {
            sprite = sprites.get(string);
            n = sprite.getTextureReference();
            if (hashSet.contains(n)) continue;
            hashSet.add(n);
            l = sprite.getWidth() * sprite.getHeight() * 4;
            l2 += l;
        }
        return l2;
    }

    private static class ByteBufferSized {
        private ByteBuffer pixels;
        private int width;
        private int height;

        private ByteBufferSized(ByteBuffer byteBuffer, int n, int n2) {
            this.pixels = byteBuffer;
            this.width = n;
            this.height = n2;
        }
    }
}

