/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hale.resource;

import java.io.InputStream;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.hale.resource.PackageType;
import net.sf.hale.resource.ResourceType;

public abstract class ResourcePackage
implements Comparable<ResourcePackage> {
    protected final TreeSet<String> entries = new TreeSet();
    private final PackageType type;

    public ResourcePackage(PackageType packageType) {
        this.type = packageType;
    }

    public void removeResource(String string) {
        this.entries.remove(string);
    }

    public void addResource(String string) {
        this.entries.add(string);
    }

    public SortedSet<String> getResourcesIn(String string) {
        String string2 = this.entries.ceiling(string + "/");
        String string3 = this.entries.ceiling(string + '\uffff');
        if (string2 == null) {
            return null;
        }
        if (string3 == null) {
            return this.entries.tailSet(string2);
        }
        return this.entries.subSet(string2, string3);
    }

    public abstract InputStream getStream(String var1);

    public PackageType getType() {
        return this.type;
    }

    public boolean hasResource(String string) {
        return this.entries.contains(string);
    }

    public boolean hasResource(String string, ResourceType resourceType) {
        return this.entries.contains(string + resourceType.getExtension());
    }

    public InputStream getStream(String string, ResourceType resourceType) {
        return this.getStream(string + resourceType.getExtension());
    }

    @Override
    public int compareTo(ResourcePackage resourcePackage) {
        return this.type.compareTo(resourcePackage.type);
    }
}

